# 機能設計書 14-cc

## 概要

本ドキュメントは、Zigコンパイラに組み込まれたドロップインCコンパイラ機能「cc」の設計仕様を記載する。`zig cc`コマンドは、ZigをGCC/Clang互換のCコンパイラとして使用するためのインターフェースを提供する。

### 本機能の処理概要

**業務上の目的・背景**：多くの既存プロジェクトはCコンパイラ（gcc, clang等）を前提としたビルドシステムを使用している。Zigは高品質なクロスコンパイル機能と、バンドルされたlibc実装を持つため、環境構築の煩雑さなく任意のターゲット向けにCコードをコンパイルできる。本機能は、既存のビルドシステム（Make, CMake, Autotools等）を変更することなく、環境変数`CC=zig cc`を設定するだけでZigのクロスコンパイル機能を活用できるようにする。

**機能の利用シーン**：
- クロスコンパイル環境を簡単にセットアップしたい場合（例：LinuxでWindows向けバイナリを生成）
- プロジェクトのCコンパイラをZig ccに置き換えてビルドを高速化したい場合
- musl libc等の静的リンク環境でビルドしたい場合
- 特定のターゲット向けに最適化されたバイナリを生成したい場合
- CI/CD環境で一貫したビルド環境を構築したい場合

**主要な処理内容**：
1. GCC/Clang互換のコマンドライン引数を解析
2. ターゲットプラットフォームの決定
3. 必要に応じてバンドルされたlibcを使用
4. Clangバックエンドを介したCコンパイル
5. リンク処理（ZigのリンカまたはLLD使用）

**関連システム・外部連携**：
- Clangバックエンド: 実際のCコンパイル処理
- バンドルされたlibc実装（glibc, musl, mingw等）
- LLDリンカ
- 各種ビルドシステム（Make, CMake, Meson等）

**権限による制御**：特に権限制御は実装されていない。ファイルシステムのアクセス権限に依存する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 14 | Cコンパイラ画面 | 主機能 | Zigをドロップイン Cコンパイラとして使用する処理 |

## 機能種別

コンパイル処理 / ドロップイン互換ツール

## 入力仕様

### 入力パラメータ

GCC/Clang互換の引数をサポート。主要なオプションを以下に示す。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| source files | []const u8 | Yes | コンパイル対象のCソースファイル | .c, .h等のCファイル |
| -o | []const u8 | No | 出力ファイル名 | - |
| -c | フラグ | No | コンパイルのみ（リンクしない） | - |
| -target | []const u8 | No | ターゲットトリプル | 有効なターゲット指定 |
| -I | [][]const u8 | No | インクルードパス | - |
| -L | [][]const u8 | No | ライブラリ検索パス | - |
| -l | [][]const u8 | No | リンクするライブラリ | - |
| -D | [][]const u8 | No | プリプロセッサマクロ定義 | - |
| -O | enum | No | 最適化レベル（0/1/2/3/s/z） | - |
| -g | フラグ | No | デバッグ情報生成 | - |
| -W | []const u8 | No | 警告オプション | - |
| -f | []const u8 | No | 各種機能フラグ | - |
| -std | []const u8 | No | C言語標準バージョン | c89, c99, c11, c17, c23等 |
| -shared | フラグ | No | 共有ライブラリ生成 | - |
| -static | フラグ | No | 静的リンク | - |

### 入力データソース

- Cソースファイル（.c）
- Cヘッダーファイル（.h）
- アセンブリファイル（.s, .S）
- オブジェクトファイル（.o）
- 静的ライブラリ（.a）
- 動的ライブラリ（.so, .dylib, .dll）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| executable | バイナリ | 実行可能ファイル |
| object_file | バイナリ | オブジェクトファイル（-c指定時） |
| shared_library | バイナリ | 共有ライブラリ（-shared指定時） |
| static_library | バイナリ | 静的ライブラリ |
| preprocessed | テキスト | プリプロセス結果（-E指定時） |
| assembly | テキスト | アセンブリコード（-S指定時） |

### 出力先

- ファイルシステム（-oで指定されたパス）
- 標準出力（-E時、-oなしの場合）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ GCC/Clang互換オプションの解釈
2. ターゲット決定
   └─ -target指定または自動検出
3. libc選択
   └─ ターゲットに応じたlibc実装の選択
4. プリプロセス
   └─ マクロ展開、インクルード処理
5. コンパイル
   └─ Clangバックエンドによるコード生成
6. アセンブル（必要な場合）
   └─ アセンブリからオブジェクトへ
7. リンク（-c未指定時）
   └─ LLDまたはシステムリンカによるリンク
8. 出力
   └─ 指定された形式で出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C[ターゲット決定]
    C --> D[libc選択]
    D --> E{-E指定?}
    E -->|Yes| F[プリプロセスのみ]
    E -->|No| G[プリプロセス]
    G --> H{-S指定?}
    H -->|Yes| I[アセンブリ出力]
    H -->|No| J[コンパイル]
    J --> K{-c指定?}
    K -->|Yes| L[オブジェクト出力]
    K -->|No| M[リンク]
    M --> N[実行可能ファイル出力]
    F --> O[終了]
    I --> O
    L --> O
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | GCC互換性 | GCCと同等のコマンドラインオプションをサポート | 全実行 |
| BR-02 | クロスコンパイル | -targetでクロスコンパイルターゲットを指定可能 | -target指定時 |
| BR-03 | libcバンドル | ターゲットに応じたlibcを自動選択 | libc使用時 |
| BR-04 | 静的リンク | -staticで完全静的リンクバイナリを生成 | -static指定時 |
| BR-05 | 再帰呼び出し防止 | CC環境変数が自身を指す場合の無限ループを防止 | libc検出時 |

### サポートされるターゲットの例

| ターゲット | 説明 |
|-----------|------|
| x86_64-linux-gnu | Linux x86_64（glibc） |
| x86_64-linux-musl | Linux x86_64（musl） |
| aarch64-linux-gnu | Linux ARM64（glibc） |
| x86_64-windows-gnu | Windows x86_64（MinGW） |
| x86_64-macos | macOS x86_64 |
| aarch64-macos | macOS ARM64 |
| wasm32-wasi | WebAssembly WASI |

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | コンパイルエラー | Cソースに構文/意味エラー | Clangのエラーメッセージを出力 |
| - | リンクエラー | シンボル未解決等 | リンカのエラーメッセージを出力 |
| - | ファイルエラー | 入力ファイルが見つからない | エラーメッセージを出力 |
| - | ターゲットエラー | 無効なターゲット指定 | サポートされるターゲット一覧を提示 |
| - | 無限再帰防止 | CC=zig ccでのlibc検出時 | 環境変数で検出して回避 |

### リトライ仕様

リトライ機能は実装されていない。

## トランザクション仕様

本機能はトランザクション処理を必要としない。

## パフォーマンス要件

- 大規模プロジェクトのビルドに対応
- 並列コンパイル（-jオプション）のサポート

## セキュリティ考慮事項

- 入力ソースファイルは信頼されたソースからのものであることが前提
- サンドボックス環境での実行を推奨

## 備考

- `zig cc`は内部的にClangを使用
- Zigのインストールだけでクロスコンパイル環境が整う点が大きな利点
- 環境変数`CC=zig cc`でMake等から利用可能
- CMakeでは`-DCMAKE_C_COMPILER=zig cc`で設定可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、cc処理で使用される主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Compilation.zig | `src/Compilation.zig` | Config構造体: コンパイル設定を保持 |
| 1-2 | main.zig | `src/main.zig` | ArgMode: コマンドモードの列挙（.cc） |

**読解のコツ**: `zig cc`は内部的に`buildOutputType`関数に`.cc`モードとして渡される。

#### Step 2: エントリーポイントを理解する

処理の起点となる関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | **300-302行目**: `zig cc`コマンドのディスパッチ。buildOutputTypeに`.cc`として渡される |
| 2-2 | main.zig | `src/main.zig` | **226-256行目**: ZIG_IS_DETECTING_LIBC_PATHS環境変数による無限再帰防止 |

**主要処理フロー**:
1. **300-302行目**: dev.check(.cc_command)で機能チェック
2. **302行目**: buildOutputType(gpa, arena, io, args, .cc, environ_map)を呼び出し
3. **226-256行目**: libc検出時の無限再帰防止処理

#### Step 3: ビルド処理を理解する

実際のコンパイル処理を読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | buildOutputType関数: GCC互換オプションの解析 |
| 3-2 | Compilation.zig | `src/Compilation.zig` | Clangバックエンドの呼び出し |

#### Step 4: Clang統合を理解する

Clangバックエンドとの統合を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | main.zig | `src/main.zig` | clangMain関数の呼び出し（289-293行目） |

### プログラム呼び出し階層図

```
main.zig::mainArgs
    │
    ├─ ZIG_IS_DETECTING_LIBC_PATHS チェック (226-256行目)
    │      └─ 無限再帰防止処理
    │
    └─ buildOutputType (.cc モード)
           │
           ├─ GCC/Clang互換引数解析
           │
           ├─ ターゲット決定
           │
           ├─ libc選択
           │
           └─ Clangバックエンド
                  │
                  ├─ プリプロセス
                  ├─ コンパイル
                  └─ リンク (LLD)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Cソースファイル ───▶ 引数解析 ───▶ ターゲット決定
                           │
                           ▼
                    libc選択（バンドル）
                           │
                           ▼
                    Clangプリプロセス
                           │
                           ▼
                    Clangコンパイル
                           │
                           ▼
                    LLDリンク ───▶ 実行可能ファイル
                           │
                           └───▶ オブジェクトファイル（-c時）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | CLIエントリーポイント、引数解析 |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイレーション管理 |
| dev.zig | `src/dev.zig` | ソース | 機能フラグ管理（cc_command） |
| introspect.zig | `src/introspect.zig` | ソース | 環境検出 |
| libs/ | `src/libs/` | ディレクトリ | バンドルされたlibc実装 |
