# 機能設計書 16-ar

## 概要

本ドキュメントは、Zigコンパイラに組み込まれたドロップインアーカイバ機能「ar」の設計仕様を記載する。`zig ar`コマンドは、ZigをUnix標準の`ar`コマンド互換のアーカイバとして使用するためのインターフェースを提供する。

### 本機能の処理概要

**業務上の目的・背景**：静的ライブラリ（アーカイブ）の作成は、多くのビルドシステムで必須の機能である。従来は各プラットフォームごとに異なるarコマンド（GNU ar、BSD ar等）を使用する必要があったが、本機能により、Zigのインストールだけで統一されたアーカイブ操作が可能になる。クロスコンパイル環境でも一貫した静的ライブラリの作成・管理ができる。

**機能の利用シーン**：
- 静的ライブラリ（.aファイル）の作成
- 既存のアーカイブへのオブジェクトファイルの追加・置換
- アーカイブからのファイル抽出
- アーカイブの内容一覧表示
- クロスコンパイル環境でのライブラリ作成
- 環境変数`AR=zig ar`でMake等から利用

**主要な処理内容**：
1. コマンドライン引数の解析（Unix ar互換）
2. 操作種別の決定（追加、削除、抽出、一覧等）
3. アーカイブファイルの読み込み/作成
4. シンボルテーブルの生成（必要な場合）
5. アーカイブの出力

**関連システム・外部連携**：
- LLVMライブラリ（llvm-ar実装）
- 各種ビルドシステム（Make, CMake, Meson等）

**権限による制御**：特に権限制御は実装されていない。ファイルシステムのアクセス権限に依存する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | アーカイバ画面 | 主機能 | ドロップインアーカイバとしての静的ライブラリ作成処理 |

## 機能種別

ファイル操作 / ドロップイン互換ツール

## 入力仕様

### 入力パラメータ

Unix ar互換の引数をサポート。主要なオプションを以下に示す。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| operation | char | Yes | 操作種別（d/m/p/q/r/s/t/x） | 有効な操作文字 |
| archive | []const u8 | Yes | アーカイブファイル名 | - |
| files | [][]const u8 | 条件付き | 操作対象のファイル | 操作によって必須 |
| --format | enum | No | アーカイブフォーマット | default/gnu/darwin/bsd/bigarchive/coff |
| --thin | フラグ | No | シンアーカイブを作成 | - |
| --output | []const u8 | No | 抽出先ディレクトリ | - |
| -h, --help | フラグ | No | ヘルプ表示 | - |
| --version | フラグ | No | バージョン表示 | - |

### 操作種別

| 操作 | 説明 |
|------|------|
| d | アーカイブからファイルを削除 |
| m | アーカイブ内でファイルを移動 |
| p | アーカイブ内のファイル内容を出力 |
| q | アーカイブにファイルを追加（高速） |
| r | アーカイブにファイルを追加/置換 |
| s | ranlibとして動作（シンボルテーブル作成） |
| t | アーカイブの内容一覧を表示 |
| x | アーカイブからファイルを抽出 |

### 修飾子

| 修飾子 | 説明 |
|--------|------|
| [a] | 指定位置の後にファイルを配置 |
| [b] | 指定位置の前にファイルを配置（[i]と同じ） |
| [c] | アーカイブ作成時の警告を抑制 |
| [D] | タイムスタンプとUID/GIDに0を使用（デフォルト） |
| [o] | 元のタイムスタンプを保持 |
| [s] | シンボルテーブルを作成 |
| [S] | シンボルテーブルを作成しない |
| [u] | 新しいファイルのみ更新 |
| [U] | 実際のタイムスタンプとUID/GIDを使用 |
| [v] | 詳細出力 |

### 入力データソース

- オブジェクトファイル（.o）
- 既存のアーカイブファイル（.a）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| archive | バイナリ | 静的ライブラリ（.aファイル） |
| file_list | テキスト | アーカイブ内容一覧（t操作時） |
| extracted_files | バイナリ | 抽出されたファイル（x操作時） |

### 出力先

- ファイルシステム（アーカイブファイル）
- 標準出力（一覧表示、ファイル内容出力）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ 操作種別と修飾子の識別
2. 操作種別による分岐
   └─ r/q: ファイル追加/置換
   └─ d: ファイル削除
   └─ x: ファイル抽出
   └─ t: 内容一覧表示
   └─ s: シンボルテーブル作成
3. アーカイブ処理
   └─ 既存アーカイブの読み込み（存在する場合）
   └─ 操作の実行
   └─ シンボルテーブル生成（必要な場合）
4. 出力
   └─ アーカイブファイルの書き込み
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C{操作種別}
    C -->|r/q| D[ファイル追加/置換]
    C -->|d| E[ファイル削除]
    C -->|x| F[ファイル抽出]
    C -->|t| G[内容一覧表示]
    C -->|s| H[シンボルテーブル作成]
    D --> I[アーカイブ書き込み]
    E --> I
    F --> J[ファイル書き出し]
    G --> K[標準出力]
    H --> I
    I --> L[終了]
    J --> L
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | GNU ar互換 | GNU arと同等のコマンドラインインターフェース | 全実行 |
| BR-02 | デフォルトDモード | タイムスタンプとUID/GIDにデフォルトで0を使用 | 再現可能ビルド用 |
| BR-03 | シンボルテーブル自動生成 | デフォルトでシンボルテーブルを生成 | [S]未指定時 |
| BR-04 | シンアーカイブ | --thinでシンアーカイブを作成可能 | --thin指定時 |

### サポートされるアーカイブフォーマット

| フォーマット | 説明 |
|-------------|------|
| default | システムデフォルト |
| gnu | GNU形式 |
| darwin | macOS形式 |
| bsd | BSD形式 |
| bigarchive | AIX Big Archive形式 |
| coff | COFF形式 |

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | 不正な操作/修飾子指定 | 使用方法を表示して終了 |
| - | ファイルエラー | 入力ファイルが見つからない | エラーメッセージを出力 |
| - | フォーマットエラー | 不正なアーカイブ形式 | エラーメッセージを出力 |

### リトライ仕様

リトライ機能は実装されていない。

## トランザクション仕様

本機能はトランザクション処理を必要としない。アーカイブ書き込みは一括で行われる。

## パフォーマンス要件

- 大規模なアーカイブ（数千のオブジェクトファイル）に対応
- qオプションで高速追加をサポート

## セキュリティ考慮事項

- 入力ファイルは信頼されたソースからのものであることが前提
- [D]オプションにより再現可能ビルドをサポート

## 備考

- `zig ar`は内部的にLLVMのllvm-arを使用
- 環境変数`AR=zig ar`でMake等から利用可能
- CMakeでは`-DCMAKE_AR=zig ar`で設定可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ar処理で使用される主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | zig_llvm-ar.cpp | `src/zig_llvm-ar.cpp` | **196-198行目**: Format enum定義（Default, GNU, COFF, BSD, DARWIN, BIGARCHIVE） |

**読解のコツ**: このファイルはLLVMのllvm-arをZigに統合したもので、C++で実装されている。

#### Step 2: エントリーポイントを理解する

処理の起点となる関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | **279-285行目**: `zig ar`コマンドのディスパッチ。llvmArMain関数を呼び出し |
| 2-2 | main.zig | `src/main.zig` | **5798-5810行目**: llvmArMain関数。実際のLLVM ar処理を呼び出し |

**主要処理フロー**:
1. **279-285行目**: dlltool/ranlib/lib/arコマンドを統一して処理
2. **284行目**: dev.check(.ar_command)で機能チェック
3. **285行目**: process.exit(try llvmArMain(arena, args))でLLVM arを実行

#### Step 3: LLVM ar実装を理解する

実際のアーカイブ処理を読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | zig_llvm-ar.cpp | `src/zig_llvm-ar.cpp` | **62-74行目**: printRanLibHelp - ranlibヘルプ |
| 3-2 | zig_llvm-ar.cpp | `src/zig_llvm-ar.cpp` | **76-136行目**: printArHelp - arヘルプ |
| 3-3 | zig_llvm-ar.cpp | `src/zig_llvm-ar.cpp` | **1519-1540行目**: ar/ranlib/lib/dlltoolの振り分け |

**主要処理フロー**:
- **1530-1531行目**: dlltoolの場合はdlltoolDriverMainを呼び出し
- **1532-1533行目**: ranlibの場合はranlib_mainを呼び出し
- **1534-1535行目**: libの場合はlibDriverMainを呼び出し
- **1536-1537行目**: arの場合はar_mainを呼び出し

### プログラム呼び出し階層図

```
main.zig::mainArgs
    │
    └─ llvmArMain (5798-5810行目)
           │
           └─ ZigLlvmAr_main (C++関数)
                  │
                  ├─ Is("dlltool") → dlltoolDriverMain
                  ├─ Is("ranlib") → ranlib_main
                  ├─ Is("lib") → libDriverMain
                  └─ Is("ar") → ar_main
                         │
                         ├─ parseCommandLine
                         └─ performOperation
                                │
                                ├─ doCreate (アーカイブ作成)
                                ├─ doDelete (ファイル削除)
                                ├─ doExtract (ファイル抽出)
                                ├─ doDisplayTable (一覧表示)
                                └─ doRanlib (シンボルテーブル作成)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

オブジェクトファイル ───▶ 引数解析 ───▶ 操作判定
                               │
                               ▼
                        アーカイブ読込
                               │
                               ▼
                        操作実行
                               │
               ┌───────────────┼───────────────┐
               │               │               │
               ▼               ▼               ▼
          追加/置換         削除/抽出      一覧表示
               │               │               │
               ▼               ▼               ▼
          シンボルテーブル   ファイル出力   標準出力
               │
               ▼
          アーカイブ書込 ───▶ .aファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | CLIエントリーポイント |
| zig_llvm-ar.cpp | `src/zig_llvm-ar.cpp` | ソース | LLVM ar実装（C++） |
| dev.zig | `src/dev.zig` | ソース | 機能フラグ管理（ar_command） |
