# 機能設計書 17-ranlib

## 概要

本ドキュメントは、Zigコンパイラに組み込まれたドロップインranlib機能の設計仕様を記載する。`zig ranlib`コマンドは、ZigをUnix標準の`ranlib`コマンド互換のツールとして使用するためのインターフェースを提供する。

### 本機能の処理概要

**業務上の目的・背景**：ranlibは静的ライブラリ（アーカイブ）のシンボルテーブル（インデックス）を生成するツールである。シンボルテーブルがあることで、リンカはアーカイブ内のオブジェクトファイルを効率的に検索できる。本機能により、Zigのインストールだけでクロスプラットフォームなシンボルテーブル生成が可能になる。

**機能の利用シーン**：
- 静的ライブラリのシンボルテーブル更新
- 古いビルドシステムとの互換性維持（ranlibを明示的に呼び出すもの）
- クロスコンパイル環境でのライブラリインデックス作成
- アーカイブ作成後のシンボルテーブル追加

**主要な処理内容**：
1. コマンドライン引数の解析
2. アーカイブファイルの読み込み
3. シンボルテーブルの生成/更新
4. アーカイブファイルの書き戻し

**関連システム・外部連携**：
- LLVMライブラリ（llvm-ar/ranlib実装）
- 各種ビルドシステム（Make, Autotools等）

**権限による制御**：特に権限制御は実装されていない。ファイルシステムのアクセス権限に依存する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | Ranlibツール画面 | 主機能 | ドロップインranlibとしてのアーカイブインデックス生成処理 |

## 機能種別

ファイル操作 / ドロップイン互換ツール

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| archive | []const u8 | Yes | 処理対象のアーカイブファイル（複数可） | 有効なアーカイブファイル |
| -D | フラグ | No | タイムスタンプとUID/GIDに0を使用（デフォルト） | - |
| -U | フラグ | No | 実際のタイムスタンプとUID/GIDを使用 | - |
| -h, --help | フラグ | No | ヘルプ表示 | - |
| -V, --version | フラグ | No | バージョン表示 | - |
| -X{32\|64\|32_64\|any} | enum | No | AIX用アーカイブシンボルテーブル指定 | AIX OSのみ |

### 入力データソース

- 既存のアーカイブファイル（.a）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| updated_archive | バイナリ | シンボルテーブル付きアーカイブ |

### 出力先

- ファイルシステム（元のアーカイブファイルを上書き）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ オプションとアーカイブファイルリストの取得
2. 各アーカイブに対して処理
   └─ アーカイブの読み込み
   └─ シンボルテーブルの有無確認
   └─ シンボルテーブルの生成/更新
   └─ アーカイブの書き戻し
3. 終了
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C{アーカイブあり?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[アーカイブ読込]
    E --> F{シンボルテーブルあり?}
    F -->|Yes| G{更新必要?}
    F -->|No| H[シンボルテーブル生成]
    G -->|No| I[次のアーカイブ]
    G -->|Yes| H
    H --> J[アーカイブ書込]
    J --> I
    I --> K{全アーカイブ処理完了?}
    K -->|No| E
    K -->|Yes| L[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | ranlib互換性 | Unix ranlibと同等のインターフェース | 全実行 |
| BR-02 | デフォルトDモード | タイムスタンプに0を使用（再現可能ビルド） | デフォルト |
| BR-03 | 既存シンボルテーブル確認 | シンボルテーブルがあれば更新不要な場合スキップ | シンボルテーブル存在時 |
| BR-04 | 複数アーカイブ処理 | 複数のアーカイブを一度に処理可能 | 複数指定時 |

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | アーカイブ未指定 | 使用方法を表示して終了 |
| - | ファイルエラー | アーカイブファイルが見つからない | エラーメッセージを出力 |
| - | フォーマットエラー | 不正なアーカイブ形式 | エラーメッセージを出力 |

### リトライ仕様

リトライ機能は実装されていない。

## トランザクション仕様

本機能はトランザクション処理を必要としない。

## パフォーマンス要件

- 大規模なアーカイブに対応
- シンボルテーブルが既に存在する場合は更新をスキップ

## セキュリティ考慮事項

- 入力ファイルは信頼されたソースからのものであることが前提

## 備考

- `zig ranlib`は内部的に`zig ar s`と同等の処理を行う
- 現代のビルドシステムでは、arコマンドがシンボルテーブルを自動生成するため、ranlibの明示的な呼び出しは通常不要

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | **279-285行目**: ranlibコマンドのディスパッチ。arと同じllvmArMainを呼び出し |
| 1-2 | zig_llvm-ar.cpp | `src/zig_llvm-ar.cpp` | **1532-1533行目**: Is("ranlib")でranlib_mainを呼び出し |

#### Step 2: ranlib実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | zig_llvm-ar.cpp | `src/zig_llvm-ar.cpp` | **62-74行目**: printRanLibHelp関数 |
| 2-2 | zig_llvm-ar.cpp | `src/zig_llvm-ar.cpp` | **1424-1517行目**: ranlib_main関数 |

**主要処理フロー**:
- **1425行目**: Archivesベクタの初期化
- **1427-1470行目**: 引数解析ループ
- **1477-1517行目**: 各アーカイブに対するシンボルテーブル生成

### プログラム呼び出し階層図

```
main.zig::mainArgs
    │
    └─ llvmArMain
           │
           └─ ZigLlvmAr_main
                  │
                  └─ Is("ranlib") → ranlib_main
                         │
                         ├─ 引数解析
                         │
                         └─ 各アーカイブ処理
                                │
                                └─ シンボルテーブル生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | CLIエントリーポイント |
| zig_llvm-ar.cpp | `src/zig_llvm-ar.cpp` | ソース | LLVM ar/ranlib実装 |
