# 機能設計書 18-lib

## 概要

本ドキュメントは、Zigコンパイラに組み込まれたドロップインlib.exe機能の設計仕様を記載する。`zig lib`コマンドは、ZigをMicrosoft Visual Studio付属の`lib.exe`互換ツールとして使用するためのインターフェースを提供する。

### 本機能の処理概要

**業務上の目的・背景**：Windowsプラットフォームでの静的ライブラリ作成には、通常Visual Studioに付属するlib.exeが使用される。本機能により、Visual Studioをインストールすることなく、Zigのみでwindows向け静的ライブラリ（.libファイル）を作成できる。これはクロスコンパイル環境やCI/CD環境で特に有用である。

**機能の利用シーン**：
- Windows向け静的ライブラリ（.libファイル）の作成
- クロスコンパイル環境でのWindows用ライブラリ作成
- Visual Studioなしでのwindowsビルド
- CI/CD環境でのWindows向けビルド

**主要な処理内容**：
1. コマンドライン引数の解析（lib.exe互換）
2. オブジェクトファイルの読み込み
3. COFF形式のアーカイブ作成
4. .libファイルの出力

**関連システム・外部連携**：
- LLVMライブラリ（llvm-lib実装）
- MSVCツールチェーン互換

**権限による制御**：特に権限制御は実装されていない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | Libツール画面 | 主機能 | ドロップインlib.exeとしてのWindows用静的ライブラリ作成処理 |

## 機能種別

ファイル操作 / ドロップイン互換ツール / Windows専用

## 入力仕様

### 入力パラメータ

lib.exe互換の引数をサポート。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| files | [][]const u8 | Yes | オブジェクトファイル | .objファイル |
| /OUT: | []const u8 | No | 出力ファイル名 | - |
| /MACHINE: | enum | No | ターゲットマシン | X86, X64, ARM, ARM64等 |
| /DEF: | []const u8 | No | モジュール定義ファイル | .defファイル |
| /NAME: | []const u8 | No | 出力DLL名（インポートライブラリ用） | - |
| /NOLOGO | フラグ | No | 著作権表示を抑制 | - |
| /LIST | フラグ | No | ライブラリ内容を一覧表示 | - |
| /? /HELP | フラグ | No | ヘルプ表示 | - |

### 入力データソース

- COFF形式オブジェクトファイル（.obj）
- 既存のライブラリファイル（.lib）
- モジュール定義ファイル（.def）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| static_library | バイナリ | Windows静的ライブラリ（.libファイル） |
| import_library | バイナリ | インポートライブラリ（/DEF指定時） |

### 出力先

- ファイルシステム（/OUT:で指定されたパス）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ lib.exe互換オプションの解釈
2. オブジェクトファイルの読み込み
   └─ COFFオブジェクトの検証
3. アーカイブ作成
   └─ COFF形式アーカイブの構築
   └─ シンボルテーブル生成
4. 出力
   └─ .libファイルの書き込み
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C{/DEF指定?}
    C -->|Yes| D[インポートライブラリ生成]
    C -->|No| E[オブジェクト読込]
    E --> F[アーカイブ作成]
    D --> G[.lib出力]
    F --> G
    G --> H[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | lib.exe互換 | MSVCのlib.exeと同等のインターフェース | 全実行 |
| BR-02 | COFF形式 | 出力はCOFF形式のアーカイブ | 常時 |
| BR-03 | インポートライブラリ | /DEF指定時はDLLインポートライブラリを生成 | /DEF指定時 |

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | 必須引数不足 | 使用方法を表示して終了 |
| - | ファイルエラー | 入力ファイルが見つからない | エラーメッセージを出力 |
| - | フォーマットエラー | 非COFF形式のオブジェクト | エラーメッセージを出力 |

### リトライ仕様

リトライ機能は実装されていない。

## トランザクション仕様

本機能はトランザクション処理を必要としない。

## パフォーマンス要件

- 大規模なライブラリ作成に対応

## セキュリティ考慮事項

- 入力ファイルは信頼されたソースからのものであることが前提

## 備考

- `zig lib`は内部的にLLVMのllvm-libを使用
- MSVCツールチェーンなしでWindows開発が可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | **279-285行目**: libコマンドのディスパッチ |
| 1-2 | zig_llvm-ar.cpp | `src/zig_llvm-ar.cpp` | **1534-1535行目**: Is("lib")でlibDriverMainを呼び出し |

**主要処理フロー**:
- **41行目**: `#include "llvm/ToolDrivers/llvm-lib/LibDriver.h"`でLLVM libドライバをインクルード
- **1534-1535行目**: Is("lib")でlibDriverMainを呼び出し

### プログラム呼び出し階層図

```
main.zig::mainArgs
    │
    └─ llvmArMain
           │
           └─ ZigLlvmAr_main
                  │
                  └─ Is("lib") → libDriverMain (LLVM)
                         │
                         └─ COFF アーカイブ作成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | CLIエントリーポイント |
| zig_llvm-ar.cpp | `src/zig_llvm-ar.cpp` | ソース | LLVM ar/lib実装 |
