# 機能設計書 19-dlltool

## 概要

本ドキュメントは、Zigコンパイラに組み込まれたドロップインdlltool機能の設計仕様を記載する。`zig dlltool`コマンドは、ZigをGNU binutils付属の`dlltool`互換ツールとして使用するためのインターフェースを提供する。

### 本機能の処理概要

**業務上の目的・背景**：dlltoolは、Windows DLLのインポートライブラリ（.libファイル）を生成するツールである。DLLを使用するプログラムをリンクする際、インポートライブラリが必要となる。本機能により、MinGW環境やクロスコンパイル環境で、Zigのみを使ってWindows DLLのインポートライブラリを生成できる。

**機能の利用シーン**：
- Windows DLLのインポートライブラリ（.lib/.a）生成
- MinGW互換のビルド環境構築
- クロスコンパイル環境でのWindowsバイナリ作成
- .defファイルからのインポートライブラリ生成

**主要な処理内容**：
1. コマンドライン引数の解析（dlltool互換）
2. モジュール定義ファイル（.def）の読み込み
3. エクスポートシンボルの解析
4. インポートライブラリの生成

**関連システム・外部連携**：
- LLVMライブラリ（llvm-dlltool実装）
- MinGWツールチェーン互換

**権限による制御**：特に権限制御は実装されていない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | DLLツール画面 | 主機能 | ドロップインdlltool.exeとしてのDLLインポートライブラリ生成処理 |

## 機能種別

ファイル操作 / ドロップイン互換ツール / Windows専用

## 入力仕様

### 入力パラメータ

dlltool互換の引数をサポート。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -d, --input-def | []const u8 | Yes | モジュール定義ファイル | .defファイル |
| -l, --output-lib | []const u8 | No | 出力インポートライブラリファイル | - |
| -D, --dllname | []const u8 | No | DLL名（.defで指定がない場合） | - |
| -m, --machine | enum | No | ターゲットマシン | i386, x86-64, arm, arm64等 |
| -k, --kill-at | フラグ | No | @記号を除去 | - |
| -A, --add-indirect | フラグ | No | 間接参照を追加 | - |
| -S, --as | []const u8 | No | アセンブラパス（互換性のため） | - |
| -f, --as-flags | []const u8 | No | アセンブラフラグ（互換性のため） | - |
| -h, --help | フラグ | No | ヘルプ表示 | - |

### 入力データソース

- モジュール定義ファイル（.def）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| import_library | バイナリ | DLLインポートライブラリ（.lib/.a） |

### 出力先

- ファイルシステム（-lで指定されたパス）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ dlltool互換オプションの解釈
2. .defファイルの読み込み
   └─ エクスポートシンボルの解析
3. インポートライブラリ生成
   └─ COFF形式インポートライブラリの構築
4. 出力
   └─ ファイルの書き込み
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C[.def読込]
    C --> D[シンボル解析]
    D --> E[インポートライブラリ生成]
    E --> F[ファイル出力]
    F --> G[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | dlltool互換 | GNU dlltoolと同等のインターフェース | 全実行 |
| BR-02 | .defファイル必須 | エクスポート情報は.defファイルから取得 | 常時 |
| BR-03 | マシンタイプ推論 | -mが未指定の場合、.defから推論 | -m未指定時 |

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | .defファイル未指定 | 使用方法を表示して終了 |
| - | ファイルエラー | .defファイルが見つからない | エラーメッセージを出力 |
| - | 構文エラー | 不正な.defファイル形式 | エラーメッセージを出力 |

### リトライ仕様

リトライ機能は実装されていない。

## トランザクション仕様

本機能はトランザクション処理を必要としない。

## パフォーマンス要件

- 大量のエクスポートシンボルを持つDLLに対応

## セキュリティ考慮事項

- 入力ファイルは信頼されたソースからのものであることが前提

## 備考

- `zig dlltool`は内部的にLLVMのllvm-dlltoolを使用
- MinGW環境との互換性を提供
- MSVC環境では通常lib.exeが使用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | **279-285行目**: dlltoolコマンドのディスパッチ |
| 1-2 | zig_llvm-ar.cpp | `src/zig_llvm-ar.cpp` | **1530-1531行目**: Is("dlltool")でdlltoolDriverMainを呼び出し |

**主要処理フロー**:
- **40行目**: `#include "llvm/ToolDrivers/llvm-dlltool/DlltoolDriver.h"`でLLVM dlltoolドライバをインクルード
- **1530-1531行目**: Is("dlltool")でdlltoolDriverMainを呼び出し

### プログラム呼び出し階層図

```
main.zig::mainArgs
    │
    └─ llvmArMain
           │
           └─ ZigLlvmAr_main
                  │
                  └─ Is("dlltool") → dlltoolDriverMain (LLVM)
                         │
                         ├─ .def解析
                         └─ インポートライブラリ生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | CLIエントリーポイント |
| zig_llvm-ar.cpp | `src/zig_llvm-ar.cpp` | ソース | LLVM ar/dlltool実装 |
| def.zig | `src/libs/mingw/def.zig` | ソース | .defファイル解析（Zig内部用） |
