# 機能設計書 2-build-lib

## 概要

本ドキュメントは、Zigコンパイラの`build-lib`コマンドの機能設計について記述する。このコマンドはZigソースコードまたはオブジェクトファイルから静的ライブラリまたは動的ライブラリを生成する機能である。

### 本機能の処理概要

`zig build-lib`コマンドは、Zigソースコード（.zig）、Cソースコード（.c, .cpp等）、オブジェクトファイル（.o, .obj）などの入力ファイルから、ターゲットプラットフォーム向けのライブラリファイルを生成する。静的ライブラリ（.a, .lib）と動的ライブラリ（.so, .dll, .dylib）の両方に対応している。

**業務上の目的・背景**：Zigで再利用可能なライブラリを開発する際、他のプロジェクトやC/C++プログラムからリンク可能な形式でコードを配布する必要がある。`build-lib`はその中核となる機能であり、単一のコマンドでコンパイルからアーカイブ/リンクまでの全工程を一括して処理する。C言語のABIに準拠したライブラリを生成できるため、他言語からの利用も容易である。

**機能の利用シーン**：
- Zigコードを静的ライブラリとして他プロジェクトに提供する場合
- 動的ライブラリ（プラグイン、共有ライブラリ）を生成する場合
- C/C++プロジェクトにZigコードを組み込む場合
- システムライブラリの代替実装を提供する場合

**主要な処理内容**：
1. コマンドライン引数の解析とオプション設定
2. ターゲットプラットフォームの解決とコンフィグ生成
3. ライブラリ種別（静的/動的）の決定
4. Zigソースコードの構文解析とZIR生成
5. セマンティック解析による型チェック
6. バックエンドによるコード生成
7. アーカイバまたはリンカによるライブラリ生成

**関連システム・外部連携**：
- LLVM：最適化とコード生成に使用（オプション）
- ar/ranlib：静的ライブラリのアーカイブ作成
- システムリンカまたはLLD：動的ライブラリのリンク

**権限による制御**：特になし。ファイルシステムへの読み書き権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | ライブラリビルド画面 | 主機能 | Zigソースコードからライブラリを生成する処理 |

## 機能種別

コンパイル処理 / ライブラリ生成 / アーカイブ処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| files | []const u8 | Yes | ソースファイルまたはオブジェクトファイルのパス | 有効なファイルパスであること |
| -target | []const u8 | No | ターゲットアーキテクチャ | サポートされているターゲットであること |
| -O | OptimizeMode | No | 最適化モード | 有効な最適化モードであること |
| --name | []const u8 | No | 出力ライブラリ名 | 有効なファイル名であること |
| -dynamic | bool | No | 動的ライブラリとして生成 | - |
| -fPIC | bool | No | 位置独立コードを生成 | 動的ライブラリでは自動有効 |
| --version | semver | No | ライブラリバージョン | セマンティックバージョン形式 |
| -fsoname | []const u8 | No | SONAME指定 | - |
| -femit-implib | bool | No | インポートライブラリ生成（Windows） | - |

### 入力データソース

- コマンドライン引数
- Zigソースファイル（.zig）
- Cソースファイル（.c, .cpp等）
- オブジェクトファイル（.o, .obj）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 静的ライブラリ | バイナリ | .a（Unix系）または .lib（Windows）形式 |
| 動的ライブラリ | バイナリ | .so（Linux）、.dylib（macOS）、.dll（Windows）形式 |
| インポートライブラリ | バイナリ | .lib（Windows DLL用） |
| Cヘッダファイル | テキスト | -femit-h指定時の .h ファイル |

### 出力先

- ファイルシステム（現在のディレクトリまたは指定されたパス）
- デフォルト出力名はソースファイル名から拡張子を除いたもの

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ buildOutputType関数でArgMode.build(.Lib)として処理
2. ターゲット解決
   └─ ターゲットアーキテクチャとABIの決定
3. ライブラリ種別判定
   └─ -dynamicオプションにより静的/動的を決定
4. モジュール作成
   └─ Package.Module.create()でルートモジュールを作成
5. Compilation作成
   └─ output_mode = .Libで初期化
6. コード生成
   └─ オブジェクトファイルの生成
7. ライブラリ生成
   └─ 静的: arでアーカイブ、動的: リンカで共有ライブラリ生成
8. 結果出力
   └─ ライブラリファイルをファイルシステムに書き出し
```

### フローチャート

```mermaid
flowchart TD
    A[zig build-lib 開始] --> B[コマンドライン引数解析]
    B --> C{-dynamic指定?}
    C -->|Yes| D[動的ライブラリモード]
    C -->|No| E[静的ライブラリモード]
    D --> F[link_mode = .dynamic]
    E --> G[link_mode = .static]
    F --> H[PIC自動有効化]
    G --> I[Compilation作成]
    H --> I
    I --> J[ソースファイル処理]
    J --> K[コード生成]
    K --> L{静的ライブラリ?}
    L -->|Yes| M[arでアーカイブ作成]
    L -->|No| N[リンカで共有ライブラリ生成]
    M --> O[ライブラリ出力]
    N --> P{Windows DLL?}
    P -->|Yes| Q[インポートライブラリ生成]
    P -->|No| O
    Q --> O
    O --> R[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | デフォルトは静的ライブラリ | -dynamic未指定時は静的ライブラリを生成 | オプション未指定時 |
| BR-02 | 動的ライブラリはPIC必須 | 動的ライブラリ生成時は自動的にPICを有効化 | -dynamic指定時 |
| BR-03 | Windows DLLはインポートライブラリ生成 | Windows向け動的ライブラリではインポートライブラリも生成 | ターゲットがWindowsかつ動的 |
| BR-04 | SONAME自動設定 | バージョン指定時はSONAMEを自動設定 | --version指定時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベースは使用しない |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | FileNotFound | ソースファイルが存在しない | ファイルパスを確認 |
| - | CompileError | コンパイルエラー | エラーメッセージに従い修正 |
| - | ArchiveError | アーカイブ作成失敗 | ディスク容量、権限を確認 |
| - | LinkError | 動的ライブラリのリンク失敗 | シンボル定義を確認 |

### リトライ仕様

- コンパイルエラーは自動リトライなし

## トランザクション仕様

- アトミックなファイル書き込み
- 中間オブジェクトファイルはキャッシュに保存

## パフォーマンス要件

- インクリメンタルコンパイル対応
- 並列コンパイル対応

## セキュリティ考慮事項

- 入力ファイルのパス検証
- シンボルのエクスポート制御

## 備考

- C ABIに準拠したライブラリを生成可能
- クロスコンパイルにより他プラットフォーム向けライブラリを生成可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Compilation.zig | `src/Compilation.zig` | output_mode, link_modeの定義 |

**読解のコツ**: `output_mode = .Lib`の場合、`link_mode`が`.static`か`.dynamic`かで静的/動的が決まる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | build-libコマンドの分岐処理 |

**主要処理フロー**:
1. **264-266行目**: `mem.eql(u8, cmd, "build-lib")`で判定し`buildOutputType`呼び出し
2. **arg_mode = .{ .build = .Lib }** でライブラリモードを設定

#### Step 3: ライブラリ種別の判定

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Compilation.zig | `src/Compilation.zig` | is_dyn_libの判定ロジック |

**主要処理フロー**:
- **1927-1930行目**: `is_dyn_lib`の判定

### プログラム呼び出し階層図

```
main (src/main.zig)
    │
    └─ buildOutputType (ArgMode = .build(.Lib))
            │
            ├─ Compilation.create (output_mode = .Lib)
            │      ├─ link_mode判定 (.static or .dynamic)
            │      └─ is_dyn_libフラグ設定
            │
            └─ Compilation.update
                   ├─ オブジェクト生成
                   └─ link
                          ├─ 静的: ar アーカイブ
                          └─ 動的: リンカ処理
```

### データフロー図

```
[入力]                    [処理]                        [出力]

.zig ソース ─────────┐
                     ├──▶ コンパイル ──▶ .o ──┐
.c ソース ──────────┤                         │
                     │                         ├──▶ 静的: .a/.lib
.o オブジェクト ────┴─────────────────────────┤
                                               └──▶ 動的: .so/.dll/.dylib
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンド分岐 |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理 |
| link/Elf.zig | `src/link/Elf.zig` | ソース | ELF形式ライブラリ生成 |
| link/MachO.zig | `src/link/MachO.zig` | ソース | Mach-O形式ライブラリ生成 |
| link/Coff.zig | `src/link/Coff.zig` | ソース | COFF形式ライブラリ生成 |
