# 機能設計書 22-env

## 概要

本ドキュメントは、Zigコンパイラのenv機能について記述する。この機能は、Zigのインストール情報、ライブラリパス、キャッシュディレクトリ、バージョン情報などの環境情報をJSON形式で出力する。

### 本機能の処理概要

**業務上の目的・背景**：
開発者やビルドシステムがZigコンパイラの設定情報を取得する必要がある場面は多い。例えば、エディタ拡張機能がZigの標準ライブラリパスを知る必要がある場合や、ビルドスクリプトがキャッシュディレクトリを参照する場合などである。env機能は、これらの情報を機械可読な形式で提供し、ツール連携を容易にする。

**機能の利用シーン**：
- IDE/エディタ拡張機能がZigのパス情報を取得する際
- ビルドスクリプトがZigの設定を確認する際
- デバッグ時にZigの環境設定を確認する際
- CI/CD環境でのZig環境の検証時
- Zigのインストール状態を確認する際

**主要な処理内容**：
1. コマンドライン引数の処理
2. Zig実行可能ファイルのパスを取得
3. Zigライブラリディレクトリの検出
4. グローバルキャッシュディレクトリの取得
5. ホストターゲット情報の解決
6. 環境変数の収集
7. ZON形式での出力生成

**関連システム・外部連携**：
- ファイルシステムアクセス（パス解決）
- 環境変数の読み取り（ZIG_LIB_DIR、ZIG_GLOBAL_CACHE_DIR等）

**権限による制御**：
本機能は特定の権限制御を持たない。ファイルシステムへの読み取りアクセス権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | 環境情報画面 | 主画面 | zig env コマンド実行時の環境情報表示処理 |

## 機能種別

情報表示処理 / 設定確認処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| なし | - | - | 本機能は引数を取らない | - |

### 入力データソース

- 環境変数: ZIG_LIB_DIR（ライブラリディレクトリのオーバーライド）
- 環境変数: ZIG_GLOBAL_CACHE_DIR（グローバルキャッシュディレクトリのオーバーライド）
- 環境変数: その他のZig関連環境変数（EnvVar enumで定義）
- 実行可能ファイルパス: 自身のパスから相対的にライブラリパスを検出

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| zig_exe | 文字列 | Zig実行可能ファイルの絶対パス |
| lib_dir | 文字列 | Zigライブラリディレクトリのパス |
| std_dir | 文字列 | 標準ライブラリディレクトリのパス |
| global_cache_dir | 文字列 | グローバルキャッシュディレクトリのパス |
| version | 文字列 | Zigのバージョン文字列 |
| target | 文字列 | ホストターゲットのトリプル文字列 |
| env | 構造体 | Zig関連環境変数の現在値 |

### 出力先

- 標準出力（ZON形式）

### 出力形式例

```zon
.{
    .zig_exe = "/usr/local/bin/zig",
    .lib_dir = "/usr/local/lib/zig",
    .std_dir = "/usr/local/lib/zig/std",
    .global_cache_dir = "/home/user/.cache/zig",
    .version = "0.12.0",
    .target = "x86_64-linux-gnu",
    .env = .{
        .ZIG_LIB_DIR = null,
        .ZIG_GLOBAL_CACHE_DIR = null,
        ...
    },
}
```

## 処理フロー

### 処理シーケンス

```
1. 環境変数からオーバーライド設定を取得
   └─ ZIG_LIB_DIR、ZIG_GLOBAL_CACHE_DIRの確認

2. 実行可能ファイルパスの取得
   └─ std.process.executablePathAlloc()を使用
   └─ WASIの場合はargs[0]を使用

3. Compilationディレクトリの初期化
   └─ Compilation.Directories.init()でパス情報を構築

4. 各種パス情報の取得
   └─ zig_lib: Zigライブラリディレクトリ
   └─ zig_std: 標準ライブラリディレクトリ（lib_dir + "std"）
   └─ global_cache: グローバルキャッシュディレクトリ

5. ホストターゲット情報の取得
   └─ host.zigTriple()でトリプル文字列を生成

6. ZON形式での出力生成
   └─ std.zon.Serializerを使用して構造化出力
   └─ 環境変数フィールドをインラインforで列挙

7. 出力のフラッシュ
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[環境変数読み取り]
    B --> C[実行可能ファイルパス取得]
    C --> D{WASI環境?}
    D -->|Yes| E[args[0]を使用]
    D -->|No| F[executablePathAlloc]
    E --> G[Directoryinfo初期化]
    F --> G
    G --> H[パス情報取得]
    H --> I[ターゲットトリプル生成]
    I --> J[ZONシリアライザ初期化]
    J --> K[各フィールド出力]
    K --> L[環境変数出力]
    L --> M[出力フラッシュ]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 環境変数オーバーライド | ZIG_LIB_DIR等が設定されている場合はその値を優先 | 環境変数が設定されている場合 |
| BR-02 | 相対パス解決 | 実行可能ファイルパスから相対的にライブラリパスを検出 | 環境変数未設定時 |
| BR-03 | ZON形式出力 | 出力は常にZON（Zig Object Notation）形式 | 常時 |
| BR-04 | 環境変数null表示 | 未設定の環境変数はnullとして出力 | 環境変数未設定時 |

### 計算ロジック

**std_dir の計算**:
```
std_dir = zig_lib_dir + "/std"
```

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 致命的エラー | 実行可能ファイルパスの取得失敗 | エラーメッセージを表示して終了 |

### リトライ仕様

本機能にリトライ機構は存在しない。

## トランザクション仕様

本機能はトランザクションを使用しない。

## パフォーマンス要件

- 即座に応答（100ms以内）
- ファイルシステムアクセスは最小限

## セキュリティ考慮事項

- 機密情報（パスワード等）は出力しない
- 環境変数の出力はZig関連のもののみに限定

## 備考

- 出力形式はZON（Zig Object Notation）であり、JSONではない
- std.zon.Serializerを使用してシリアライズ

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

環境変数の列挙型と出力構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | EnvVar | `lib/std/zig/EnvVar.zig` | Zig関連環境変数の定義 |

**読解のコツ**:
- EnvVar enumがどのような環境変数を管理しているか把握する
- get()メソッドで環境変数の値を取得する方法を理解する

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | envコマンドのディスパッチ（354-367行目） |
| 2-2 | print_env.zig | `src/print_env.zig` | cmdEnv関数の実装 |

**主要処理フロー**:
1. **354-367行目（main.zig）**: `mem.eql(u8, cmd, "env")`でenvコマンドを検出
2. **12-65行目（print_env.zig）**: cmdEnv関数で全処理を実行

#### Step 3: パス解決を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | print_env.zig | `src/print_env.zig` | 21-45行目でパス情報を取得 |
| 3-2 | Compilation.zig | `src/Compilation.zig` | Directories構造体の初期化 |

**主要処理フロー**:
- **21-22行目**: 環境変数オーバーライドの取得
- **24-29行目**: 実行可能ファイルパスの取得（WASI対応）
- **31-40行目**: Compilation.Directories.init()でディレクトリ情報を初期化

#### Step 4: 出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | print_env.zig | `src/print_env.zig` | 48-64行目でZON出力を生成 |

**主要処理フロー**:
- **48行目**: std.zon.Serializerを初期化
- **49行目**: beginStruct()でルート構造体を開始
- **51-56行目**: 各フィールドを出力
- **57-61行目**: 環境変数フィールドをインラインforで列挙

### プログラム呼び出し階層図

```
src/main.zig::mainArgs()
    │
    └─ mem.eql(u8, cmd, "env") [envコマンド検出]
           │
           └─ print_env.zig::cmdEnv()
                  │
                  ├─ EnvVar.ZIG_LIB_DIR.get() [環境変数取得]
                  │
                  ├─ std.process.executablePathAlloc() [実行ファイルパス取得]
                  │
                  ├─ Compilation.Directories.init() [ディレクトリ情報初期化]
                  │
                  ├─ host.zigTriple() [ターゲットトリプル生成]
                  │
                  └─ std.zon.Serializer [ZON出力生成]
                         ├─ beginStruct()
                         ├─ field() [各フィールド出力]
                         └─ end()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

環境変数 ───────────────┐
  ZIG_LIB_DIR           │
  ZIG_GLOBAL_CACHE_DIR  │
  ...                   │
                        ├──▶ パス情報収集
実行ファイルパス ───────┤
                        │
ホストシステム情報 ─────┤
                        │
                        ├──▶ ZONシリアライザ ──────▶ 標準出力
                        │                              .{
                        │                                .zig_exe = "...",
                        │                                .lib_dir = "...",
                        │                                ...
                        │                              }
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | envコマンドのディスパッチ |
| print_env.zig | `src/print_env.zig` | ソース | cmdEnv関数の実装、メイン処理 |
| Compilation.zig | `src/Compilation.zig` | ソース | Directories構造体の定義と初期化 |
| introspect.zig | `src/introspect.zig` | ソース | Zigインストールディレクトリの検出 |
| build_options | `build_options` | 生成 | バージョン情報等のビルド時定数 |
