# 機能設計書 23-help

## 概要

本ドキュメントは、Zigコンパイラのhelp機能について記述する。この機能は、Zigコマンドの使用方法、利用可能なコマンド一覧、オプションなどのヘルプ情報を標準出力に表示する。

### 本機能の処理概要

**業務上の目的・背景**：
コマンドラインツールにおいて、ユーザーが使用方法を即座に確認できることは基本的かつ重要な機能である。Zigコンパイラは多くのサブコマンドとオプションを持つため、それらを一覧表示し、ユーザーが適切なコマンドを選択できるようにする必要がある。

**機能の利用シーン**：
- Zigを初めて使用する際のコマンド確認
- 利用可能なサブコマンドの一覧確認
- 特定コマンドのオプション確認
- デバッグコマンドの確認（デバッグビルド時のみ）

**主要な処理内容**：
1. help/--help/-hコマンドの検出
2. 使用方法（usage）文字列の出力
3. 利用可能なコマンド一覧の表示
4. 一般オプションの表示
5. デバッグコマンドの表示（デバッグビルド時）

**関連システム・外部連携**：
- 標準出力への書き込み

**権限による制御**：
本機能は特定の権限制御を持たない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | ヘルプ画面 | 主画面 | zig help / zig -h / zig --help 実行時のヘルプメッセージ表示処理 |

## 機能種別

情報表示処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| help / -h / --help | コマンド/フラグ | Yes | ヘルプ表示を要求 | 3種類のいずれか |

### 入力データソース

- コマンドライン引数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| usage | 文字列 | 使用方法とコマンド一覧 |

### 出力先

- 標準出力

### 出力内容

```
Usage: zig [command] [options]

Commands:

  build            Build project from build.zig
  fetch            Copy a package into global cache and print its hash
  init             Initialize a Zig package in the current directory

  build-exe        Create executable from source or object files
  build-lib        Create library from source or object files
  build-obj        Create object from source or object files
  test             Perform unit testing
  test-obj         Create object for unit testing
  run              Create executable and run immediately

  ast-check        Look for simple compile errors in any set of files
  fmt              Reformat Zig source into canonical form
  reduce           Minimize a bug report
  translate-c      Convert C code to Zig code

  ar               Use Zig as a drop-in archiver
  cc               Use Zig as a drop-in C compiler
  c++              Use Zig as a drop-in C++ compiler
  dlltool          Use Zig as a drop-in dlltool.exe
  lib              Use Zig as a drop-in lib.exe
  ranlib           Use Zig as a drop-in ranlib
  objcopy          Use Zig as a drop-in objcopy
  rc               Use Zig as a drop-in rc.exe

  env              Print lib path, std path, cache directory, and version
  help             Print this help and exit
  std              View standard library documentation in a browser
  libc             Display native libc paths file or validate one
  targets          List available compilation targets
  version          Print version number and exit
  zen              Print Zen of Zig and exit

General Options:

  -h, --help       Print command-specific usage

Debug Commands (デバッグビルド時のみ):

  changelist       Compute mappings from old ZIR to new ZIR
  dump-zir         Dump a file containing cached ZIR
  detect-cpu       Compare Zig's CPU feature detection vs LLVM
  llvm-ints        Dump a list of LLVMABIAlignmentOfType for all integers
```

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ args[1]がhelp/-h/--helpか確認

2. ヘルプ文字列の選択
   └─ デバッグビルドの場合: debug_usage（デバッグコマンド含む）
   └─ 通常ビルドの場合: normal_usage

3. 標準出力への書き込み
   └─ Io.File.stdout().writeStreamingAll()で出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{コマンドがhelp/-h/--help?}
    B -->|No| C[他のコマンド処理へ]
    B -->|Yes| D[dev.check実行]
    D --> E{デバッグビルド?}
    E -->|Yes| F[debug_usage選択]
    E -->|No| G[normal_usage選択]
    F --> H[usage文字列を標準出力に書き込み]
    G --> H
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 複数形式サポート | help、-h、--helpの3形式をサポート | 常時 |
| BR-02 | デバッグコマンド表示 | デバッグビルド時のみデバッグコマンドを表示 | enable_debug_extensions=true |
| BR-03 | 即座終了 | ヘルプ表示後は正常終了 | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | I/Oエラー | 標準出力への書き込み失敗 | プロセス終了 |

### リトライ仕様

本機能にリトライ機構は存在しない。

## トランザクション仕様

本機能はトランザクションを使用しない。

## パフォーマンス要件

- 即座に応答（10ms以内）
- 固定文字列の出力のみ

## セキュリティ考慮事項

- 機密情報は含まれない

## 備考

- usage文字列はコンパイル時に定数として定義されている
- normal_usageとdebug_usageの2種類が存在
- デバッグコマンドはbuild_options.enable_debug_extensionsがtrueの場合のみ表示

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ヘルプ文字列の定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | normal_usage定数（77-119行目）とdebug_usage定数（121-130行目） |

**読解のコツ**:
- Zigの複数行文字列リテラル（`\\`で始まる行の連結）を理解する
- debug_usageはnormal_usageを含むことに注目

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | helpコマンドのディスパッチ（376-378行目） |

**主要処理フロー**:
1. **376行目**: `mem.eql(u8, cmd, "help") or mem.eql(u8, cmd, "-h") or mem.eql(u8, cmd, "--help")`で3形式を検出
2. **377行目**: dev.check(.help_command)でフィーチャーチェック
3. **378行目**: Io.File.stdout().writeStreamingAll(io, usage)で出力

#### Step 3: 条件分岐を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | usage定数の定義（132行目） |

**主要処理フロー**:
- **132行目**: `const usage = if (build_options.enable_debug_extensions) debug_usage else normal_usage;`

### プログラム呼び出し階層図

```
src/main.zig::mainArgs()
    │
    └─ mem.eql(u8, cmd, "help") or ... [helpコマンド検出]
           │
           ├─ dev.check(.help_command) [フィーチャーチェック]
           │
           └─ Io.File.stdout().writeStreamingAll(io, usage)
                  │
                  └─ usage定数
                         ├─ normal_usage [通常ビルド]
                         └─ debug_usage [デバッグビルド]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ──────▶ コマンド判定
  args[1] = "help"           │
  args[1] = "-h"             │
  args[1] = "--help"         │
                             ▼
                        ビルドオプション判定 ──▶ usage文字列選択
                             │
                             ▼
                        writeStreamingAll() ──▶ 標準出力
                                                 Usage: zig [command]...
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | helpコマンドのディスパッチ、usage文字列の定義 |
| build_options | `build_options` | 生成 | enable_debug_extensionsの定義 |
| dev.zig | `src/dev.zig` | ソース | フィーチャーチェック機能 |
