# 機能設計書 24-std

## 概要

本ドキュメントは、Zigコンパイラのstd機能について記述する。この機能は、Zigの標準ライブラリドキュメントをブラウザで表示するためのローカルHTTPサーバーを起動し、WebAssemblyベースのドキュメントビューアを提供する。

### 本機能の処理概要

**業務上の目的・背景**：
プログラミング言語の学習や開発において、標準ライブラリのドキュメントへの素早いアクセスは生産性向上に不可欠である。Zigのstd機能は、ローカル環境でドキュメントサーバーを起動し、ブラウザで標準ライブラリのAPIリファレンスを閲覧できるようにする。これはAutodocと呼ばれる自動ドキュメント生成システムの一部である。

**機能の利用シーン**：
- 標準ライブラリのAPIリファレンスを確認する際
- 関数のシグネチャや使用例を調べる際
- オフライン環境でドキュメントを参照する際
- ドキュメントのデバッグや開発時

**主要な処理内容**：
1. コマンドライン引数の解析（ポート番号、ブラウザ自動起動設定）
2. HTTPサーバーの起動（デフォルトはエフェメラルポート）
3. ブラウザタブの自動起動（オプション）
4. HTTPリクエストの処理
   - index.html、main.jsの静的ファイル配信
   - WebAssemblyモジュール（main.wasm）のJITコンパイルと配信
   - 標準ライブラリソースのtarアーカイブ配信
5. リクエストごとのWASMバイナリ再ビルド（開発時の即時反映）

**関連システム・外部連携**：
- HTTPサーバー（std.http.Server）
- Webブラウザ（自動起動）
- Zigコンパイラ（WASMビルド用）

**権限による制御**：
本機能は特定の権限制御を持たない。ローカルホスト（127.0.0.1）でのみリッスンする。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 22 | 標準ライブラリドキュメント画面 | 主画面 | zig std コマンド実行時のドキュメント表示処理 |

## 機能種別

サーバー処理 / ドキュメント生成処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -h / --help | フラグ | No | ヘルプ表示 | - |
| -p / --port | u16 | No | リッスンポート番号（デフォルト: 0=エフェメラル） | 0-65535 |
| --open-browser | フラグ | No | ブラウザ自動起動を強制有効 | - |
| --no-open-browser | フラグ | No | ブラウザ自動起動を強制無効 | - |

### 入力データソース

- Zigライブラリディレクトリ: docs/index.html、docs/main.js、docs/wasm/
- 標準ライブラリソース: lib/std/

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTTP応答 | バイナリ/テキスト | HTMLページ、JavaScript、WebAssembly、tarアーカイブ |
| サーバーURL | 文字列 | 起動時に標準出力に表示（例: http://127.0.0.1:8080/） |

### 出力先

- HTTPレスポンス
- 標準出力（サーバーURL）
- 標準エラー出力（エラーメッセージ）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ ポート番号、ブラウザ起動設定を取得

2. HTTPサーバーの起動
   └─ 127.0.0.1:port でリッスン開始
   └─ ポート0の場合はOSがエフェメラルポートを割り当て

3. サーバーURL出力
   └─ 割り当てられたポートを含むURLを標準出力に表示

4. ブラウザ自動起動（設定に応じて）
   └─ Windows: explorer
   └─ macOS: open
   └─ その他: xdg-open

5. リクエスト処理ループ
   └─ accept()で接続を受け入れ
   └─ 非同期でリクエストを処理

6. リクエストルーティング
   └─ "/" または "/debug/": index.html
   └─ "/main.js" または "/debug/main.js": main.js
   └─ "/main.wasm": ReleaseFast WASMモジュール
   └─ "/debug/main.wasm": Debug WASMモジュール
   └─ "/sources.tar" または "/debug/sources.tar": 標準ライブラリソースtar
   └─ その他: 404 Not Found
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C{ヘルプ表示?}
    C -->|Yes| D[usage出力]
    D --> Z[終了]
    C -->|No| E[HTTPサーバー起動]
    E --> F[URL出力]
    F --> G{ブラウザ起動?}
    G -->|Yes| H[ブラウザタブを開く]
    G -->|No| I[リクエスト待機]
    H --> I
    I --> J[接続受け入れ]
    J --> K{パスの判定}
    K -->|/| L[index.html配信]
    K -->|/main.js| M[main.js配信]
    K -->|/main.wasm| N[WASM配信]
    K -->|/sources.tar| O[tar配信]
    K -->|その他| P[404応答]
    L --> I
    M --> I
    N --> I
    O --> I
    P --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | デフォルトブラウザ起動 | ポート未指定時（エフェメラルポート）はブラウザを自動起動 | port=0 |
| BR-02 | ポート指定時非起動 | ポートを明示的に指定した場合はブラウザを自動起動しない | port!=0 かつ --open-browser未指定 |
| BR-03 | ローカルホスト限定 | セキュリティのため127.0.0.1のみでリッスン | 常時 |
| BR-04 | リクエストごと再ビルド | WASMモジュールはリクエストごとに再ビルド（開発時変更即反映） | 常時 |

### 計算ロジック

**ブラウザ起動判定**:
```
should_open_browser = force_open_browser ?? (listen_port == 0)
```

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 起動エラー | ポートがすでに使用中 | 別のポートを指定 |
| HttpConnectionClosing | 接続終了 | クライアントが接続を閉じた | 正常終了として処理 |
| WasmCompilationFailed | ビルドエラー | WASMモジュールのコンパイル失敗 | エラーログを確認 |

### リトライ仕様

HTTPリクエスト処理でエラーが発生した場合、その接続は終了するが、サーバーは継続して他のリクエストを処理する。

## トランザクション仕様

本機能はトランザクションを使用しない。

## パフォーマンス要件

- 静的ファイル配信は即座（キャッシュ制御: max-age=0, must-revalidate）
- WASMビルドは数秒程度（キャッシュヒット時は高速）

## セキュリティ考慮事項

- 127.0.0.1のみでリッスン（外部からのアクセス不可）
- ファイルパスはライブラリディレクトリ内に限定

## 備考

- JITコンパイル機能を使用してstd-docs.zigを実行
- WebAssemblyモジュールはlib/docs/wasm/main.zigからビルド
- cache-control: max-age=0, must-revalidateにより常に最新を取得

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

サーバーコンテキストとリクエスト処理の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | std-docs.zig | `lib/compiler/std-docs.zig` | Context構造体（125-132行目） |

**読解のコツ**:
- Context構造体がサーバーの状態を保持
- gpa、io、lib_dir等のフィールドの役割を理解

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | stdコマンドのディスパッチ（334-341行目） |
| 2-2 | std-docs.zig | `lib/compiler/std-docs.zig` | main関数（24-89行目） |

**主要処理フロー**:
1. **334-341行目（main.zig）**: jitCmdでstd-docs.zigをJIT実行
2. **24-57行目（std-docs.zig）**: 引数解析（ポート、ブラウザ起動設定）
3. **60-66行目**: HTTPサーバー起動とURL出力
4. **67-71行目**: ブラウザ自動起動
5. **85-88行目**: リクエスト処理ループ

#### Step 3: HTTPリクエスト処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | std-docs.zig | `lib/compiler/std-docs.zig` | serveRequest関数（134-160行目） |
| 3-2 | std-docs.zig | `lib/compiler/std-docs.zig` | serveDocsFile関数（167-186行目） |
| 3-3 | std-docs.zig | `lib/compiler/std-docs.zig` | serveWasm関数（246-279行目） |
| 3-4 | std-docs.zig | `lib/compiler/std-docs.zig` | serveSourcesTar関数（188-244行目） |

**主要処理フロー**:
- **134-160行目**: パスに応じてハンドラを呼び分け
- **246-279行目**: WASMモジュールをビルドして配信
- **188-244行目**: 標準ライブラリソースをtarアーカイブとして配信

#### Step 4: WASMビルドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | std-docs.zig | `lib/compiler/std-docs.zig` | buildWasmBinary関数（285-425行目） |

**主要処理フロー**:
- **295-318行目**: zigコマンドの引数構築
- **320-325行目**: 子プロセスとしてzig build-exeを実行
- **341-373行目**: コンパイル結果のポーリング

### プログラム呼び出し階層図

```
src/main.zig::mainArgs()
    │
    └─ jitCmd() [stdコマンド検出時]
           │
           └─ lib/compiler/std-docs.zig::main()
                  │
                  ├─ 引数解析（ポート、ブラウザ設定）
                  │
                  ├─ address.listen() [HTTPサーバー起動]
                  │
                  ├─ openBrowserTab() [ブラウザ起動]
                  │
                  └─ リクエストループ
                         │
                         └─ accept() → serveRequest()
                                │
                                ├─ serveDocsFile() [静的ファイル]
                                │
                                ├─ serveWasm() [WASMモジュール]
                                │      └─ buildWasmBinary()
                                │             └─ zig build-exe [子プロセス]
                                │
                                └─ serveSourcesTar() [ソースtar]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ──────▶ main()
  --port, --open-browser      │
                              ▼
                         HTTPサーバー起動 ──────────▶ URL出力
                              │                        http://127.0.0.1:PORT/
                              ▼
HTTPリクエスト ─────────▶ serveRequest()
  GET /                       │
  GET /main.wasm              ├──▶ index.html
  GET /sources.tar            ├──▶ main.wasm [JITビルド]
                              └──▶ sources.tar

lib/docs/               ──────▶ 静的ファイル配信
  index.html
  main.js
  wasm/main.zig

lib/std/                ──────▶ tarアーカイブ生成 ──────▶ sources.tar
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | stdコマンドのディスパッチ |
| std-docs.zig | `lib/compiler/std-docs.zig` | ソース | HTTPサーバー実装、メイン処理 |
| index.html | `lib/docs/index.html` | HTML | ドキュメントビューアのエントリーページ |
| main.js | `lib/docs/main.js` | JavaScript | ドキュメントビューアのフロントエンド |
| main.zig | `lib/docs/wasm/main.zig` | ソース | WebAssemblyドキュメントパーサー |
| Walk.zig | `lib/docs/wasm/Walk.zig` | ソース | ソースコードウォーカー |
