# 機能設計書 25-libc

## 概要

本ドキュメントは、Zigコンパイラのlibc機能について記述する。この機能は、ネイティブlibcのパス情報を検出して表示するか、指定されたlibcパスファイルを検証する。

### 本機能の処理概要

**業務上の目的・背景**：
Zigはクロスコンパイルを重要な機能として位置付けており、異なるターゲット向けにビルドする際にはlibc（標準Cライブラリ）のパス情報が必要となる。libc機能は、ネイティブ環境のlibcパスを自動検出してユーザーに表示し、それをファイルに保存してクロスコンパイル用のlibc設定として再利用できるようにする。また、既存のlibcパスファイルの検証機能も提供する。

**機能の利用シーン**：
- ネイティブlibcのパス情報を確認する際
- クロスコンパイル用のlibcパスファイルを作成する際
- 既存のlibcパスファイルを検証する際
- libcインクルードディレクトリを確認する際

**主要な処理内容**：
1. コマンドライン引数の解析
2. ターゲット情報の解決
3. libcパスファイルの解析（指定時）または自動検出（未指定時）
4. インクルードディレクトリの表示（-includesオプション時）
5. libcパス情報の出力（標準出力）

**関連システム・外部連携**：
- ファイルシステムアクセス（libcパス検出）
- 環境変数の読み取り

**権限による制御**：
本機能は特定の権限制御を持たない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | libc情報画面 | 主画面 | zig libc コマンド実行時のlibc情報表示処理 |

## 機能種別

情報表示処理 / 検証処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| [paths_file] | ファイルパス | No | libcパスファイルのパス | 存在確認 |
| -h / --help | フラグ | No | ヘルプ表示 | - |
| -target | 文字列 | No | ターゲットトリプル（デフォルト: native） | 有効なターゲット |
| -includes | フラグ | No | libcインクルードディレクトリを表示 | - |

### 入力データソース

- libcパスファイル（指定時）
- システムのlibc情報（自動検出時）
- Zigライブラリディレクトリ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| libcパス情報 | テキスト | インクルードパス、ライブラリパス等 |
| インクルードディレクトリ | テキスト | -includes指定時のディレクトリ一覧 |

### 出力先

- 標準出力

### 出力形式例（libcパス情報）

```
include_dir=/usr/include
sys_include_dir=/usr/include
crt_dir=/usr/lib
msvc_lib_dir=
kernel32_lib_dir=
gcc_dir=
```

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ paths_file、-target、-includesの取得

2. ターゲット情報の解決
   └─ parseTargetQueryOrReportFatalError
   └─ resolveTargetQueryOrFatal

3. 処理分岐
   └─ -includes指定時: インクルードディレクトリ表示
   └─ paths_file指定時: ファイル解析・検証
   └─ 引数なし: ネイティブlibc検出・表示

4. 出力
   └─ 標準出力にlibc情報を出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C{ヘルプ表示?}
    C -->|Yes| D[usage出力]
    D --> Z[終了]
    C -->|No| E[ターゲット解決]
    E --> F{-includes?}
    F -->|Yes| G[インクルードディレクトリ検出]
    G --> H[ディレクトリ一覧出力]
    H --> Z
    F -->|No| I{paths_file指定?}
    I -->|Yes| J[ファイル解析・検証]
    J --> Z
    I -->|No| K{ネイティブ検出可能?}
    K -->|No| L[エラー: non-native target]
    L --> Z
    K -->|Yes| M[ネイティブlibc検出]
    M --> N[libc情報出力]
    N --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | ネイティブ検出制限 | 非ネイティブターゲットではlibc自動検出不可 | -target指定かつネイティブでない場合 |
| BR-02 | ファイル検証のみ | paths_file指定時は検証のみ（出力なし） | paths_file指定時 |
| BR-03 | verbose出力 | 自動検出時はverbose=trueで詳細出力 | 引数なし時 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 致命的エラー | libcパスファイルの解析失敗 | ファイル形式を確認 |
| - | 致命的エラー | ネイティブlibcの検出失敗 | システム環境を確認 |
| - | 致命的エラー | 非ネイティブターゲットでの自動検出試行 | -targetをnativeに変更 |
| - | 致命的エラー | インクルードディレクトリが見つからない | libc設定を確認 |

### リトライ仕様

本機能にリトライ機構は存在しない。

## トランザクション仕様

本機能はトランザクションを使用しない。

## パフォーマンス要件

- 即座に応答（数秒以内）
- ファイルシステムスキャンが主な処理時間

## セキュリティ考慮事項

- 機密情報は含まれない（パス情報のみ）

## 備考

- 出力形式はZigの--libcオプションで使用可能なフォーマット
- LibCInstallation構造体を使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

libcパス情報の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LibCInstallation | `lib/std/zig/LibCInstallation.zig` | libcパス情報の構造体定義 |

**読解のコツ**:
- include_dir、sys_include_dir、crt_dir等のフィールドの意味を理解
- parse()とfindNative()の2つの検出方法を把握

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | libcコマンドのディスパッチ（328-333行目） |
| 2-2 | libc.zig | `lib/compiler/libc.zig` | main関数（27-135行目） |

**主要処理フロー**:
1. **328-333行目（main.zig）**: jitCmdでlibc.zigをJIT実行
2. **27-65行目（libc.zig）**: 引数解析
3. **67-70行目**: ターゲット解決
4. **72-112行目**: -includes処理
5. **114-134行目**: libcパス情報出力

#### Step 3: libc検出を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | libc.zig | `lib/compiler/libc.zig` | LibCInstallation.parse（115行目） |
| 3-2 | libc.zig | `lib/compiler/libc.zig` | LibCInstallation.findNative（123行目） |

**主要処理フロー**:
- **114-118行目**: ファイルが指定された場合はparseで解析
- **119-130行目**: ファイル未指定の場合はfindNativeで自動検出

### プログラム呼び出し階層図

```
src/main.zig::mainArgs()
    │
    └─ jitCmd() [libcコマンド検出時]
           │
           └─ lib/compiler/libc.zig::main()
                  │
                  ├─ 引数解析
                  │
                  ├─ std.zig.parseTargetQueryOrReportFatalError()
                  │
                  ├─ std.zig.resolveTargetQueryOrFatal()
                  │
                  └─ 処理分岐
                         │
                         ├─ -includes: LibCDirs.detect()
                         │
                         ├─ paths_file: LibCInstallation.parse()
                         │
                         └─ なし: LibCInstallation.findNative()
                                    └─ libc.render() [出力]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ──────▶ 引数解析
  [paths_file]                │
  -target                     │
  -includes                   │
                              ▼
                         ターゲット解決
                              │
                              ▼
                         処理分岐 ─────────────────────▶ 標準出力
                              │                           include_dir=...
                              │                           sys_include_dir=...
システムlibc情報 ───────▶ 自動検出                        crt_dir=...
                              │
libcパスファイル ───────▶ ファイル解析
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | libcコマンドのディスパッチ |
| libc.zig | `lib/compiler/libc.zig` | ソース | libc機能のメイン処理 |
| LibCInstallation.zig | `lib/std/zig/LibCInstallation.zig` | 標準ライブラリ | libcパス情報の構造体と検出ロジック |
| LibCDirs.zig | `lib/std/zig/LibCDirs.zig` | 標準ライブラリ | libcディレクトリ検出 |
