# 機能設計書 26-targets

## 概要

本ドキュメントは、Zigコンパイラのtargets機能について記述する。この機能は、Zigがサポートする全てのコンパイルターゲット（アーキテクチャ、OS、ABI）、CPU、CPUフィーチャー、libc実装の一覧を表示する。

### 本機能の処理概要

**業務上の目的・背景**：
Zigはクロスコンパイルを第一級の機能としてサポートしており、様々なターゲットプラットフォーム向けにコードをビルドできる。targets機能は、利用可能な全てのターゲット情報を一覧表示し、開発者が適切なターゲットを選択できるようにする。これはビルド設定の確認やCI/CD環境での自動化に役立つ。

**機能の利用シーン**：
- クロスコンパイル時のターゲット確認
- 特定のCPUフィーチャーのサポート確認
- 利用可能なlibc実装の確認
- ネイティブ環境の詳細情報確認
- ビルドスクリプトでのターゲット検証

**主要な処理内容**：
1. Zigライブラリディレクトリの検出
2. glibc ABIリストのロード
3. 全アーキテクチャ、OS、ABIの列挙
4. 利用可能なlibc実装の列挙
5. glibc バージョンの列挙
6. CPU毎のモデルとフィーチャーの列挙
7. ネイティブターゲット情報の出力
8. ZON形式での出力

**関連システム・外部連携**：
- ファイルシステムアクセス（abilistsファイル読み込み）

**権限による制御**：
本機能は特定の権限制御を持たない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | ターゲット一覧画面 | 主画面 | zig targets コマンド実行時のターゲット一覧表示処理 |

## 機能種別

情報表示処理

## 入力仕様

### 入力パラメータ

本機能は引数を取らない。

### 入力データソース

- glibc abilistsファイル: lib/libc/glibc/abilists
- std.Targetのメタ情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| arch | 配列 | サポートされるアーキテクチャ一覧 |
| os | 配列 | サポートされるOS一覧 |
| abi | 配列 | サポートされるABI一覧 |
| libc | 配列 | 利用可能なlibc実装（ターゲットトリプル形式） |
| glibc | 配列 | サポートされるglibcバージョン一覧 |
| cpus | 構造体 | アーキテクチャ毎のCPUモデルとフィーチャー |
| cpu_features | 構造体 | アーキテクチャ毎の全CPUフィーチャー |
| native | 構造体 | ネイティブ環境の詳細情報 |

### 出力先

- 標準出力（ZON形式）

### 出力形式例

```zon
.{
    .arch = .{
        "aarch64",
        "aarch64_be",
        "arm",
        ...
    },
    .os = .{
        "linux",
        "windows",
        "macos",
        ...
    },
    .abi = .{
        "gnu",
        "musl",
        "msvc",
        ...
    },
    .libc = .{
        "aarch64-linux-gnu",
        "aarch64-linux-musl",
        ...
    },
    .glibc = .{
        "2.17",
        "2.18",
        ...
    },
    .cpus = .{
        .x86_64 = .{
            .generic = .{
                "64bit",
                "cmov",
                ...
            },
            .skylake = .{
                "64bit",
                "adx",
                ...
            },
            ...
        },
        ...
    },
    .cpu_features = .{
        .x86_64 = .{
            "64bit",
            "adx",
            "aes",
            ...
        },
        ...
    },
    .native = .{
        .triple = "x86_64-linux-gnu",
        .cpu = .{
            .arch = "x86_64",
            .name = "skylake",
            .features = .{
                "64bit",
                ...
            },
        },
        .os = "linux",
        .abi = "gnu",
    },
}
```

## 処理フロー

### 処理シーケンス

```
1. Zigライブラリディレクトリの検出
   └─ introspect.findZigLibDir()

2. glibc abilistsファイルの読み込み
   └─ glibc.abilists_pathからファイルを読み込み
   └─ glibc.loadMetaData()でメタデータをパース

3. ZONシリアライザの初期化
   └─ std.zon.Serializer

4. arch/os/abiの出力
   └─ meta.fieldNames()で全フィールドを列挙

5. libc実装の出力
   └─ std.zig.target.available_libcsを列挙

6. glibcバージョンの出力
   └─ glibc_abi.all_versionsを列挙

7. CPUモデルとフィーチャーの出力
   └─ 各アーキテクチャごとにallCpuModels()を呼び出し
   └─ 各モデルのフィーチャーを列挙

8. ネイティブターゲット情報の出力
   └─ native_target情報を出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Zigライブラリディレクトリ検出]
    B --> C[glibc abilists読み込み]
    C --> D[ZONシリアライザ初期化]
    D --> E[arch一覧出力]
    E --> F[os一覧出力]
    F --> G[abi一覧出力]
    G --> H[libc実装一覧出力]
    H --> I[glibcバージョン一覧出力]
    I --> J[CPUモデル/フィーチャー出力]
    J --> K[ネイティブ情報出力]
    K --> L[出力完了]
    L --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | ZON形式出力 | 出力は常にZON形式 | 常時 |
| BR-02 | ネイティブ情報含む | 実行環境のネイティブターゲット情報を含む | 常時 |
| BR-03 | 完全列挙 | 全てのサポートターゲットを列挙 | 常時 |

### 計算ロジック

**libcトリプル生成**:
```
libc_triple = "{arch}-{os}-{abi}"
```

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 致命的エラー | Zigインストールディレクトリが見つからない | Zigのインストールを確認 |
| - | 致命的エラー | abilistsファイルの読み込み失敗 | Zigのインストールを確認 |

### リトライ仕様

本機能にリトライ機構は存在しない。

## トランザクション仕様

本機能はトランザクションを使用しない。

## パフォーマンス要件

- 即座に応答（1秒以内）
- 出力データは数MB程度になる可能性あり

## セキュリティ考慮事項

- 機密情報は含まれない

## 備考

- 出力は大量のデータを含むため、パイプでjqやgrepと組み合わせて使用することを推奨
- native情報は実行環境によって変化する

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ターゲット情報のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Target.zig | `lib/std/Target.zig` | Cpu.Arch、Os.Tag、Abi等の列挙型 |

**読解のコツ**:
- std.meta.fieldNames()で列挙型のフィールド名を取得できる
- allCpuModels()で各アーキテクチャのCPUモデルを取得

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | targetsコマンドのディスパッチ（344-349行目） |
| 2-2 | print_targets.zig | `src/print_targets.zig` | cmdTargets関数（15-137行目） |

**主要処理フロー**:
1. **344-349行目（main.zig）**: targetsコマンドの検出とcmdTargets呼び出し
2. **23-26行目（print_targets.zig）**: Zigライブラリディレクトリ検出
3. **28-40行目**: glibc abilists読み込み
4. **47-49行目**: arch/os/abiフィールド出力
5. **51-59行目**: libc実装一覧出力
6. **61-69行目**: glibcバージョン一覧出力
7. **71-88行目**: CPUモデル出力
8. **90-100行目**: CPUフィーチャー出力
9. **102-131行目**: ネイティブ情報出力

### プログラム呼び出し階層図

```
src/main.zig::mainArgs()
    │
    └─ mem.eql(u8, cmd, "targets") [targetsコマンド検出]
           │
           ├─ dev.check(.targets_command)
           │
           ├─ std.zig.resolveTargetQueryOrFatal() [ネイティブターゲット解決]
           │
           └─ print_targets.zig::cmdTargets()
                  │
                  ├─ introspect.findZigLibDir() [ライブラリディレクトリ検出]
                  │
                  ├─ glibc.loadMetaData() [glibcメタデータ読み込み]
                  │
                  └─ std.zon.Serializer [ZON出力生成]
                         ├─ meta.fieldNames() [arch/os/abi]
                         ├─ available_libcs [libc一覧]
                         ├─ all_versions [glibcバージョン]
                         ├─ allCpuModels() [CPUモデル]
                         └─ native_target [ネイティブ情報]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

glibc abilists ─────────▶ glibc.loadMetaData()
  lib/libc/glibc/              │
  abilists                     │
                               ▼
std.Target ─────────────▶ meta.fieldNames() ───────────▶ arch/os/abi
                               │
                               ▼
std.zig.target ─────────▶ available_libcs ─────────────▶ libc一覧
                               │
                               ▼
glibc_abi ──────────────▶ all_versions ────────────────▶ glibcバージョン
                               │
                               ▼
Cpu.Arch ───────────────▶ allCpuModels() ──────────────▶ CPUモデル/フィーチャー
                               │
                               ▼
native_target ──────────▶ zigTriple() ─────────────────▶ ネイティブ情報

                                                            ↓
                                                    ZON形式で標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | targetsコマンドのディスパッチ |
| print_targets.zig | `src/print_targets.zig` | ソース | cmdTargets関数の実装 |
| Target.zig | `lib/std/Target.zig` | 標準ライブラリ | ターゲット情報の定義 |
| glibc.zig | `src/libs/glibc.zig` | ソース | glibcメタデータ処理 |
| introspect.zig | `src/introspect.zig` | ソース | Zigインストールディレクトリ検出 |
| abilists | `lib/libc/glibc/abilists` | データ | glibcシンボル情報 |
