# 機能設計書 27-version

## 概要

本ドキュメントは、Zigコンパイラのversion機能について記述する。この機能は、Zigコンパイラのバージョン番号を標準出力に表示する。

### 本機能の処理概要

**業務上の目的・背景**：
ソフトウェアのバージョン確認は、トラブルシューティング、互換性確認、ドキュメント参照などにおいて基本的かつ重要な機能である。version機能は、現在インストールされているZigコンパイラのバージョン番号を即座に表示し、ユーザーが使用しているバージョンを確認できるようにする。

**機能の利用シーン**：
- Zigのバージョンを確認する際
- バグレポート作成時にバージョン情報を記載する際
- ビルドスクリプトでバージョンを検証する際
- CI/CD環境でのバージョン確認時

**主要な処理内容**：
1. versionコマンドの検出
2. ビルド時に埋め込まれたバージョン文字列の出力
3. 改行付きで標準出力に表示

**関連システム・外部連携**：
- なし

**権限による制御**：
本機能は特定の権限制御を持たない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 25 | バージョン画面 | 主画面 | zig version コマンド実行時のバージョン表示処理 |

## 機能種別

情報表示処理

## 入力仕様

### 入力パラメータ

本機能は引数を取らない。

### 入力データソース

- build_options.version: ビルド時に埋め込まれたバージョン文字列

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| version | 文字列 | バージョン番号（例: 0.12.0） |

### 出力先

- 標準出力

### 出力形式例

```
0.12.0
```

## 処理フロー

### 処理シーケンス

```
1. versionコマンドの検出
   └─ mem.eql(u8, cmd, "version")

2. フィーチャーチェック
   └─ dev.check(.version_command)

3. バージョン文字列の出力
   └─ build_options.version + "\n"を標準出力に書き込み
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{cmd == "version"?}
    B -->|No| C[他のコマンド処理へ]
    B -->|Yes| D[dev.check実行]
    D --> E[バージョン文字列出力]
    E --> F[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 単純出力 | バージョン番号のみを改行付きで出力 | 常時 |
| BR-02 | ビルド時埋め込み | バージョンはコンパイル時に決定される | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | I/Oエラー | 標準出力への書き込み失敗 | プロセス終了 |

### リトライ仕様

本機能にリトライ機構は存在しない。

## トランザクション仕様

本機能はトランザクションを使用しない。

## パフォーマンス要件

- 即座に応答（1ms以内）
- 固定文字列の出力のみ

## セキュリティ考慮事項

- 機密情報は含まれない

## 備考

- バージョン文字列はbuild_options.versionとしてコンパイル時に埋め込まれる
- セマンティックバージョニング形式（major.minor.patch）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

バージョン情報の定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | build_options | `build_options` | versionフィールドの定義（ビルド時生成） |

**読解のコツ**:
- build_optionsはビルド時に生成されるモジュール
- versionはコンパイル時定数として埋め込まれる

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | versionコマンドのディスパッチ（350-353行目） |

**主要処理フロー**:
1. **350行目**: `mem.eql(u8, cmd, "version")`でversionコマンドを検出
2. **351行目**: dev.check(.version_command)でフィーチャーチェック
3. **352行目**: writeStreamingAllでバージョン文字列を出力

### プログラム呼び出し階層図

```
src/main.zig::mainArgs()
    │
    └─ mem.eql(u8, cmd, "version") [versionコマンド検出]
           │
           ├─ dev.check(.version_command) [フィーチャーチェック]
           │
           └─ Io.File.stdout().writeStreamingAll(io, build_options.version ++ "\n")
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ──────▶ コマンド判定
  args[1] = "version"        │
                             ▼
build_options.version ──────▶ 文字列連結 ──────────────▶ 標準出力
                             │                           "0.12.0\n"
                             └─ "\n"追加
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | versionコマンドのディスパッチ |
| build_options | `build_options` | 生成 | バージョン文字列の定義 |
| dev.zig | `src/dev.zig` | ソース | フィーチャーチェック機能 |
