# 機能設計書 3-build-obj

## 概要

本ドキュメントは、Zigコンパイラの`build-obj`コマンドの機能設計について記述する。このコマンドはZigソースコードまたは他のオブジェクトファイルからオブジェクトファイル（.o, .obj）を生成する機能である。

### 本機能の処理概要

`zig build-obj`コマンドは、Zigソースコード（.zig）、Cソースコード（.c, .cpp等）などの入力ファイルから、ターゲットプラットフォーム向けのオブジェクトファイルを生成する。ELF、Mach-O、COFF、WebAssembly形式に対応しており、後続のリンク処理で使用される中間成果物を生成する。

**業務上の目的・背景**：大規模なプロジェクトやビルドシステムでは、コンパイルとリンクを分離して行うことが一般的である。`build-obj`はコンパイル段階のみを実行し、オブジェクトファイルを生成する。これにより、並列コンパイル、インクリメンタルビルド、外部ビルドシステムとの統合が容易になる。また、C/C++プロジェクトにZigコードを組み込む際の中間ファイルとしても使用される。

**機能の利用シーン**：
- 外部ビルドシステム（CMake、Make等）からZigコードをコンパイルする場合
- コンパイルとリンクを分離して実行する場合
- 複数のオブジェクトファイルを個別に生成して後でリンクする場合
- WebAssemblyモジュールを生成する場合

**主要な処理内容**：
1. コマンドライン引数の解析とオプション設定
2. ターゲットプラットフォームの解決
3. 出力オブジェクト形式の決定（ELF/Mach-O/COFF/WASM等）
4. Zigソースコードの構文解析とZIR生成
5. セマンティック解析による型チェック
6. バックエンドによるコード生成
7. オブジェクトファイルの出力

**関連システム・外部連携**：
- LLVM：最適化とコード生成に使用（オプション）
- 外部ビルドシステム：生成されたオブジェクトファイルをリンク

**権限による制御**：特になし。ファイルシステムへの読み書き権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | オブジェクトビルド画面 | 主機能 | Zigソースコードからオブジェクトファイルを生成する処理 |

## 機能種別

コンパイル処理 / コード生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| files | []const u8 | Yes | ソースファイルのパス | 有効なファイルパスであること |
| -target | []const u8 | No | ターゲットアーキテクチャ | サポートされているターゲット |
| -O | OptimizeMode | No | 最適化モード | 有効な最適化モード |
| --name | []const u8 | No | 出力ファイル名 | 有効なファイル名 |
| -ofmt | ObjectFormat | No | 出力オブジェクト形式 | elf/coff/macho/wasm/c/spirv/plan9 |
| -fPIC | bool | No | 位置独立コードを生成 | - |
| -mcpu | []const u8 | No | ターゲットCPU指定 | - |

### 入力データソース

- コマンドライン引数
- Zigソースファイル（.zig）
- Cソースファイル（.c, .cpp等）
- アセンブリファイル（.s, .S）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ELFオブジェクト | バイナリ | Unix系向け .o ファイル |
| Mach-Oオブジェクト | バイナリ | macOS向け .o ファイル |
| COFFオブジェクト | バイナリ | Windows向け .obj ファイル |
| WebAssemblyオブジェクト | バイナリ | WASM .o ファイル |
| Cソースコード | テキスト | -ofmt=c指定時の .c ファイル |
| SPIR-Vバイナリ | バイナリ | GPU向け SPIR-V形式 |

### 出力先

- ファイルシステム（現在のディレクトリまたは指定されたパス）
- デフォルト出力名はソースファイル名に .o/.obj を付加

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ buildOutputType関数でArgMode.build(.Obj)として処理
2. ターゲット解決
   └─ アーキテクチャとオブジェクト形式の決定
3. 出力形式判定
   └─ -ofmtオプションまたはターゲットから自動判定
4. Compilation作成
   └─ output_mode = .Objで初期化
5. コード生成
   └─ 選択されたバックエンドでオブジェクトコード生成
6. オブジェクト出力
   └─ 指定形式でファイルに書き出し
```

### フローチャート

```mermaid
flowchart TD
    A[zig build-obj 開始] --> B[コマンドライン引数解析]
    B --> C{-ofmt指定?}
    C -->|Yes| D[指定形式を使用]
    C -->|No| E[ターゲットから形式推定]
    D --> F[Compilation作成]
    E --> F
    F --> G[ソースファイル処理]
    G --> H[ZIR生成]
    H --> I[Sema実行]
    I --> J[コード生成]
    J --> K{出力形式}
    K -->|ELF| L[ELFオブジェクト生成]
    K -->|Mach-O| M[Mach-Oオブジェクト生成]
    K -->|COFF| N[COFFオブジェクト生成]
    K -->|WASM| O[WASMオブジェクト生成]
    K -->|C| P[Cソースコード生成]
    L --> Q[ファイル出力]
    M --> Q
    N --> Q
    O --> Q
    P --> Q
    Q --> R[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | デフォルト出力形式 | ターゲットOSに応じた形式を自動選択 | -ofmt未指定時 |
| BR-02 | リンク処理なし | オブジェクトファイル生成のみでリンクは行わない | 常時 |
| BR-03 | 単一出力 | 入力ファイルごとに1つのオブジェクトを生成 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | FileNotFound | ソースファイルが存在しない | パス確認 |
| - | CompileError | コンパイルエラー | コード修正 |
| - | UnsupportedFormat | 未サポートの出力形式 | サポート形式を使用 |

### リトライ仕様

自動リトライなし

## トランザクション仕様

- アトミックなファイル書き込み
- 中間生成物はキャッシュに保存

## パフォーマンス要件

- インクリメンタルコンパイル対応
- 並列コンパイル対応

## セキュリティ考慮事項

- 入力ファイルのパス検証

## 備考

- Cバックエンド（-ofmt=c）を使用すると、ZigコードをCソースコードに変換可能
- SPIR-Vバックエンドを使用するとGPU向けコードを生成可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | build-objコマンドの分岐処理 |

**主要処理フロー**:
1. **267-269行目**: `mem.eql(u8, cmd, "build-obj")`で判定
2. **ArgMode = .{ .build = .Obj }** でオブジェクトモードを設定

#### Step 2: 出力形式の判定

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | -ofmtオプションの処理 |
| 2-2 | Compilation.zig | `src/Compilation.zig` | output_modeの処理 |

### プログラム呼び出し階層図

```
main (src/main.zig)
    │
    └─ buildOutputType (ArgMode = .build(.Obj))
            │
            ├─ 出力形式判定 (-ofmt)
            │
            ├─ Compilation.create (output_mode = .Obj)
            │
            └─ Compilation.update
                   └─ codegen (オブジェクト生成のみ)
```

### データフロー図

```
[入力]                [処理]                    [出力]

.zig ソース ───▶ コンパイル ──▶ コード生成 ──▶ .o / .obj ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンド分岐 |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理 |
| codegen.zig | `src/codegen.zig` | ソース | コード生成 |
| codegen/c.zig | `src/codegen/c.zig` | ソース | Cバックエンド |
| link/SpirV.zig | `src/link/SpirV.zig` | ソース | SPIR-V生成 |
