# 機能設計書 33-wasmバックエンド

## 概要

本ドキュメントは、ZigコンパイラにおけるWebAssembly（WASM）向けコード生成バックエンドの機能設計を記述する。

### 本機能の処理概要

wasmバックエンドは、ZigコンパイラのAIR（Abstract IR）をWebAssemblyバイトコードに変換する機能を提供する。WebAssemblyは、Webブラウザ上で高速に動作する低レベルのバイナリ形式であり、JavaScriptの代替として高パフォーマンスなWebアプリケーション開発を可能にする。また、WASI（WebAssembly System Interface）を通じてサーバーサイドや組み込み環境でも利用される。

**業務上の目的・背景**：WebAssemblyは、モダンWebブラウザの全てでサポートされる標準技術であり、Webアプリケーションのパフォーマンス向上に不可欠となっている。ゲームエンジン、画像処理、暗号化ライブラリなど計算集約型の処理をWeb上で実現するために広く利用されている。また、WASIの登場により、クラウドエッジコンピューティングやサーバーレス環境での利用も拡大している。

**機能の利用シーン**：
- Webブラウザ上で動作する高性能アプリケーションの開発
- WASIランタイム（Wasmtime、Wasmer等）上で動作するサーバーアプリケーション
- エッジコンピューティング環境でのポータブルなモジュール開発
- ブラウザ拡張機能やプラグインの開発

**主要な処理内容**：
1. AIR命令のWASM命令への変換
2. ローカル変数管理（スタックベース仮想マシン）
3. メモリレイアウトとスタック管理
4. SIMD128命令サポート（ターゲット機能有効時）
5. 関数型・間接呼び出しテーブル管理
6. UAV（Unified Address Value）参照の解決

**関連システム・外部連携**：WASMリンカと連携し、複数のWASMモジュールをリンクして最終的なWASMバイナリを生成する。

**権限による制御**：特になし（コンパイル時の処理）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | 実行ファイルビルド画面 | 遷移先機能 | WebAssembly向けコード生成処理 |

## 機能種別

コード生成処理 / 計算処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| air | Air | Yes | 抽象中間表現（変換対象の命令列） | 有効なAIR構造であること |
| liveness | Air.Liveness | Yes | 生存解析情報 | 有効な生存情報であること |
| owner_nav | InternPool.Nav.Index | Yes | オーナーナビゲーション | 有効なインデックスであること |
| target | std.Target | Yes | ターゲット情報 | wasm32またはwasm64であること |
| pt | Zcu.PerThread | Yes | スレッド別コンパイル単位情報 | 有効なPerThread構造であること |

### 入力データソース

- Sema（意味解析）フェーズで生成されたAIR
- 生存解析フェーズで計算されたLiveness情報
- コンパイル設定から取得したターゲット情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| mir_instructions | MultiArrayList(Mir.Inst) | MIR命令列 |
| mir_extra | ArrayList(u32) | 追加データ |
| mir_locals | ArrayList(std.wasm.Valtype) | ローカル変数型リスト |
| mir_uavs | AutoArrayHashMap | UAV参照マップ |
| mir_indirect_function_set | AutoArrayHashMap | 間接呼び出し関数セット |
| mir_func_tys | AutoArrayHashMap | 関数型セット |

### 出力先

WASMリンカへの引き渡し、最終的には.wasmファイル

## 処理フロー

### 処理シーケンス

```
1. 初期化フェーズ
   └─ ローカル変数インデックス、ブランチ管理の初期化
2. 呼び出し規約解決
   └─ 引数と戻り値のレイアウト決定
3. AIR命令処理
   └─ 各AIR命令をWASM命令に変換
4. スタック管理
   └─ 仮想スタックの操作（push/pop）
5. ブロック構造管理
   └─ block/loop/if構造の処理
6. MIR出力
   └─ 命令列とメタデータの生成
```

### フローチャート

```mermaid
flowchart TD
    A[開始: AIR入力] --> B[初期化]
    B --> C[呼び出し規約解決]
    C --> D[AIR命令変換]
    D --> E{スタック操作}
    E --> F[WValue生成]
    F --> G{ブロック構造?}
    G -->|Yes| H[ブロック管理]
    G -->|No| I[直接変換]
    H --> J[MIR出力]
    I --> J
    J --> K[終了: WASMリンカへ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-33-1 | スタックアライメント | 16バイト境界でスタックを整列 | 関数プロローグ |
| BR-33-2 | ローカル変数再利用 | 同一型のローカル変数は再利用可能 | 変数生存範囲終了後 |
| BR-33-3 | SIMD128条件 | SIMD128命令はターゲット機能有効時のみ使用 | simd128機能フラグ |

### 計算ロジック

- スタックサイズ: ローカル変数サイズ + アライメント調整
- ローカルインデックス: 引数数 + ローカル変数インデックス

## データベース操作仕様

該当なし（データベース操作は行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| AnalysisFail | 解析失敗 | AIR解析中のエラー | エラーメッセージを生成 |

### リトライ仕様

リトライ機構は実装されていない（コンパイル時エラーとして報告）

## トランザクション仕様

該当なし

## パフォーマンス要件

- 命令変換: O(n)（AIR命令数に比例）
- ローカル変数再利用により生成コードサイズを最適化

## セキュリティ考慮事項

- WebAssemblyのサンドボックス特性により、メモリ安全性が保証される
- 線形メモリの境界チェックは実行時に行われる

## 備考

wasm32とwasm64の両方をサポート。ptr_sizeフィールドでポインタサイズを区別する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、WASMバックエンド固有のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Mir.zig | `src/codegen/wasm/Mir.zig` | MIR命令構造、Inst型 |
| 1-2 | abi.zig | `src/codegen/wasm/abi.zig` | WASM ABI定義 |

**読解のコツ**: WASMはスタックベースの仮想マシンであるため、レジスタ概念がない。代わりにスタック上の値とローカル変数を操作する。

#### Step 2: エントリーポイントを理解する

コード生成の起点となるCodeGen.zigを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CodeGen.zig | `src/codegen/wasm/CodeGen.zig` | 主要構造体、WValue型 |

**主要処理フロー**:
1. **31-43行目**: legalizeFeatures関数（safe演算の展開設定）
2. **44-100行目**: 主要フィールド定義（owner_nav、block_depth、branches等）
3. **143-188行目**: WValue型（スタック値、ローカル変数、即値等の表現）

#### Step 3: ローカル変数管理を理解する

WASMのローカル変数とスタック管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CodeGen.zig | `src/codegen/wasm/CodeGen.zig` | free_locals_*フィールド（120-136行目） |

**主要処理フロー**:
- **120-136行目**: 型別フリーリスト（i32、i64、f32、f64、v128）によるローカル変数再利用

#### Step 4: 出力処理を理解する

MIR出力とリンカ連携を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Emit.zig | `src/codegen/wasm/Emit.zig` | バイナリ出力 |

### プログラム呼び出し階層図

```
codegen.zig (コード生成エントリ)
    │
    ├─ CodeGen.zig
    │      ├─ legalizeFeatures() - 合法化機能設定
    │      ├─ WValue管理 - スタック/ローカル値追跡
    │      ├─ ブランチ管理 - block/loop構造
    │      └─ ローカル変数再利用
    │
    ├─ Mir.zig
    │      └─ MIR構造定義
    │
    ├─ Emit.zig
    │      └─ バイナリ出力
    │
    └─ abi.zig
           └─ WASM ABI定義
```

### データフロー図

```
[入力]               [処理]                    [出力]

AIR命令列 ───▶ CodeGen処理 ───▶ MIR命令列
                     │
                     ▼
              WValue生成
                     │
                     ▼
           ローカル変数管理
                     │
                     ▼
              Emit処理 ───▶ WASMバイトコード
                                    │
                                    ▼
                              WASMリンカ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CodeGen.zig | `src/codegen/wasm/CodeGen.zig` | ソース | メインコード生成ロジック |
| Mir.zig | `src/codegen/wasm/Mir.zig` | ソース | MIR構造体定義 |
| Emit.zig | `src/codegen/wasm/Emit.zig` | ソース | バイナリ出力 |
| abi.zig | `src/codegen/wasm/abi.zig` | ソース | WASM ABI定義 |
