# 機能設計書 34-spirvバックエンド

## 概要

本ドキュメントは、ZigコンパイラにおけるSPIR-V（GPU向け中間表現）コード生成バックエンドの機能設計を記述する。

### 本機能の処理概要

spirvバックエンドは、ZigコンパイラのAIR（Abstract IR）をSPIR-V（Standard Portable Intermediate Representation）に変換する機能を提供する。SPIR-Vは、Vulkan、OpenCL、OpenGLなどのGPUコンピューティングAPIで使用される中間表現であり、GPUシェーダーやコンピュートカーネルの記述に利用される。

**業務上の目的・背景**：GPUコンピューティングは、機械学習、科学計算、グラフィックス処理など幅広い分野で不可欠な技術となっている。SPIR-Vは、Khronos Groupが策定したベンダー中立のGPU中間表現であり、様々なGPUハードウェア上で動作するポータブルなシェーダー/カーネルの開発を可能にする。ZigがSPIR-Vをサポートすることで、GPUアクセラレーションを活用したアプリケーション開発が可能となる。

**機能の利用シーン**：
- Vulkanグラフィックスアプリケーションのシェーダー開発
- OpenCLコンピュートカーネルの開発
- GPGPUアプリケーション（機械学習、物理シミュレーション等）
- クロスプラットフォームGPUコンピューティング

**主要な処理内容**：
1. AIR命令のSPIR-V OpCodeへの変換
2. 構造化制御フロー（selection/loop）の管理
3. 型システムのSPIR-V表現への変換
4. ID割り当てとインターン化
5. 関数シグネチャとエントリポイント管理
6. アセンブラによるSPIR-Vテキスト形式のパース（オプション）

**関連システム・外部連携**：SPIR-Vモジュールとして出力され、VulkanドライバやOpenCL実装で消費される。

**権限による制御**：特になし（コンパイル時の処理）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 直接関連する画面なし（GPUコード生成バックエンド） |

## 機能種別

コード生成処理 / 計算処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| air | Air | Yes | 抽象中間表現（変換対象の命令列） | 有効なAIR構造であること |
| liveness | Air.Liveness | Yes | 生存解析情報 | 有効な生存情報であること |
| owner_nav | InternPool.Nav.Index | Yes | オーナーナビゲーション | 有効なインデックスであること |
| module | *Module | Yes | SPIR-Vモジュール | 有効なモジュール参照であること |
| pt | Zcu.PerThread | Yes | スレッド別コンパイル単位情報 | 有効なPerThread構造であること |

### 入力データソース

- Sema（意味解析）フェーズで生成されたAIR
- 生存解析フェーズで計算されたLiveness情報
- SPIR-Vモジュール（既存の定義を参照）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| prologue | Section | 関数プロローグのSPIR-V命令 |
| body | Section | 関数本体のSPIR-V命令 |
| inst_results | AutoHashMap | AIR命令とSPIR-V IDのマッピング |

### 出力先

SPIR-Vモジュール（.spvファイル）

## 処理フロー

### 処理シーケンス

```
1. 初期化フェーズ
   └─ 制御フロー構造、引数リストの初期化
2. 関数プロローグ生成
   └─ OpFunction、OpFunctionParameter等の出力
3. AIR命令処理
   └─ 各AIR命令をSPIR-V OpCodeに変換
4. 制御フロー管理
   └─ 構造化制御フロー（selection/loop）の処理
5. エピローグ生成
   └─ OpFunctionEnd等の出力
6. モジュール統合
   └─ 関数をモジュールに登録
```

### フローチャート

```mermaid
flowchart TD
    A[開始: AIR入力] --> B[初期化]
    B --> C[関数プロローグ生成]
    C --> D[AIR命令変換]
    D --> E{制御フロー?}
    E -->|Yes| F[構造化制御フロー処理]
    E -->|No| G[直接変換]
    F --> H[ID生成・登録]
    G --> H
    H --> I[エピローグ生成]
    I --> J[モジュール統合]
    J --> K[終了: SPIR-Vモジュール]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-34-1 | 構造化制御フロー | SPIR-Vはgoto不可、構造化制御フロー必須 | 全ての制御フロー |
| BR-34-2 | SSA形式 | 全ての値は一度だけ定義される | 変数定義時 |
| BR-34-3 | ID一意性 | 各定義には一意のIDを割り当て | 定義生成時 |

### 計算ロジック

- ID割り当て: モジュール内で単調増加する整数ID
- 型インターン: 同一型は同一IDを再利用

## データベース操作仕様

該当なし（データベース操作は行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CodegenFail | コード生成失敗 | サポートされていない構造 | エラーメッセージを生成 |
| OutOfMemory | メモリ不足 | メモリ割り当て失敗 | エラーを伝播 |

### リトライ仕様

リトライ機構は実装されていない（コンパイル時エラーとして報告）

## トランザクション仕様

該当なし

## パフォーマンス要件

- 命令変換: O(n)（AIR命令数に比例）
- ID割り当て: O(1)（単純なカウンタ増分）

## セキュリティ考慮事項

- SPIR-V検証器（spirv-val）による検証を推奨
- GPU実行時のメモリアクセスはドライバが管理

## 備考

zig_call_abi_ver = 3 で呼び出し規約バージョンを管理。構造化制御フローと非構造化制御フローの両方をサポート。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、SPIR-V固有のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | spec.zig | `src/codegen/spirv/spec.zig` | SPIR-V OpCode、Id型、Word型 |
| 1-2 | Section.zig | `src/codegen/spirv/Section.zig` | SPIR-V命令セクション |
| 1-3 | Module.zig | `src/codegen/spirv/Module.zig` | SPIR-Vモジュール構造 |

**読解のコツ**: SPIR-Vは各命令がOpCodeとオペランドで構成される。Wordは32ビット整数、IdはSPIR-V内の参照識別子。

#### Step 2: エントリーポイントを理解する

コード生成の起点となるCodeGen.zigを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CodeGen.zig | `src/codegen/spirv/CodeGen.zig` | 主要構造体、ControlFlow型 |

**主要処理フロー**:
1. **31-43行目**: legalizeFeatures関数
2. **42行目**: zig_call_abi_ver定数
3. **44-143行目**: ControlFlow構造体（Structured/Unstructured）
4. **145-169行目**: 主要フィールド定義
5. **173行目以降**: genNav関数（ナビゲーション生成）

#### Step 3: 制御フロー管理を理解する

SPIR-V固有の構造化制御フロー管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CodeGen.zig | `src/codegen/spirv/CodeGen.zig` | ControlFlow.Structured型（44-110行目） |

**主要処理フロー**:
- **49-107行目**: Block型（selection/loop構造）
- **86-97行目**: loop構造のmerge管理

#### Step 4: アセンブラを理解する

SPIR-Vテキスト形式のパースを行うAssembler.zigを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Assembler.zig | `src/codegen/spirv/Assembler.zig` | SPIR-Vアセンブラ |

### プログラム呼び出し階層図

```
codegen.zig (コード生成エントリ)
    │
    ├─ CodeGen.zig
    │      ├─ legalizeFeatures() - 合法化機能設定
    │      ├─ genNav() - ナビゲーション生成
    │      ├─ ControlFlow管理
    │      │      ├─ Structured - 構造化制御フロー
    │      │      └─ Unstructured - 非構造化制御フロー
    │      └─ prologue/body セクション生成
    │
    ├─ Module.zig
    │      ├─ Decl管理
    │      ├─ Repr（表現）管理
    │      ├─ InternMap
    │      └─ PtrTypeMap
    │
    ├─ Section.zig
    │      └─ SPIR-V命令セクション
    │
    ├─ spec.zig
    │      ├─ Opcode
    │      ├─ Word
    │      ├─ Id/IdRange
    │      └─ StorageClass
    │
    └─ Assembler.zig
           └─ SPIR-Vテキストパース
```

### データフロー図

```
[入力]               [処理]                    [出力]

AIR命令列 ───▶ CodeGen処理 ───▶ SPIR-V命令列
                     │
                     ▼
              ID割り当て
                     │
                     ▼
           制御フロー構造化
                     │
                     ▼
              Section生成 ───▶ SPIR-Vモジュール
                                    │
                                    ▼
                              .spvファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CodeGen.zig | `src/codegen/spirv/CodeGen.zig` | ソース | メインコード生成ロジック |
| Module.zig | `src/codegen/spirv/Module.zig` | ソース | SPIR-Vモジュール管理 |
| Section.zig | `src/codegen/spirv/Section.zig` | ソース | SPIR-V命令セクション |
| spec.zig | `src/codegen/spirv/spec.zig` | ソース | SPIR-V仕様定義 |
| Assembler.zig | `src/codegen/spirv/Assembler.zig` | ソース | SPIR-Vアセンブラ |
