# 機能設計書 35-Cバックエンド

## 概要

本ドキュメントは、ZigコンパイラにおけるCソースコード生成バックエンド（トランスパイラ）の機能設計を記述する。

### 本機能の処理概要

Cバックエンドは、ZigコンパイラのAIR（Abstract IR）をCソースコードに変換する機能を提供する。これにより、Zigで書かれたコードを標準的なCコンパイラでコンパイル可能なソースコードとして出力できる。このトランスパイラ機能は、Zigがサポートしていないプラットフォームへのポーティングや、既存のCツールチェーンとの統合を可能にする。

**業務上の目的・背景**：Cは世界で最も広く使用されているシステムプログラミング言語であり、ほぼ全てのプラットフォームでCコンパイラが利用可能である。ZigコードをCに変換することで、以下の利点が得られる：(1) Zigがネイティブサポートしていないプラットフォームへのポーティング、(2) 既存のCベースビルドシステムとの統合、(3) Zigコンパイラのブートストラップ（セルフホスティング）、(4) レガシーシステムへの対応。

**機能の利用シーン**：
- Zigコンパイラ自体のブートストラップ（zig1）
- 組み込みシステムでCコンパイラのみ利用可能な場合
- セキュリティ監査でCソースコードが必要な場合
- 既存のCプロジェクトへのZigコード統合

**主要な処理内容**：
1. AIR命令のC言語構文への変換
2. 型のC言語表現への変換（CType管理）
3. ローカル変数とスコープ管理
4. 前方宣言（fwd_decl）の生成
5. コードヘッダーと本体の分離出力
6. UAV（Unified Address Value）参照の解決
7. 遅延関数（lazy functions）の管理

**関連システム・外部連携**：link.File.Cモジュールと連携し、生成されたCソースコードをファイルに出力する。

**権限による制御**：特になし（コンパイル時の処理）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 直接関連する画面なし（トランスパイラバックエンド） |

## 機能種別

コード生成処理 / トランスパイル処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| air | Air | Yes | 抽象中間表現 | 有効なAIR構造であること |
| target | std.Target | Yes | ターゲット情報 | 有効なターゲットであること |

### 入力データソース

- Sema（意味解析）フェーズで生成されたAIR
- コンパイル設定から取得したターゲット情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| code_header | []u8 | コードヘッダー（インクルードや型定義） |
| code | []u8 | 関数本体のCソースコード |
| fwd_decl | []u8 | 前方宣言 |
| ctype_pool | CType.Pool | C型プール |
| lazy_fns | LazyFnMap | 遅延関数マップ |
| uavs | AutoArrayHashMap | UAV参照マップ |

### 出力先

Cソースファイル（.c / .h）

## 処理フロー

### 処理シーケンス

```
1. 初期化フェーズ
   └─ ローカル変数、ブロック管理の初期化
2. 前方宣言生成
   └─ 関数・型の前方宣言を出力
3. コードヘッダー生成
   └─ インクルード、型定義を出力
4. AIR命令処理
   └─ 各AIR命令をC言語構文に変換
5. 本体コード生成
   └─ 関数本体のC言語コード出力
6. 遅延関数処理
   └─ @tagName等の遅延生成関数を出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始: AIR入力] --> B[初期化]
    B --> C[前方宣言生成]
    C --> D[コードヘッダー生成]
    D --> E[AIR命令変換]
    E --> F[CValue生成]
    F --> G[本体コード生成]
    G --> H[遅延関数処理]
    H --> I[MIR出力]
    I --> J[終了: Cソース出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-35-1 | C標準準拠 | C99/C11標準に準拠したコードを生成 | コード出力時 |
| BR-35-2 | 識別子マングリング | Zig識別子をC互換形式に変換 | 識別子出力時 |
| BR-35-3 | 型マッピング | Zig型をC型に適切にマッピング | 型宣言時 |

### 計算ロジック

- ローカル変数インデックス: LocalIndex（u16）で管理
- 型アライメント: CType.AlignAsで指定

## データベース操作仕様

該当なし（データベース操作は行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| AnalysisFail | 解析失敗 | 変換不可能な構造 | エラーメッセージを生成 |
| OutOfMemory | メモリ不足 | メモリ割り当て失敗 | エラーを伝播 |

### リトライ仕様

リトライ機構は実装されていない

## トランザクション仕様

該当なし

## パフォーマンス要件

- 命令変換: O(n)（AIR命令数に比例）
- 生成コードサイズ最適化よりも可読性を優先

## セキュリティ考慮事項

- 生成されたCコードはコンパイラの警告レベルに注意
- バッファオーバーフロー防止のためのサイズチェックを含む

## 備考

dev.envによってlegalize機能のサポートが条件分岐される。zig1（ブートストラップ）ではsafe最適化モードを使用しない。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Cバックエンド固有のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | c.zig | `src/codegen/c.zig` | Mir構造体、CValue型、CType参照 |
| 1-2 | c/Type.zig | `src/codegen/c/Type.zig` | CType型定義 |

**読解のコツ**: CValueはZig値のC表現であり、local/constant/nav/arg等の複数のバリアントを持つ。CTypeはC言語の型を表現する。

#### Step 2: エントリーポイントを理解する

コード生成の主要構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | c.zig | `src/codegen/c.zig` | legalizeFeatures関数、Mir構造体 |

**主要処理フロー**:
1. **26-43行目**: legalizeFeatures関数（合法化機能設定、dev.env依存）
2. **52-74行目**: Mir構造体（出力データ構造）
3. **80-159行目**: CValue型（Zig値のC表現）
4. **166-177行目**: LazyFnKey/LazyFnValue（遅延関数管理）
5. **178-193行目**: Local構造体（ローカル変数管理）

#### Step 3: 型管理を理解する

C言語型の管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | c/Type.zig | `src/codegen/c/Type.zig` | CType定義、Pool管理 |

**主要処理フロー**:
- CType.Pool: 型のインターン化と再利用
- AlignAs: アライメント指定

### プログラム呼び出し階層図

```
codegen.zig (コード生成エントリ)
    │
    ├─ c.zig
    │      ├─ legalizeFeatures() - 合法化機能設定
    │      ├─ Mir構造体 - 出力データ
    │      │      ├─ code_header
    │      │      ├─ code
    │      │      ├─ fwd_decl
    │      │      ├─ ctype_pool
    │      │      └─ lazy_fns
    │      ├─ CValue管理 - Zig値のC表現
    │      └─ Local管理 - ローカル変数
    │
    └─ c/Type.zig
           ├─ CType定義
           ├─ Pool管理
           └─ AlignAs
```

### データフロー図

```
[入力]               [処理]                    [出力]

AIR命令列 ───▶ Cバックエンド処理 ───▶ Mir構造体
                     │                        │
                     ▼                        ├─ code_header
              CValue生成                      ├─ code
                     │                        ├─ fwd_decl
                     ▼                        └─ ctype_pool
              CType解決
                     │
                     ▼
              Cソース生成 ───▶ .c / .hファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| c.zig | `src/codegen/c.zig` | ソース | メインCバックエンドロジック |
| c/Type.zig | `src/codegen/c/Type.zig` | ソース | C型定義とプール管理 |
