# 機能設計書 36-sparc64バックエンド

## 概要

本ドキュメントは、ZigコンパイラにおけるSPARC64アーキテクチャ向けネイティブコード生成バックエンドの機能設計を記述する。

### 本機能の処理概要

sparc64バックエンドは、ZigコンパイラのAIR（Abstract IR）をSPARC V9（64bit）アーキテクチャ向けのマシンコードに変換する機能を提供する。SPARCは主にSun Microsystems（現Oracle）のサーバーやワークステーションで使用されてきたRISCアーキテクチャである。

**業務上の目的・背景**：SPARC64は主に高信頼性が求められるエンタープライズサーバー環境で使用されてきた。Oracle/Fujitsuの大型サーバーやレガシーSolarisシステムでのソフトウェア開発に対応するため、ZigがSPARC64をサポートすることで、これらのエンタープライズ環境でのZig言語利用が可能となる。特に通信インフラや金融システムなど、長期運用が求められるシステムでの利用が想定される。

**機能の利用シーン**：
- Oracle SPARC Tシリーズサーバー向けアプリケーション開発
- 富士通SPARC64サーバー向けソフトウェア開発
- Solaris SPARC環境でのシステムソフトウェア開発
- レガシーSPARCワークステーションのサポート

**主要な処理内容**：
1. AIR命令のSPARC V9命令への変換
2. レジスタ割り当て（レジスタウィンドウ考慮）
3. スタックフレームレイアウト（スタックバイアス対応）
4. 条件コードレジスタ（CCR）管理
5. 命令エンコーディング（32ビット固定長）
6. リロケーション情報の生成

**関連システム・外部連携**：ELFリンカと連携し、SPARC64 ELF形式のオブジェクトファイルや実行可能ファイルを生成する。

**権限による制御**：特になし（コンパイル時の処理）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 直接関連する画面なし（コード生成バックエンド） |

## 機能種別

コード生成処理 / 計算処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| air | Air | Yes | 抽象中間表現 | 有効なAIR構造であること |
| liveness | Air.Liveness | Yes | 生存解析情報 | 有効な生存情報であること |
| target | std.Target | Yes | ターゲット情報 | cpu.archがsparc64であること |
| func_index | InternPool.Index | Yes | 関数インデックス | 有効なインデックスであること |
| pt | Zcu.PerThread | Yes | スレッド別コンパイル単位 | 有効なPerThread構造であること |

### 入力データソース

- Sema（意味解析）フェーズで生成されたAIR
- 生存解析フェーズで計算されたLiveness情報
- コンパイル設定から取得したターゲット情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| mir_instructions | MultiArrayList(Mir.Inst) | MIR命令列 |
| mir_extra | ArrayList(u32) | 追加データ |

### 出力先

ELFリンカへの引き渡し、SPARC64 ELFオブジェクトファイル

## 処理フロー

### 処理シーケンス

```
1. 初期化フェーズ
   └─ レジスタマネージャ、スタック管理の初期化
2. 引数処理
   └─ 関数引数のレジスタ/スタック割り当て
3. AIR命令処理
   └─ 各AIR命令をMIR命令に変換
4. Emit（出力）
   └─ バイナリコード生成
5. スタックバイアス適用
   └─ SPARCv9スタックバイアスの処理
```

### フローチャート

```mermaid
flowchart TD
    A[開始: AIR入力] --> B[初期化]
    B --> C[引数処理]
    C --> D[AIR命令変換]
    D --> E{MCValue生成}
    E --> F[MIR命令生成]
    F --> G[Emit処理]
    G --> H[スタックバイアス適用]
    H --> I[終了: ELFリンカへ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-36-1 | SPARCv9 ABI準拠 | SPARCv9 Application Binary Interfaceに準拠 | 関数呼び出し時 |
| BR-36-2 | レジスタウィンドウ | SAVE/RESTORE命令でレジスタウィンドウを管理 | 関数エントリ/終了時 |
| BR-36-3 | スタックバイアス | 2047バイトのスタックバイアスを適用 | スタックアクセス時 |

### 計算ロジック

- スタックバイアス: 2047バイト（SPARC V9固有）
- レジスタオフセット: realStackOffset()関数で変換

## データベース操作仕様

該当なし（データベース操作は行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| OutOfRegisters | リソース枯渇 | レジスタ不足 | スピルを実行 |
| CodeGenError | コード生成失敗 | サポートされていない構造 | エラー報告 |

### リトライ仕様

リトライ機構は実装されていない

## トランザクション仕様

該当なし

## パフォーマンス要件

- 命令変換: O(n)（AIR命令数に比例）
- 現在はmedium/lowコードモデルのみ対応

## セキュリティ考慮事項

- スタックオーバーフロー検出のための機構は実装依存

## 備考

現時点ではmedium/lowコードモデルと絶対アドレッシングのみサポート。他のコードモデルはTODO。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、SPARC64固有のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Mir.zig | `src/codegen/sparc64/Mir.zig` | MIR命令構造 |
| 1-2 | bits.zig | `src/codegen/sparc64/bits.zig` | Register型、Instruction型 |

**読解のコツ**: SPARCはレジスタウィンドウを持つため、caller/callee視点でレジスタを見る必要がある。RegisterViewで視点を切り替える。

#### Step 2: エントリーポイントを理解する

コード生成の起点となるCodeGen.zigを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CodeGen.zig | `src/codegen/sparc64/CodeGen.zig` | 主要構造体、MCValue型 |

**主要処理フロー**:
1. **1-40行目**: インポートと基本定義
2. **44-46行目**: legalizeFeatures関数（現在はnullを返す）
3. **48-51行目**: RegisterView列挙型（caller/callee）
4. **53-116行目**: 主要フィールド定義
5. **118-200行目**: MCValue型（レジスタ、即値、メモリ等の表現）

#### Step 3: レジスタ管理を理解する

SPARC固有のレジスタ管理とABIを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | abi.zig | `src/codegen/sparc64/abi.zig` | RegisterManager、RegisterClass |

**主要処理フロー**:
- RegisterClass.gp: 汎用レジスタクラス
- RegisterManager: レジスタ割り当て管理

#### Step 4: 出力処理を理解する

バイナリ出力を行うEmit.zigを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Emit.zig | `src/codegen/sparc64/Emit.zig` | バイナリ生成 |

### プログラム呼び出し階層図

```
codegen.zig (コード生成エントリ)
    │
    ├─ CodeGen.zig
    │      ├─ legalizeFeatures() - 現在null
    │      ├─ RegisterView - caller/callee視点
    │      ├─ MCValue管理
    │      ├─ branch_stack - ブランチ管理
    │      └─ register_manager - レジスタ管理
    │
    ├─ Mir.zig
    │      └─ MIR構造定義
    │
    ├─ Emit.zig
    │      └─ バイナリ出力
    │
    ├─ bits.zig
    │      ├─ Register
    │      ├─ Instruction
    │      ├─ ASI（Address Space Identifier）
    │      └─ ShiftWidth
    │
    └─ abi.zig
           ├─ RegisterManager
           └─ RegisterClass
```

### データフロー図

```
[入力]               [処理]                    [出力]

AIR命令列 ───▶ CodeGen処理 ───▶ MIR命令列
                     │
                     ▼
              MCValue生成
                     │
                     ▼
         レジスタウィンドウ管理
                     │
                     ▼
           スタックバイアス適用
                     │
                     ▼
              Emit処理 ───▶ SPARC64バイナリ
                                    │
                                    ▼
                              ELFリンカ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CodeGen.zig | `src/codegen/sparc64/CodeGen.zig` | ソース | メインコード生成ロジック |
| Mir.zig | `src/codegen/sparc64/Mir.zig` | ソース | MIR構造体定義 |
| Emit.zig | `src/codegen/sparc64/Emit.zig` | ソース | バイナリ出力 |
| bits.zig | `src/codegen/sparc64/bits.zig` | ソース | 基本型定義（Register、Instruction） |
| abi.zig | `src/codegen/sparc64/abi.zig` | ソース | 呼び出し規約とレジスタ管理 |
