# 機能設計書 38-MachOリンカ

## 概要

本ドキュメントは、ZigコンパイラにおけるMach-O形式のリンカ機能の設計を記述する。

### 本機能の処理概要

MachOリンカは、コンパイラが生成したオブジェクトファイルやフレームワークを結合し、macOS/iOS向けの実行可能ファイルやdylib（動的ライブラリ）を生成する機能を提供する。Zigはネイティブのリンカを実装しており、Apple純正のld64やLLVM lldに依存せずにリンク処理を実行できる。

**業務上の目的・背景**：Mach-OはAppleのmacOS、iOS、watchOS、tvOSで使用される標準的なバイナリ形式である。Zigがネイティブでリンカを実装することで、(1) Xcode/Command Line Toolsへの依存を軽減し、(2) Linux上でのmacOSクロスコンパイルを実現し、(3) インクリメンタルコンパイルをサポートし、(4) コード署名処理を統合できる。

**機能の利用シーン**：
- macOS向け実行可能ファイルの生成
- macOS向けdylib（動的ライブラリ）の生成
- iOS/watchOS/tvOS向けバイナリの生成
- macOSフレームワークの生成
- LinuxからmacOSへのクロスコンパイル

**主要な処理内容**：
1. 入力ファイル（オブジェクト、dylib、フレームワーク）の解析
2. シンボル解決とリロケーション処理
3. セグメント配置（__TEXT、__DATA、__LINKEDIT等）
4. ロードコマンドの生成
5. スタブ（stubs）とスタブヘルパー（stubs_helper）の構築
6. rebase/bind/lazy_bind/export情報の生成
7. コード署名（Code Signature）の生成
8. dSYM（デバッグシンボル）の分離出力

**関連システム・外部連携**：コードジェネレータ（aarch64、x86_64）から生成されたマシンコードを受け取り、最終的なMach-Oバイナリを出力する。

**権限による制御**：特になし（コンパイル時の処理）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | 実行ファイルビルド画面 | 遷移先機能 | Mach-O形式の実行可能ファイルのリンク処理（macOS） |

## 機能種別

リンク処理 / バイナリ生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| comp | *Compilation | Yes | コンパイル単位 | 有効なCompilationであること |
| emit | Path | Yes | 出力パス | 有効なパスであること |
| options | OpenOptions | Yes | リンクオプション | 有効なオプションであること |

### 入力データソース

- Zigコンパイラが生成したZigObject
- 外部オブジェクトファイル（.o）
- 動的ライブラリ（.dylib）
- フレームワーク（.framework）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| file | File.Handle | 出力ファイルハンドル |
| segments | ArrayList(macho.segment_command_64) | セグメントコマンド |
| sections | MultiArrayList(Section) | セクション情報 |
| symtab | ArrayList(macho.nlist_64) | シンボルテーブル |
| strtab | ArrayList(u8) | 文字列テーブル |

### 出力先

Mach-O実行可能ファイル、dylib、またはdSYMバンドル

## 処理フロー

### 処理シーケンス

```
1. 初期化フェーズ
   └─ ファイル作成、ロードコマンド構造初期化
2. 入力ファイル解析
   └─ オブジェクト、dylib、フレームワークの読み込み
3. シンボル解決
   └─ グローバルシンボルの解決、未定義シンボルの検出
4. セグメント配置
   └─ __PAGEZERO、__TEXT、__DATA、__LINKEDIT
5. リロケーション処理
   └─ rebase/bind情報の生成
6. スタブ構築
   └─ stubs、stubs_helper、la_symbol_ptrの生成
7. Export Trie構築
   └─ エクスポートシンボル情報の生成
8. コード署名
   └─ LC_CODE_SIGNATUREの生成
9. 出力
   └─ Mach-Oファイルの書き出し
```

### フローチャート

```mermaid
flowchart TD
    A[開始: 入力ファイル] --> B[初期化]
    B --> C[入力ファイル解析]
    C --> D[シンボル解決]
    D --> E{未定義シンボル?}
    E -->|Yes| F[動的ルックアップ/エラー]
    E -->|No| G[セグメント配置]
    G --> H[リロケーション処理]
    H --> I[スタブ構築]
    I --> J[Export Trie構築]
    J --> K[コード署名]
    K --> L[Mach-Oファイル出力]
    L --> M[終了]
    F --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-38-1 | PAGEZEROセグメント | 実行可能ファイルは__PAGEZEROを含む | 実行可能ファイル時 |
| BR-38-2 | 2レベル名前空間 | dylibは2レベル名前空間を使用 | dylib参照時 |
| BR-38-3 | コード署名必須 | macOS 10.15以降は署名必須 | 全出力ファイル |

### 計算ロジック

- PAGEZEROサイズ: 64ビットでは4GB（0x100000000）がデフォルト
- headerpad: 将来のロードコマンド拡張用の予約領域

## データベース操作仕様

該当なし（データベース操作は行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| undefined symbol | リンクエラー | 未定義シンボル | 動的ルックアップまたはエラー |
| duplicate symbol | リンクエラー | 重複シンボル | 両方の定義箇所を報告 |

### リトライ仕様

リトライ機構は実装されていない

## トランザクション仕様

該当なし

## パフォーマンス要件

- インクリメンタルリンク対応
- Hot code swapping対応（is_hot_update_compatible時）

## セキュリティ考慮事項

- コード署名（ad-hoc署名）の自動生成
- ハード化ランタイム対応（entitlements）
- __PAGEZEROによるNULLポインタ保護

## 備考

dSYMはデバッグ情報を分離して管理するmacOS固有の仕組み。DebugSymbols構造体で管理。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、MachOリンカの主要データ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MachO.zig | `src/link/MachO.zig` | 主要フィールド定義 |

**読解のコツ**: Mach-Oはセグメント→セクションの階層構造を持つ。segments/sectionsの関係を理解する。

#### Step 2: エントリーポイントを理解する

リンカの初期化と主要機能を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MachO.zig | `src/link/MachO.zig` | createEmpty関数（160行目以降） |

**主要処理フロー**:
1. **1-80行目**: 主要フィールド定義（files、segments、sections等）
2. **36-77行目**: ロードコマンド（dyld_info_cmd、symtab_cmd等）
3. **44-56行目**: セグメント/セクションインデックス
4. **60-77行目**: 出力セクション（symtab、strtab、got、stubs等）
5. **160-258行目**: createEmpty関数（初期化処理）

#### Step 3: スタブとバインディングを理解する

Mach-O固有のスタブ機構を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MachO.zig | `src/link/MachO.zig` | stubs、stubs_helper、la_symbol_ptr |

**主要処理フロー**:
- stubs_sect_index: スタブセクション
- stubs_helper_sect_index: スタブヘルパー
- la_symbol_ptr_sect_index: 遅延シンボルポインタ

#### Step 4: dSYMを理解する

デバッグシンボルの分離管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | MachO/DebugSymbols.zig | `src/link/MachO/DebugSymbols.zig` | DebugSymbols構造体 |

### プログラム呼び出し階層図

```
link.zig (リンカエントリ)
    │
    ├─ MachO.zig
    │      ├─ createEmpty() - 初期化
    │      ├─ open() - ファイルオープン
    │      ├─ flush() - 書き出し
    │      │
    │      ├─ files管理
    │      │      ├─ ZigObject
    │      │      ├─ Object
    │      │      ├─ Internal
    │      │      └─ Dylib
    │      │
    │      ├─ segments管理
    │      │      ├─ __PAGEZERO
    │      │      ├─ __TEXT
    │      │      ├─ __DATA
    │      │      └─ __LINKEDIT
    │      │
    │      ├─ ロードコマンド
    │      │      ├─ dyld_info_cmd
    │      │      ├─ symtab_cmd
    │      │      └─ codesig_cmd
    │      │
    │      └─ 出力セクション
    │             ├─ got
    │             ├─ stubs
    │             ├─ rebase_section
    │             └─ export_trie
    │
    ├─ MachO/Atom.zig
    │      └─ Atom構造体
    │
    ├─ MachO/Relocation.zig
    │      └─ リロケーション処理
    │
    └─ MachO/DebugSymbols.zig
           └─ dSYM管理
```

### データフロー図

```
[入力]               [処理]                    [出力]

ZigObject ───┐
             │
Object   ────┼──▶ シンボル解決 ───▶ セグメント配置 ───▶ Mach-Oファイル
             │         │                   │              │
Dylib    ────┘         ▼                   ▼              └──▶ dSYM
                  rebase/bind生成      スタブ構築
                       │                   │
                       ▼                   ▼
                  Export Trie ◀────────────┘
                       │
                       ▼
                  コード署名
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MachO.zig | `src/link/MachO.zig` | ソース | メインMachOリンカロジック |
| MachO/Atom.zig | `src/link/MachO/Atom.zig` | ソース | リンク単位Atom |
| MachO/Relocation.zig | `src/link/MachO/Relocation.zig` | ソース | リロケーション処理 |
| MachO/DebugSymbols.zig | `src/link/MachO/DebugSymbols.zig` | ソース | dSYM管理 |
