# 機能設計書 39-COFFリンカ

## 概要

本ドキュメントは、ZigコンパイラにおけるCOFF/PE形式のリンカ機能の設計を記述する。

### 本機能の処理概要

COFFリンカは、コンパイラが生成したオブジェクトファイルやインポートライブラリを結合し、Windows向けの実行可能ファイル（.exe）やDLL（動的リンクライブラリ）を生成する機能を提供する。COFF（Common Object File Format）はオブジェクトファイル形式、PE（Portable Executable）は実行可能ファイル形式であり、両者を組み合わせてCOFF/PE形式と呼ばれる。

**業務上の目的・背景**：PE/COFFはWindowsで使用される標準的なバイナリ形式である。Zigがネイティブでリンカを実装することで、(1) Visual StudioやMSVCへの依存を排除し、(2) Linux/macOSからWindowsへのクロスコンパイルを実現し、(3) MinGW互換の開発環境を提供できる。特にWindowsを主要ターゲットとするアプリケーション開発において重要な機能である。

**機能の利用シーン**：
- Windows向け実行可能ファイル（.exe）の生成
- Windows向けDLL（.dll）の生成
- Windowsサービスやドライバの開発
- Linux/macOSからWindowsへのクロスコンパイル
- MinGW/MSYS2環境での開発

**主要な処理内容**：
1. 入力ファイル（オブジェクト、インポートライブラリ）の解析
2. シンボル解決とリロケーション処理
3. セクション配置（.text、.data、.rdata、.idata等）
4. PE/COFFヘッダーの生成
5. インポートテーブル（IAT/ILT）の構築
6. TLS（Thread Local Storage）サポート
7. MS-DOSスタブの埋め込み

**関連システム・外部連携**：コードジェネレータ（x86_64、aarch64）から生成されたマシンコードを受け取り、最終的なPE/COFFバイナリを出力する。

**権限による制御**：特になし（コンパイル時の処理）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | 実行ファイルビルド画面 | 遷移先機能 | COFF/PE形式の実行可能ファイルのリンク処理（Windows） |

## 機能種別

リンク処理 / バイナリ生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| comp | *Compilation | Yes | コンパイル単位 | 有効なCompilationであること |
| emit | Path | Yes | 出力パス | 有効なパスであること |
| options | OpenOptions | Yes | リンクオプション | 有効なオプションであること |

### 入力データソース

- Zigコンパイラが生成したオブジェクト
- 外部オブジェクトファイル（.obj）
- インポートライブラリ（.lib）
- DLL

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| mf | MappedFile | メモリマップドファイル |
| nodes | MultiArrayList(Node) | PE構造ノード |
| symbol_table | ArrayList(Symbol) | シンボルテーブル |
| import_table | ImportTable | インポートテーブル |

### 出力先

PE実行可能ファイル（.exe）またはDLL（.dll）

## 処理フロー

### 処理シーケンス

```
1. 初期化フェーズ
   └─ MS-DOSスタブ、PEシグネチャの配置
2. 入力ファイル解析
   └─ オブジェクト、インポートライブラリの読み込み
3. シンボル解決
   └─ グローバルシンボル、外部シンボルの解決
4. セクション配置
   └─ .text、.data、.rdata、.idata、.tls等
5. インポートテーブル構築
   └─ Import Directory Table、ILT、IATの生成
6. リロケーション処理
   └─ ADDR32/REL32/ADDR64等のリロケーション
7. ヘッダー生成
   └─ COFF Header、Optional Header、Section Table
8. 出力
   └─ PEファイルの書き出し
```

### フローチャート

```mermaid
flowchart TD
    A[開始: 入力ファイル] --> B[MS-DOSスタブ配置]
    B --> C[入力ファイル解析]
    C --> D[シンボル解決]
    D --> E{未定義シンボル?}
    E -->|Yes| F[インポート解決/エラー]
    E -->|No| G[セクション配置]
    G --> H[インポートテーブル構築]
    H --> I[リロケーション処理]
    I --> J[ヘッダー生成]
    J --> K[PEファイル出力]
    K --> L[終了]
    F --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-39-1 | セクションアライメント | メモリ上は0x1000（4KB）、ファイル上は0x200（512B） | セクション配置時 |
| BR-39-2 | MS-DOSスタブ必須 | 全PEファイルはMS-DOSスタブを含む | PE生成時 |
| BR-39-3 | IAT書き込み可能 | IATはロード時に書き換えられるため.idataに配置 | インポート時 |

### 計算ロジック

- ファイルアライメント: デフォルト0x200（512バイト）
- セクションアライメント: デフォルト0x1000（4KB）
- スタック予約: デフォルト0x1000000（16MB）
- ヒープ予約: デフォルト0x100000（1MB）

## データベース操作仕様

該当なし（データベース操作は行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| undefined symbol | リンクエラー | 未定義シンボル | シンボル名を報告 |
| duplicate symbol | リンクエラー | 重複シンボル | 両方の定義箇所を報告 |

### リトライ仕様

リトライ機構は実装されていない

## トランザクション仕様

該当なし

## パフォーマンス要件

- MappedFileによる効率的なI/O

## セキュリティ考慮事項

- ASLR（Address Space Layout Randomization）対応
- DEP（Data Execution Prevention）対応
- /DYNAMICBASE、/NXCOMPAT相当の機能

## 備考

MS-DOSスタブは「This program cannot be run in DOS mode.」というメッセージを表示するプログラムを含む。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、COFFリンカの主要データ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Coff.zig | `src/link/Coff.zig` | 主要フィールド定義、Node型 |

**読解のコツ**: PE/COFFは複雑なヘッダー構造を持つ。MS-DOSスタブ→PEシグネチャ→COFFヘッダー→Optional Header→Section Tableの順序を理解する。

#### Step 2: MS-DOSスタブを理解する

PE互換性のためのMS-DOSスタブを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Coff.zig | `src/link/Coff.zig` | msdos_stub定数（67-117行目） |

**主要処理フロー**:
1. **67-82行目**: MS-DOSヘッダー（マジックナンバー「MZ」等）
2. **94-109行目**: MS-DOSプログラム（16ビットx86コード）
3. **111-117行目**: 「This program cannot be run in DOS mode.」メッセージ

#### Step 3: Node構造を理解する

PE構造を表現するNode型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Coff.zig | `src/link/Coff.zig` | Node型（119-255行目） |

**主要処理フロー**:
- **119-140行目**: Node列挙型（file、header、signature、coff_header等）
- **142-200行目**: 各種マップインデックス型
- **257-293行目**: ImportTable構造体

#### Step 4: シンボル管理を理解する

シンボルテーブルとインポートテーブルの管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Coff.zig | `src/link/Coff.zig` | symbol_table、import_table、globals |

### プログラム呼び出し階層図

```
link.zig (リンカエントリ)
    │
    ├─ Coff.zig
    │      ├─ msdos_stub - MS-DOSスタブ定義
    │      ├─ Node型 - PE構造表現
    │      │      ├─ file
    │      │      ├─ header
    │      │      ├─ signature
    │      │      ├─ coff_header
    │      │      ├─ optional_header
    │      │      ├─ data_directories
    │      │      ├─ section_table
    │      │      └─ image_section
    │      │
    │      ├─ ImportTable
    │      │      ├─ import_directory_table
    │      │      ├─ import_lookup_table
    │      │      ├─ import_address_table
    │      │      └─ import_hint_name_table
    │      │
    │      ├─ symbol_table
    │      ├─ globals
    │      ├─ navs
    │      └─ uavs
    │
    └─ MappedFile.zig
           └─ メモリマップドI/O
```

### データフロー図

```
[入力]               [処理]                    [出力]

Object    ───┐
             │
.lib     ────┼──▶ シンボル解決 ───▶ セクション配置 ───▶ PEファイル
             │         │                   │
DLL      ────┘         ▼                   ▼
                  インポート解決      ヘッダー生成
                       │                   │
                       ▼                   ▼
                  IAT/ILT構築 ◀────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Coff.zig | `src/link/Coff.zig` | ソース | メインCOFF/PEリンカロジック |
| MappedFile.zig | `src/link/MappedFile.zig` | ソース | メモリマップドファイルI/O |
