# 機能設計書 4-test

## 概要

本ドキュメントは、Zigコンパイラの`test`コマンドの機能設計について記述する。このコマンドはZigソースコードのユニットテストを実行する機能であり、Zig言語に内蔵されたテストフレームワークを使用する。

### 本機能の処理概要

`zig test`コマンドは、Zigソースコード内の`test`ブロックを収集し、コンパイル・実行することでユニットテストを実施する。テストフレームワークが言語に内蔵されているため、外部ライブラリなしでテストを記述・実行できる。

**業務上の目的・背景**：ソフトウェア開発において品質を担保するためにユニットテストは不可欠である。Zigは言語レベルでテスト機能をサポートしており、`test`ブロックを使ってテストを記述できる。`zig test`コマンドは、これらのテストを収集・実行し、結果を報告する。外部テストフレームワークに依存せず、言語統合された形でテストを実行できるため、セットアップの手間が最小化される。

**機能の利用シーン**：
- 開発中のコードの動作確認
- 継続的インテグレーション（CI）でのテスト実行
- リファクタリング時の回帰テスト
- ドキュメント内のコード例の検証

**主要な処理内容**：
1. コマンドライン引数の解析
2. ソースファイルからtestブロックを収集
3. テスト用実行可能ファイルの生成
4. テストの実行
5. 結果の収集と報告

**関連システム・外部連携**：
- Tracy統合：プロファイリング・トレーシング（オプション）
- fuzzer：ファジングテスト支援（オプション）

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | テスト実行画面 | 主機能 | Zigソースコードのユニットテストを実行する処理 |

## 機能種別

テスト実行 / 品質検証

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| files | []const u8 | Yes | テスト対象のソースファイル | 有効なファイルパス |
| -target | []const u8 | No | ターゲットアーキテクチャ | サポートされているターゲット |
| -O | OptimizeMode | No | 最適化モード | 有効な最適化モード |
| --test-filter | []const u8 | No | 実行するテストのフィルタ | - |
| --test-runner | []const u8 | No | カスタムテストランナー指定 | - |
| -fno-exec | bool | No | テスト実行をスキップ（コンパイルのみ） | - |
| -ffuzz | bool | No | ファジングテストを有効化 | - |

### 入力データソース

- コマンドライン引数
- Zigソースファイル（.zig）内のtestブロック

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| テスト結果 | テキスト | 各テストの成功/失敗と詳細 |
| 終了コード | 整数 | 0: 全テスト成功、1: テスト失敗あり |
| テストバイナリ | バイナリ | -femit-bin指定時のテスト実行ファイル |

### 出力先

- 標準出力（テスト結果）
- 標準エラー出力（エラーメッセージ）
- ファイルシステム（-femit-bin指定時）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ buildOutputType関数でArgMode = .zig_test として処理
2. ソースファイル解析
   └─ testブロックの収集
3. テスト用実行ファイル生成
   └─ output_mode = .Exe でコンパイル（is_test = true）
4. テスト実行
   └─ 生成された実行ファイルを起動
5. 結果報告
   └─ 成功/失敗のサマリー出力
```

### フローチャート

```mermaid
flowchart TD
    A[zig test 開始] --> B[コマンドライン引数解析]
    B --> C[ソースファイル解析]
    C --> D[testブロック収集]
    D --> E{testブロック存在?}
    E -->|Yes| F[テスト用実行ファイル生成]
    E -->|No| G[警告出力]
    F --> H{-fno-exec?}
    H -->|Yes| I[コンパイルのみ完了]
    H -->|No| J[テスト実行]
    J --> K{全テスト成功?}
    K -->|Yes| L[成功メッセージ出力]
    K -->|No| M[失敗詳細出力]
    L --> N[終了コード0で終了]
    M --> O[終了コード1で終了]
    G --> N
    I --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | テストブロック収集 | ファイル内のすべてのtestブロックを収集 | 常時 |
| BR-02 | テストフィルタ | --test-filterで指定した名前に一致するテストのみ実行 | オプション指定時 |
| BR-03 | 失敗時終了コード | テスト失敗時は終了コード1を返す | テスト失敗時 |
| BR-04 | is_testフラグ | テストモードではis_test = trueが設定される | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CompileError | テストコードにエラー | コード修正 |
| - | TestFailure | テストアサーション失敗 | テストまたは実装を修正 |
| - | Panic | テスト中にパニック発生 | コードを調査 |

### リトライ仕様

自動リトライなし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 並列テスト実行対応
- キャッシュによる再コンパイル回避

## セキュリティ考慮事項

- テストコードはサンドボックス環境での実行を推奨

## 備考

- `test`ブロック内で`std.testing`モジュールのアサーション関数を使用
- `@import("builtin").is_test`でテストモードを検出可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | testコマンドの分岐処理 |

**主要処理フロー**:
1. **270-272行目**: `mem.eql(u8, cmd, "test")`で判定
2. **ArgMode = .zig_test** でテストモードを設定
3. **964-966行目**: `is_test = true`の設定

#### Step 2: テスト用コンパイルの設定

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | create_module.opts.is_testの設定 |
| 2-2 | Compilation.zig | `src/Compilation.zig` | テストモードでのCompilation作成 |

### プログラム呼び出し階層図

```
main (src/main.zig)
    │
    └─ buildOutputType (ArgMode = .zig_test)
            │
            ├─ create_module.opts.is_test = true
            │
            ├─ Compilation.create (output_mode = .Exe, is_test = true)
            │
            ├─ Compilation.update
            │      └─ testブロックのコンパイル
            │
            └─ テスト実行 (test_no_execでない場合)
```

### データフロー図

```
[入力]                    [処理]                    [出力]

.zig ソース ───▶ testブロック収集 ───▶ コンパイル ───▶ テスト実行 ───▶ 結果出力
      │                                                    │
      └── test "name" { ... } ────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンド分岐、テスト実行 |
| Compilation.zig | `src/Compilation.zig` | ソース | テスト用コンパイル |
| testing.zig | `lib/std/testing.zig` | ライブラリ | テストアサーション関数 |
| fuzzer.zig | `lib/fuzzer.zig` | ライブラリ | ファジング支援 |
