# 機能設計書 41-Plan9リンカ

## 概要

本ドキュメントは、ZigコンパイラにおけるPlan 9オブジェクト形式のリンク機能について記述する。Plan 9はベル研究所で開発された分散オペレーティングシステムであり、独自のオブジェクトファイル形式を持つ。

### 本機能の処理概要

Plan 9リンカは、Plan 9オペレーティングシステム向けにコンパイルされたオブジェクトファイルをリンクし、Plan 9で実行可能なバイナリを生成する機能である。

**業務上の目的・背景**：Plan 9はUNIXの後継として設計された研究用オペレーティングシステムであり、その設計哲学は現代の多くのシステムに影響を与えている。ZigがPlan 9をターゲットとしてサポートすることで、この歴史的かつ教育的に重要なプラットフォームでのZig言語の利用が可能となる。また、9front（Plan 9のアクティブなフォーク）コミュニティへの対応も視野に入れている。

**機能の利用シーン**：
- Plan 9オペレーティングシステム上で動作するネイティブアプリケーションの開発
- 9frontディストリビューション向けのソフトウェア開発
- Plan 9互換環境（plan9port等）での開発
- 教育・研究目的でのPlan 9システムプログラミング

**主要な処理内容**：
1. Plan 9オブジェクトファイル形式の解析
2. シンボル解決とアドレス割り当て
3. Plan 9実行可能ファイルヘッダの生成
4. コードセクションとデータセクションの配置
5. リロケーション処理の適用

**関連システム・外部連携**：
- Zigコンパイラのコード生成バックエンド
- Plan 9カーネルローダー
- Plan 9のa.out形式互換ツール

**権限による制御**：特になし（コマンドライン引数による制御のみ）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | Plan 9リンカは画面を持たないバッチ処理機能 |

## 機能種別

リンク処理 / バイナリ生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ofmt | ObjectFormat | Yes | オブジェクト形式（.plan9） | 有効なObjectFormat列挙値 |
| target | Target | Yes | ターゲットアーキテクチャ情報 | Plan 9対応アーキテクチャ |
| objects | []Object | Yes | リンク対象オブジェクトファイル | 有効なPlan 9オブジェクト形式 |
| output_path | Path | Yes | 出力ファイルパス | 書き込み可能なパス |

### 入力データソース

- コンパイラが生成したPlan 9形式のオブジェクトファイル
- 外部ライブラリのオブジェクトファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| executable | File | Plan 9実行可能バイナリ |
| symbols | SymbolTable | シンボルテーブル情報 |

### 出力先

Plan 9形式の実行可能ファイル（a.out形式）

## 処理フロー

### 処理シーケンス

```
1. オブジェクトファイルの読み込み
   └─ Plan 9オブジェクトヘッダの解析
2. シンボルテーブルの構築
   └─ 全オブジェクトからシンボルを収集
3. シンボル解決
   └─ 未定義シンボルの解決と重複チェック
4. セクション配置
   └─ コード・データセクションのメモリ配置決定
5. リロケーション処理
   └─ アドレス参照の修正
6. 実行可能ファイルの生成
   └─ Plan 9 a.outヘッダと各セクションの出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[オブジェクトファイル読み込み]
    B --> C[シンボルテーブル構築]
    C --> D{未定義シンボルあり?}
    D -->|Yes| E[エラー: undefined symbol]
    D -->|No| F[セクション配置計算]
    F --> G[リロケーション処理]
    G --> H[実行可能ファイル生成]
    H --> I[終了]
    E --> J[エラー終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-41-01 | アーキテクチャ制約 | Plan 9はx86, amd64, arm等の特定アーキテクチャのみサポート | ターゲット指定時 |
| BR-41-02 | シンボル解決順序 | オブジェクトファイルは指定順に処理 | リンク時 |

### 計算ロジック

Plan 9実行可能ファイルのセクション配置は、テキストセクションを固定アドレスから開始し、データセクション、BSSセクションが続く構造となる。

## データベース操作仕様

該当なし（ファイルベースの処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| UnsupportedObjectFormat | リンクエラー | Plan 9形式が未サポート | 現在の実装では未対応 |
| UndefinedSymbol | シンボルエラー | 未定義シンボル参照 | 必要なオブジェクトを追加 |

### リトライ仕様

リンク処理はリトライなし（失敗時は即時エラー終了）

## トランザクション仕様

該当なし（ファイル生成は原子的に実行、失敗時は部分ファイル削除）

## パフォーマンス要件

大規模プロジェクトでも数秒以内にリンク完了すること

## セキュリティ考慮事項

- 入力オブジェクトファイルの妥当性検証
- 出力先パスの検証（パストラバーサル対策）

## 備考

**現在の実装状況**：Plan 9リンカはZigにおいて**未実装**である。`src/link.zig`において`Tag.plan9`は定義されているが、実際のリンク処理を行う`Plan9.zig`は存在せず、関連する処理はすべて`unreachable`としてマークされている。

将来的な実装の際には、以下のリソースが参考となる：
- Plan 9のa.out形式仕様
- 既存のELF/COFF/MachOリンカの実装パターン

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: リンカインターフェースを理解する

Plan 9リンカは未実装であるが、他のリンカとの統一インターフェースを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | link.zig | `src/link.zig` | File構造体とTag列挙型でリンカの共通インターフェースを定義 |

**読解のコツ**:
- `Tag`列挙型（1230-1236行目）でサポートされるオブジェクト形式を確認
- `plan9`タグが存在するが、`Type()`関数では`comptime unreachable`（1248行目）

**主要処理フロー**:
1. **543行目**: `case .plan9 => return error.UnsupportedObjectFormat` - Plan 9形式は未サポートエラーを返す
2. **1258行目**: `fromObjectFormat`関数で`.plan9`から`.plan9`タグへの変換を定義

#### Step 2: 他のリンカ実装を参考にする

Plan 9リンカ実装時の参考として、既存のリンカ実装パターンを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Elf.zig | `src/link/Elf.zig` | ELFリンカの実装パターン（最も成熟した実装） |
| 2-2 | Wasm.zig | `src/link/Wasm.zig` | WebAssemblyリンカ（比較的シンプルな実装） |

**読解のコツ**:
- `base: link.File`フィールドで共通インターフェースを継承
- `flush`関数がリンク処理のエントリーポイント

#### Step 3: ターゲット定義を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | target.zig | `src/target.zig` | Plan 9ターゲット関連の定義を確認 |

### プログラム呼び出し階層図

```
main.zig (コンパイラエントリー)
    │
    ├─ Compilation.zig
    │      │
    │      └─ link.zig (リンカ共通インターフェース)
    │             │
    │             ├─ File.open() / File.createEmpty()
    │             │      └─ Tag.plan9 => error.UnsupportedObjectFormat
    │             │
    │             └─ [未実装: Plan9.zig]
    │
    └─ 他のリンカ実装（参考）
           ├─ Elf.zig
           ├─ MachO.zig
           ├─ Coff.zig
           └─ Wasm.zig
```

### データフロー図

```
[入力]                    [処理]                      [出力]

Plan 9                    [未実装]                    Plan 9
オブジェクト  ───▶    Plan9リンカ  ───▶         実行可能ファイル
ファイル                                             (a.out形式)
    │
    └── 現在は error.UnsupportedObjectFormat を返す
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| link.zig | `src/link.zig` | ソース | リンカ共通インターフェース定義、Plan 9タグ定義 |
| target.zig | `src/target.zig` | ソース | ターゲットアーキテクチャ定義 |
| dev.zig | `src/dev.zig` | ソース | 開発機能フラグ（plan9_linkerフィーチャー） |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイルパイプライン制御 |
| Elf.zig | `src/link/Elf.zig` | ソース | 参考実装：ELFリンカ |
| Wasm.zig | `src/link/Wasm.zig` | ソース | 参考実装：WASMリンカ |
