# 機能設計書 43-Sema（意味解析）

## 概要

本ドキュメントは、Zigコンパイラの中核をなすセマンティック解析（Sema）モジュールについて記述する。Semaは「Zigコンパイラの心臓部」と位置づけられ、ZIR（Zig Intermediate Representation）命令をAIR（Analyzed Intermediate Representation）命令に変換する役割を担う。

### 本機能の処理概要

Semaは、型チェック、コンパイル時制御フロー、安全性チェック生成を行い、型なしのZIR命令を意味解析済みのAIR命令に変換する機能である。

**業務上の目的・背景**：Zigは静的型付け言語であり、コンパイル時に型の整合性を検証することで、ランタイムエラーを未然に防ぐ。Semaはこの型検証の中心的役割を果たし、さらにZig特有のコンパイル時実行（comptime）機能を実現する。1.6MB超のソースコードを持つ最大モジュールであり、言語仕様の大部分がここで実装されている。

**機能の利用シーン**：
- すべてのZigコードのコンパイル時
- 型推論と型チェックの実行
- コンパイル時関数実行（comptime）
- ジェネリック関数のインスタンス化
- エラーメッセージ生成

**主要な処理内容**：
1. ZIR命令の解析とAIR命令への変換
2. 型チェックと型強制（coercion）
3. コンパイル時定数評価
4. 安全性チェックコードの挿入
5. インライン関数とcomptime関数の展開
6. エラーセットの推論

**関連システム・外部連携**：
- ZIR（入力）：ASTから生成された中間表現
- AIR（出力）：コード生成用の解析済み中間表現
- InternPool：型と値のインターン化
- Type/Value：型・値システム

**権限による制御**：特になし（コンパイラ内部処理）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | 実行ファイルビルド画面 | 補助機能 | ビルド時の型チェックと意味解析処理 |
| 4 | ライブラリビルド画面 | 補助機能 | ビルド時の型チェックと意味解析処理 |
| 5 | オブジェクトビルド画面 | 補助機能 | ビルド時の型チェックと意味解析処理 |
| 6 | テスト実行画面 | 補助機能 | テストコードの型チェックと意味解析処理 |
| 9 | AST検査画面 | 補助機能 | 構文解析後の意味解析処理 |

## 機能種別

コンパイラ処理 / 型チェック / コード変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| code | Zir | Yes | 解析対象のZIR命令列 | 有効なZIR構造 |
| owner | AnalUnit | Yes | 解析対象のオーナー（関数/宣言） | 有効なAnalUnit |
| func_index | InternPool.Index | No | 解析中の関数 | func_decl or func_instance |
| fn_ret_ty | Type | No | 関数の戻り値型 | 有効なType |

### 入力データソース

- AstGen（AST → ZIR変換）から生成されたZIR

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| air_instructions | MultiArrayList(Air.Inst) | 解析済みAIR命令列 |
| air_extra | ArrayList(u32) | AIR追加データ |
| exports | ArrayList(Export) | エクスポート情報 |
| error_msg | ?*ErrorMsg | エラーメッセージ（エラー時） |

### 出力先

コード生成バックエンド（codegen.zig）へのAIR

## 処理フロー

### 処理シーケンス

```
1. Sema初期化
   └─ allocator, arena, ownerなどの設定
2. ZIR命令の走査
   └─ 各命令を順番に処理
3. 命令ごとの解析
   └─ 型チェック、変換、AIR生成
4. コンパイル時評価
   └─ comptime式の即座評価
5. 型強制（Coercion）
   └─ 必要な型変換の挿入
6. 安全性チェック挿入
   └─ bounds check, null check等
7. AIR命令リストの完成
   └─ codegenへ渡す形式で出力
```

### フローチャート

```mermaid
flowchart TD
    A[ZIR入力] --> B[Sema初期化]
    B --> C{命令ループ}
    C --> D[命令解析]
    D --> E{comptime?}
    E -->|Yes| F[コンパイル時評価]
    E -->|No| G[型チェック]
    F --> H[値をAIRに挿入]
    G --> I{型一致?}
    I -->|No| J[型強制or エラー]
    I -->|Yes| K[AIR命令生成]
    J --> K
    H --> C
    K --> C
    C -->|完了| L[AIR出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-43-01 | ブランチクォータ | comptime評価のループ回数制限（デフォルト1000） | comptime実行時 |
| BR-43-02 | 安全性チェック | Debug/ReleaseSafeで安全性チェック有効 | モード依存 |
| BR-43-03 | 型推論 | anytypeパラメータは呼び出し時に具体化 | ジェネリック関数 |
| BR-43-04 | エラーセット推論 | 関数の戻り値からエラーセットを推論 | inferred error set |

### 計算ロジック

**ブランチクォータ（branch_quota）**：
- デフォルト値: 1000
- @setEvalBranchQuotaで変更可能
- コンパイル時ループ/再帰の無限ループ防止

## データベース操作仕様

該当なし（メモリ上での処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TypeError | 型エラー | 型の不一致 | 正しい型を使用 |
| EvalError | 評価エラー | comptime評価失敗 | ロジックを修正 |
| BranchQuotaExceeded | クォータ超過 | ループ回数超過 | クォータを増加 |
| AmbiguousCoercion | 曖昧な変換 | 複数の型変換候補 | 明示的キャスト |

### リトライ仕様

該当なし（エラー時はコンパイル失敗）

## トランザクション仕様

該当なし

## パフォーマンス要件

- インクリメンタルコンパイルのサポート
- 依存関係トラッキングによる最小再解析

## セキュリティ考慮事項

- コンパイル時コード実行のサンドボックス化（ファイルI/O制限等）
- 無限ループ防止のためのブランチクォータ

## 備考

Sema.zigは1.6MB超のZig最大ソースファイルであり、言語機能の大部分がここで実装されている。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Sema.zig | `src/Sema.zig` | Sema構造体のフィールド定義（41-138行目） |
| 1-2 | Sema.zig | `src/Sema.zig` | Block構造体（337-528行目） |
| 1-3 | Sema.zig | `src/Sema.zig` | InstMap構造体（248-335行目） |

**読解のコツ**:
- `pt: Zcu.PerThread` - スレッドローカルなコンパイルコンテキスト
- `gpa: Allocator` - 永続的なメモリアロケータ
- `arena: Allocator` - Sema終了時にクリアされる一時アロケータ
- `code: Zir` - 解析対象のZIR
- `inst_map: InstMap` - ZIR→AIR命令マッピング

**主要処理フロー**:
1. **41-46行目**: 基本フィールド（pt, gpa, arena）
2. **47-48行目**: ZIRコードと生成AIR命令
3. **50-51行目**: ZIR→AIRマッピング
4. **52-61行目**: オーナー情報と関数コンテキスト

#### Step 2: Block構造体を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Sema.zig | `src/Sema.zig` | Block.makeSubBlock関数（507-528行目） |
| 2-2 | Sema.zig | `src/Sema.zig` | Block.isComptime関数（408-410行目） |

**読解のコツ**:
- `Block`はスタック上に確保される一時構造体
- `parent`フィールドでネストしたブロックを表現
- `comptime_reason`がnullでなければcomptime実行

**主要処理フロー**:
- **337-341行目**: Block構造体のドキュメントコメント
- **342行目**: `parent: ?*Block` - 親ブロックへの参照
- **344行目**: `sema: *Sema` - 共有Semaへの参照
- **365行目**: `runtime_index` - ランタイム条件のネスト深度

#### Step 3: 型・値システムとの連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Type.zig | `src/Type.zig` | Type構造体とメソッド群 |
| 3-2 | Value.zig | `src/Value.zig` | Value構造体とメソッド群 |
| 3-3 | InternPool.zig | `src/InternPool.zig` | 型・値のインターン化 |

**読解のコツ**:
- TypeとValueは共にInternPool.Indexをラップ
- InternPoolによりユニークなオブジェクトとして管理

#### Step 4: ZIR/AIR中間表現を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Zir.zig | `lib/std/zig/Zir.zig` | ZIR命令セット定義 |
| 4-2 | Air.zig | `src/Air.zig` | AIR命令セット定義 |

### プログラム呼び出し階層図

```
AstGen.zig (AST → ZIR)
    │
    ▼
Sema.zig (ZIR → AIR) ★本機能
    │
    ├─ Type.zig (型情報)
    ├─ Value.zig (値情報)
    ├─ InternPool.zig (インターン化)
    │
    └─ Block.analyze*() (各ZIR命令の解析)
           │
           ├─ resolveType() - 型解決
           ├─ coerce() - 型強制
           ├─ analyzeCall() - 関数呼び出し解析
           └─ emit*() - AIR命令生成
    │
    ▼
codegen.zig (AIR → ネイティブコード)
```

### データフロー図

```
[入力]                      [処理]                        [出力]

ZIR命令列  ─────────▶  Sema.analyzeBody()  ─────────▶  AIR命令列
   │                         │                            │
   │                         ▼                            │
   │                    Block処理                         │
   │                         │                            │
   │              ┌──────────┼──────────┐                 │
   │              ▼          ▼          ▼                 │
   │         型チェック  comptime評価  安全性挿入          │
   │              │          │          │                 │
   │              └──────────┼──────────┘                 │
   │                         │                            │
   └─── InternPool ◀────────┼──────────▶ InternPool ─────┘
        (型/値参照)                      (型/値登録)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Sema.zig | `src/Sema.zig` | ソース | 意味解析の主実装（1.6MB超） |
| Sema/arith.zig | `src/Sema/arith.zig` | ソース | 算術演算の解析 |
| Sema/LowerZon.zig | `src/Sema/LowerZon.zig` | ソース | ZONリテラルの解析 |
| Type.zig | `src/Type.zig` | ソース | 型情報管理 |
| Value.zig | `src/Value.zig` | ソース | 値情報管理 |
| InternPool.zig | `src/InternPool.zig` | ソース | 型・値のインターン化 |
| Air.zig | `src/Air.zig` | ソース | AIR命令定義 |
| Zir.zig | `lib/std/zig/Zir.zig` | ソース | ZIR命令定義 |
| Zcu.zig | `src/Zcu.zig` | ソース | コンパイルユニット管理 |
