# 機能設計書 47-ZIR

## 概要

本ドキュメントは、Zigコンパイラの中間表現ZIR（Zig Intermediate Representation）について記述する。ZIRはASTからAIRへの変換過程において、型なし命令のリストとして機能する中間表現である。

### 本機能の処理概要

ZIRは、AstGen.zigによってAST（抽象構文木）から生成される中間表現であり、Semaによって処理されてAIRに変換される。ZIRはソースファイル全体で1インスタンスを持ち、各関数やブロックの情報を含む。

**業務上の目的・背景**：ZIRはASTとAIRの間に位置し、ソースコードの構造を保持しながらも、より処理しやすい形式で表現する。これにより、コンパイルエラーの報告、増分コンパイル、メモリ効率の向上が実現される。ZIRは完成後、ASTやソースバイトへのアクセスなしにAIRを生成でき、キャッシュによる高速な再コンパイルを可能にする。

**機能の利用シーン**：
- ソースファイルの初回コンパイル時
- 増分コンパイルでのキャッシュ参照
- コンパイルエラー報告時のソース位置特定
- `dump-zir`デバッグコマンドでの中間表現確認

**主要な処理内容**：
1. 算術演算命令（add、sub、mul等）
2. 制御フロー命令（block、br等）
3. 宣言命令（param、func、struct_decl等）
4. 組み込み関数命令（@typeOf、@sizeOf等）
5. コンパイルエラー報告情報の保持

**関連システム・外部連携**：
- AstGen（入力）：AST→ZIR変換
- Sema（出力）：ZIR→AIR変換
- キャッシュシステム：ZIRの永続化

**権限による制御**：特になし（コンパイラ内部処理）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | フォーマット画面 | 補助機能 | フォーマット時のZig中間表現処理（--ast-checkオプション） |
| 29 | 変更リスト画面 | 補助機能 | Zig中間表現の処理 |
| 30 | ZIRダンプ画面 | 主機能 | キャッシュされたZIRを含むファイルのダンプ処理 |

## 機能種別

中間表現 / コンパイラ内部処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| instructions | MultiArrayList(Inst).Slice | Yes | ZIR命令リスト | 有効な命令列 |
| string_bytes | []u8 | Yes | 文字列データ | 有効なバイト列 |
| extra | []u32 | Yes | 追加データ | 有効なデータ |

### 入力データソース

- AstGenによるAST変換結果

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| air_instructions | MultiArrayList(Air.Inst) | 解析済みAIR命令 |
| compile_errors | ?CompileErrors | コンパイルエラー情報 |

### 出力先

Semaへの入力として使用

## 処理フロー

### 処理シーケンス

```
1. AstGenによる生成
   └─ ASTノードをZIR命令に変換
2. ヘッダー情報の設定
   └─ 命令数、文字列長、extra長を記録
3. キャッシュ保存（オプション）
   └─ ファイルシステムへの永続化
4. Semaによる処理
   └─ ZIR命令をAIR命令に変換
```

### フローチャート

```mermaid
flowchart TD
    A[ソースファイル] --> B[パース]
    B --> C[AST]
    C --> D[AstGen]
    D --> E[ZIR]
    E --> F{キャッシュ?}
    F -->|Yes| G[ファイル保存]
    F -->|No| H[Sema]
    G --> H
    H --> I[AIR]
    E --> J{エラー?}
    J -->|Yes| K[コンパイルエラー報告]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-47-01 | ファイル単位 | ZIRはソースファイルごとに1インスタンス | ZIR生成時 |
| BR-47-02 | イミュータブル | ZIRデータは生成後不変 | ZIR参照時 |
| BR-47-03 | インデックスゼロ予約 | string_bytesのインデックス0は予約 | 文字列参照時 |
| BR-47-04 | ヘッダー形式 | ファイル保存時は先頭にHeaderを配置 | キャッシュ時 |

### 計算ロジック

ZIRのextraData関数は、型パラメータに基づいてextra配列からデータを抽出する。

## データベース操作仕様

該当なし（メモリ/ファイルベースの処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CompileError | コンパイルエラー | 構文/意味エラー | ソースコード修正 |
| LoweringFailed | 変換エラー | ZIR生成失敗 | エラー詳細確認 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- キャッシュによる高速な再コンパイル
- メモリ効率の良いインデックスベース参照

## セキュリティ考慮事項

特になし（コンパイラ内部処理）

## 備考

ZIRはlib/std/zig/Zir.zigに定義されており、標準ライブラリの一部として配布される。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ZIR構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Zir.zig | `lib/std/zig/Zir.zig` | ファイル先頭コメント（1-13行目） |
| 1-2 | Zir.zig | `lib/std/zig/Zir.zig` | Zir構造体定義（26-36行目） |

**読解のコツ**:
- `instructions: MultiArrayList(Inst).Slice` - 命令リスト
- `string_bytes: []u8` - 文字列データ（null終端含む）
- `extra: []u32` - 追加データ

**主要処理フロー**:
1. **1-13行目**: ZIRの役割説明
2. **26行目**: instructionsフィールド
3. **32行目**: string_bytesフィールド
4. **36行目**: extraフィールド

#### Step 2: ヘッダー形式を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Zir.zig | `lib/std/zig/Zir.zig` | Header構造体（39-51行目） |

**読解のコツ**:
- キャッシュファイルの先頭に配置
- 命令数、文字列長、extra長を保持
- stat情報でファイル変更検出

**主要処理フロー**:
- **40行目**: instructions_len - 命令数
- **41行目**: string_bytes_len - 文字列長
- **42行目**: extra_len - 追加データ長
- **48-50行目**: stat情報 - ファイル変更検出用

#### Step 3: 命令タグを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Zir.zig | `lib/std/zig/Zir.zig` | Inst.Tag列挙型（167行目以降） |

**読解のコツ**:
- 算術: add, sub, mul等
- パラメータ: param, param_comptime, param_anytype
- 配列: array_cat, array_mul, array_type

**主要処理フロー**:
- **169行目**: add - 加算
- **241-249行目**: param系 - 関数パラメータ

#### Step 4: データ抽出を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Zir.zig | `lib/std/zig/Zir.zig` | extraData関数（70-112行目） |
| 4-2 | Zir.zig | `lib/std/zig/Zir.zig` | nullTerminatedString関数（120-123行目） |

**読解のコツ**:
- extraDataは型パラメータでデータ形式を指定
- インラインforでフィールドを順次抽出

### プログラム呼び出し階層図

```
ソースファイル (.zig)
    │
    ▼
パーサー (lib/std/zig/Ast.zig)
    │
    ▼
AST (抽象構文木)
    │
    ▼
AstGen (lib/std/zig/AstGen.zig)
    │
    ▼
ZIR ★本機能
    │
    ├─ キャッシュ保存 (オプション)
    │
    └─ Sema (src/Sema.zig)
           │
           ▼
         AIR
```

### データフロー図

```
[入力]                      [処理]                        [出力]

AST  ─────────────▶  AstGen  ─────────────▶  ZIR
                         │                      │
                         ▼                      ▼
                   各ASTノード処理         instructions[]
                   文字列収集              string_bytes[]
                   extra生成               extra[]
                         │                      │
                         └──────────────────────┘
                                    │
                                    ▼
                              Sema消費 → AIR
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Zir.zig | `lib/std/zig/Zir.zig` | ソース | ZIR命令定義 |
| AstGen.zig | `lib/std/zig/AstGen.zig` | ソース | AST→ZIR変換 |
| Ast.zig | `lib/std/zig/Ast.zig` | ソース | AST定義 |
| Sema.zig | `src/Sema.zig` | ソース | ZIR→AIR変換 |
| print_zir.zig | `src/print_zir.zig` | ソース | ZIRテキスト出力 |
