# 機能設計書 5-test-obj

## 概要

本ドキュメントは、Zigコンパイラの`test-obj`コマンドの機能設計について記述する。このコマンドはユニットテスト用のオブジェクトファイルを生成する機能であり、テストを実行せずにオブジェクトファイルとして出力する。

### 本機能の処理概要

`zig test-obj`コマンドは、`zig test`と同様にZigソースコード内の`test`ブロックを収集するが、実行可能ファイルではなくオブジェクトファイルを生成する。これにより、外部ビルドシステムやカスタムテストランナーとの統合が容易になる。

**業務上の目的・背景**：テストコードを実行可能ファイルではなくオブジェクトファイルとして出力することで、外部のリンカやビルドシステムと統合しやすくなる。特に、複数のテストモジュールを単一のテスト実行ファイルに統合したい場合や、C/C++プロジェクトのテストスイートにZigのテストを組み込みたい場合に有用である。

**機能の利用シーン**：
- 外部ビルドシステムでテストをリンクする場合
- 複数のテストオブジェクトを統合する場合
- カスタムテストランナーと組み合わせる場合
- C/C++プロジェクトにZigテストを統合する場合

**主要な処理内容**：
1. コマンドライン引数の解析
2. ソースファイルからtestブロックを収集
3. テストコードをオブジェクトファイルとしてコンパイル
4. オブジェクトファイルの出力

**関連システム・外部連携**：
- 外部ビルドシステム（CMake、Make等）
- カスタムテストランナー

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | テストオブジェクト画面 | 主機能 | テスト用オブジェクトファイルを生成する処理 |

## 機能種別

コンパイル処理 / テストコード生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| files | []const u8 | Yes | テスト対象のソースファイル | 有効なファイルパス |
| -target | []const u8 | No | ターゲットアーキテクチャ | サポートされているターゲット |
| -O | OptimizeMode | No | 最適化モード | 有効な最適化モード |
| --name | []const u8 | No | 出力ファイル名 | 有効なファイル名 |
| -ofmt | ObjectFormat | No | 出力オブジェクト形式 | elf/coff/macho/wasm等 |

### 入力データソース

- コマンドライン引数
- Zigソースファイル（.zig）内のtestブロック

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| オブジェクトファイル | バイナリ | テストコードを含む .o/.obj ファイル |

### 出力先

- ファイルシステム（現在のディレクトリまたは指定されたパス）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ buildOutputType関数でArgMode = .zig_test_obj として処理
2. ソースファイル解析
   └─ testブロックの収集
3. オブジェクト生成
   └─ output_mode = .Obj でコンパイル（is_test = true）
4. ファイル出力
   └─ オブジェクトファイルをファイルシステムに書き出し
```

### フローチャート

```mermaid
flowchart TD
    A[zig test-obj 開始] --> B[コマンドライン引数解析]
    B --> C[ソースファイル解析]
    C --> D[testブロック収集]
    D --> E[Compilation作成]
    E --> F[output_mode = .Obj, is_test = true]
    F --> G[コード生成]
    G --> H[オブジェクトファイル出力]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | テストブロック収集 | ファイル内のすべてのtestブロックを収集 | 常時 |
| BR-02 | オブジェクト出力のみ | リンクや実行は行わない | 常時 |
| BR-03 | is_testフラグ | テストモードではis_test = trueが設定される | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CompileError | テストコードにエラー | コード修正 |
| - | FileNotFound | ソースファイルが存在しない | パス確認 |

### リトライ仕様

自動リトライなし

## トランザクション仕様

該当なし

## パフォーマンス要件

- インクリメンタルコンパイル対応
- 並列コンパイル対応

## セキュリティ考慮事項

- 入力ファイルのパス検証

## 備考

- 生成されたオブジェクトファイルは外部リンカでリンクして実行可能にする必要がある
- `zig test`との違いは出力がオブジェクトファイルであり、実行されない点

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | test-objコマンドの分岐処理 |

**主要処理フロー**:
1. **273-275行目**: `mem.eql(u8, cmd, "test-obj")`で判定
2. **ArgMode = .zig_test_obj** でテストオブジェクトモードを設定
3. **1032-1034行目**: `output_mode = .Obj`の設定

#### Step 2: テストモードとオブジェクト出力の設定

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | is_testとoutput_modeの組み合わせ |

### プログラム呼び出し階層図

```
main (src/main.zig)
    │
    └─ buildOutputType (ArgMode = .zig_test_obj)
            │
            ├─ create_module.opts.is_test = true
            │
            ├─ create_module.opts.output_mode = .Obj
            │
            └─ Compilation.create
                   └─ codegen (オブジェクト生成のみ)
```

### データフロー図

```
[入力]                    [処理]                    [出力]

.zig ソース ───▶ testブロック収集 ───▶ コンパイル ───▶ .o/.obj ファイル
      │                                    │
      └── test "name" { ... } ─────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンド分岐 |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理 |
