# 機能設計書 6-run

## 概要

本ドキュメントは、Zigコンパイラの`run`コマンドの機能設計について記述する。このコマンドは実行可能ファイルを生成し、即座に実行する機能であり、ビルドと実行を一括で行う。

### 本機能の処理概要

`zig run`コマンドは、Zigソースコードから実行可能ファイルを生成し、続けてその実行ファイルを起動する。内部的には`build-exe`と同様のコンパイル処理を行った後、生成されたバイナリを子プロセスとして実行する。開発中のプログラムを素早く実行・テストするのに便利な機能である。

**業務上の目的・背景**：開発中のプログラムを素早く実行して動作確認したい場合、毎回「コンパイル」→「実行」の2ステップを行うのは煩雑である。`zig run`は、この2つのステップを1コマンドで行えるようにし、開発サイクルを高速化する。スクリプト言語のような手軽さでZigコードを実行できる。

**機能の利用シーン**：
- 開発中のプログラムの動作確認
- 小規模なスクリプト的プログラムの実行
- コードスニペットの動作テスト
- プロトタイピング

**主要な処理内容**：
1. コマンドライン引数の解析
2. 実行可能ファイルの生成（build-exeと同様）
3. 生成されたバイナリの実行
4. 実行結果の出力

**関連システム・外部連携**：
- LLVM：コード生成（オプション）
- リンカ：実行可能ファイル生成

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | 即時実行画面 | 主機能 | 実行可能ファイルを生成し即座に実行する処理 |

## 機能種別

コンパイル処理 / プログラム実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| files | []const u8 | Yes | ソースファイルのパス | 有効なファイルパス |
| -target | []const u8 | No | ターゲットアーキテクチャ | サポートされているターゲット |
| -O | OptimizeMode | No | 最適化モード | 有効な最適化モード |
| -- | separator | No | 以降の引数はプログラムに渡される | - |
| [args...] | []const u8 | No | 実行時引数 | - |

### 入力データソース

- コマンドライン引数
- Zigソースファイル（.zig）
- Cソースファイル（.c, .cpp等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| プログラム出力 | テキスト | 実行されたプログラムの標準出力/標準エラー |
| 終了コード | 整数 | 実行されたプログラムの終了コード |

### 出力先

- 標準出力（プログラムの出力）
- 標準エラー出力（エラーメッセージ）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ buildOutputType関数でArgMode = .run として処理
2. 実行時引数の分離
   └─ "--" 以降をruntime_args_startとして記録
3. 実行可能ファイル生成
   └─ output_mode = .Exe でコンパイル
4. プログラム実行
   └─ 生成されたバイナリを子プロセスとして実行
5. 結果出力
   └─ プログラムの出力を転送、終了コードを伝播
```

### フローチャート

```mermaid
flowchart TD
    A[zig run 開始] --> B[コマンドライン引数解析]
    B --> C{-- 区切りあり?}
    C -->|Yes| D[runtime_argsを分離]
    C -->|No| E[runtime_args = 空]
    D --> F[Compilation作成]
    E --> F
    F --> G[実行可能ファイル生成]
    G --> H{コンパイル成功?}
    H -->|Yes| I[バイナリを実行]
    H -->|No| J[エラー出力]
    I --> K[プログラム出力を転送]
    K --> L[終了コードを伝播]
    J --> M[終了]
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 引数分離 | "--" 以降の引数は実行時引数として扱う | -- 指定時 |
| BR-02 | 終了コード伝播 | 実行されたプログラムの終了コードをそのまま返す | 常時 |
| BR-03 | 一時ファイル | コンパイル結果は一時ディレクトリに生成 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CompileError | コンパイルエラー | コード修正 |
| - | RuntimeError | 実行時エラー | プログラムを調査 |
| - | FileNotFound | ソースファイルが存在しない | パス確認 |

### リトライ仕様

自動リトライなし

## トランザクション仕様

該当なし

## パフォーマンス要件

- インクリメンタルコンパイル対応
- キャッシュによる再コンパイル回避

## セキュリティ考慮事項

- 実行されるプログラムの権限はZigコンパイラと同じ

## 備考

- `zig run main.zig -- arg1 arg2` で引数をプログラムに渡せる
- 内部的にはbuild-exeを呼び出した後、子プロセスとして実行

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | runコマンドの分岐処理 |

**主要処理フロー**:
1. **276-278行目**: `mem.eql(u8, cmd, "run")`で判定
2. **ArgMode = .run** で実行モードを設定
3. **1055-1061行目**: "--" の処理とruntime_args_startの設定

#### Step 2: 実行時引数の処理

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | runtime_args_startの利用 |

### プログラム呼び出し階層図

```
main (src/main.zig)
    │
    └─ buildOutputType (ArgMode = .run)
            │
            ├─ "--" 以降をruntime_argsとして分離
            │
            ├─ Compilation.create (output_mode = .Exe)
            │
            ├─ Compilation.update (実行ファイル生成)
            │
            └─ 生成バイナリを実行
                   └─ runtime_argsを引数として渡す
```

### データフロー図

```
[入力]                    [処理]                         [出力]

.zig ソース ───▶ コンパイル ───▶ 実行ファイル ───▶ 実行 ───▶ プログラム出力
      │                                           │
runtime_args ────────────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンド分岐、実行処理 |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理 |
