# 機能設計書 62-libcサポート

## 概要

本ドキュメントは、Zigコンパイラにおける各種libc実装（glibc、musl、mingw等）のサポート機能の設計を記述する。この機能により、ZigはC言語との相互運用性を実現し、多様なプラットフォームでのクロスコンパイルを可能にする。

### 本機能の処理概要

libcサポート機能は、Zigコンパイラがターゲットプラットフォームに適したC標準ライブラリを自動的に選択・ビルドする機能を提供する。glibc、musl、mingw、FreeBSD libc、NetBSD libc、OpenBSD libcなど複数のlibc実装をサポートし、それぞれのターゲットに応じたスタートアップコード（crt0、crt1等）やランタイムライブラリをビルドする。

**業務上の目的・背景**：C言語で書かれた既存のライブラリやシステムコールを利用するためには、適切なlibc実装との連携が必要である。Zigはこれらのlibcサポートを内蔵することで、外部ツールチェーンへの依存を最小化し、どのホスト環境からでも任意のターゲット向けにクロスコンパイルできる環境を提供する。

**機能の利用シーン**：
- C言語との相互運用（extern "c"関数の呼び出し）
- システムコールの利用
- C言語で書かれた既存ライブラリのリンク
- クロスコンパイル時のターゲットlibc提供
- 実行可能ファイルのビルド時のスタートアップコード生成

**主要な処理内容**：
1. ターゲットアーキテクチャとOSに基づくlibc実装の選択
2. CRTファイル（crt1.o、Scrt1.o、libc_nonshared.a等）のビルド
3. 共有ライブラリスタブの生成（glibc）
4. abilistデータからのシンボルバージョニング処理
5. アーキテクチャ固有のアセンブリコードのコンパイル

**関連システム・外部連携**：
- LLVMバックエンド（コンパイル時）
- リンカ（ELF、Mach-O、COFF等）
- Zigビルドシステム

**権限による制御**：特になし。ビルド設定に基づいて自動的に処理される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 14 | Cコンパイラ画面 | 補助機能 | 各種libc実装（glibc、musl、mingw等）のサポート |

## 機能種別

コード生成 / ビルド処理 / ライブラリ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| target | Target | Yes | ターゲットアーキテクチャ・OS・ABI情報 | 有効なターゲットトリプル |
| crt_file | CrtFile | Yes | ビルド対象のCRTファイル種別 | crt1_o, scrt1_o, libc_nonshared_a等 |
| prog_node | Progress.Node | Yes | 進捗表示ノード | 有効なノード |

### 入力データソース

- Zigライブラリディレクトリ内のlibcソースコード
- abilistファイル（glibcシンボルバージョニング情報）
- ターゲット設定情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| crt_files | CrtFile | スタートアップオブジェクトファイル |
| libc_a | Library | 静的ライブラリ（musl） |
| libc_so | SharedObject | 共有ライブラリスタブ（glibc） |

### 出力先

- グローバルキャッシュディレクトリ
- ビルド成果物ディレクトリ

## 処理フロー

### 処理シーケンス

```
1. ターゲット判定
   └─ OS/アーキテクチャ/ABIからlibc種別を決定

2. CRTファイルビルド（glibc）
   ├─ start.S（アセンブリ）のコンパイル
   ├─ abi-note.Sのコンパイル
   └─ init.cのコンパイル

3. libc_nonshared.aビルド（glibc）
   ├─ atexit.c、at_quick_exit.c等のコンパイル
   └─ バージョン依存ファイルの条件付きコンパイル

4. 共有ライブラリスタブ生成（glibc）
   ├─ abilistからシンボル情報を読み込み
   ├─ アセンブリスタブを生成
   └─ 共有ライブラリとしてリンク
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{ターゲットOS/ABI}
    B -->|Linux/glibc| C[glibc処理]
    B -->|Linux/musl| D[musl処理]
    B -->|Windows/mingw| E[mingw処理]
    B -->|FreeBSD| F[FreeBSD処理]

    C --> C1[buildCrtFile]
    C1 --> C2[scrt1_o生成]
    C1 --> C3[libc_nonshared_a生成]
    C --> C4[buildSharedObjects]
    C4 --> C5[abilist読み込み]
    C5 --> C6[スタブASM生成]
    C6 --> C7[共有ライブラリ生成]

    D --> D1[crt1_o/scrt1_o生成]
    D --> D2[libc.a生成]
    D --> D3[libc.so生成]

    C7 --> Z[終了]
    D3 --> Z
    E --> Z
    F --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-62-01 | バージョン互換性 | glibcの削除されたライブラリ（pthread、dl等）はバージョン2.34未満でのみビルド | ターゲットglibcバージョンによる |
| BR-62-02 | PIE対応 | 位置独立実行可能ファイル用にScrt1.oを使用 | output_mode == Exe かつ pie == true |
| BR-62-03 | アーキテクチャ固有オーバーライド | arch/配下のファイルが存在する場合は汎用実装を置き換え | muslビルド時 |
| BR-62-04 | time32互換 | 32ビットアーキテクチャでtime32互換ファイルを追加 | arm、i386、m68k等 |

### 計算ロジック

**glibcシンボルバージョン選択**：
- ターゲットglibcバージョン以下の全バージョンでシンボルを定義
- 最も新しいバージョンをデフォルト（@@）とし、他は@でエイリアス

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（ファイルシステムベースの処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ZigInstallationCorrupt | インストール破損 | abilistファイルの形式不正 | Zigの再インストール |
| OutOfMemory | メモリ不足 | 大量のソースファイルビルド時 | メモリ増設またはビルド分割 |
| InvalidTargetGLibCVersion | 無効バージョン | 未サポートのglibcバージョン指定 | サポート対象バージョンの使用 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- abilistメタデータの読み込み: 800KB以下のファイル
- キャッシュによる再ビルド回避
- 並列コンパイルのサポート

## セキュリティ考慮事項

- スタックプロテクタの適切な初期化
- 位置独立コード（PIC）のサポート
- シンボルバージョニングによるABI互換性維持

## 備考

- glibcサポートにはLLVM拡張が必要（build_options.have_llvm）
- アーキテクチャ固有の処理が多いため、新アーキテクチャ追加時は注意が必要
- キャッシュはグローバルキャッシュディレクトリに保存される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

libc管理の中核となるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | glibc.zig | `src/libs/glibc.zig` | Lib、ABI、CrtFile構造体の定義 |
| 1-2 | musl.zig | `src/libs/musl.zig` | CrtFile列挙型、ソースファイルリスト |

**読解のコツ**:
- `Lib`構造体はglibcの各ライブラリ（libc、libm、libpthread等）の情報を保持
- `ABI`構造体はabilistファイルから読み込んだシンボル情報を保持
- `CrtFile`列挙型はビルド可能なCRTファイルの種類を定義

**主要処理フロー**:
- **glibc.zig 18-22行目**: Lib構造体定義
- **glibc.zig 24-35行目**: ABI構造体定義
- **glibc.zig 38-47行目**: サポートするライブラリ一覧

#### Step 2: ビルド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | glibc.zig | `src/libs/glibc.zig` | buildCrtFile関数 |
| 2-2 | glibc.zig | `src/libs/glibc.zig` | buildSharedObjects関数 |
| 2-3 | musl.zig | `src/libs/musl.zig` | buildCrtFile関数 |

**主要処理フロー**:
- **glibc.zig 166-356行目**: buildCrtFile - CRTファイルのビルド処理
- **glibc.zig 660-1137行目**: buildSharedObjects - 共有ライブラリスタブの生成
- **musl.zig 21-292行目**: buildCrtFile - muslのCRTファイルビルド

#### Step 3: abilist処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | glibc.zig | `src/libs/glibc.zig` | loadMetaData関数 |

**主要処理フロー**:
- **glibc.zig 60-157行目**: loadMetaData - abilistファイルのパース処理

### プログラム呼び出し階層図

```
Compilation
    │
    ├─ glibc.buildCrtFile
    │      ├─ scrt1_o → start.S, abi-note.S, init.c
    │      └─ libc_nonshared_a → atexit.c, pthread_atfork.c等
    │
    ├─ glibc.buildSharedObjects
    │      ├─ loadMetaData (abilist読み込み)
    │      └─ buildSharedLib (各lib*.soの生成)
    │
    ├─ musl.buildCrtFile
    │      ├─ crt1_o / scrt1_o / rcrt1_o
    │      ├─ libc_a (静的ライブラリ)
    │      └─ libc_so (共有ライブラリ)
    │
    └─ mingw.buildCrtFile
           └─ Windows固有のCRT処理
```

### データフロー図

```
[入力]                        [処理]                           [出力]

lib/libc/glibc/ ─────────▶ glibc.buildCrtFile ──────────▶ Scrt1.o
ソースファイル                      │                      libc_nonshared.a
                                    │
libc/glibc/abilists ────▶ loadMetaData ─────────────────▶ ABI構造体
                                    │
                                    ▼
                        buildSharedObjects
                                    │
                                    ▼
                        アセンブリスタブ生成
                                    │
                                    ▼
                        ┌────────────────────────┐
                        │ libm.so.6              │
                        │ libc.so.6              │
                        │ libpthread.so.0        │
                        │ ...                    │
                        └────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| glibc.zig | `src/libs/glibc.zig` | ソース | glibcサポートの実装 |
| musl.zig | `src/libs/musl.zig` | ソース | muslサポートの実装 |
| mingw.zig | `src/libs/mingw.zig` | ソース | mingwサポートの実装 |
| freebsd.zig | `src/libs/freebsd.zig` | ソース | FreeBSD libcサポート |
| netbsd.zig | `src/libs/netbsd.zig` | ソース | NetBSD libcサポート |
| openbsd.zig | `src/libs/openbsd.zig` | ソース | OpenBSD libcサポート |
| wasi_libc.zig | `src/libs/wasi_libc.zig` | ソース | WASI libcサポート |
| abilists | `lib/libc/glibc/abilists` | データ | glibcシンボルバージョン情報 |
