# 機能設計書 63-libcxx

## 概要

本ドキュメントは、ZigコンパイラにおけるC++標準ライブラリ（libc++およびlibc++abi）の統合機能の設計を記述する。この機能により、ZigはC++コードとの相互運用性を実現する。

### 本機能の処理概要

libcxx機能は、LLVM libc++およびlibc++abiをZigコンパイラ内でビルドし、C++コードのコンパイルとリンクに必要なランタイムサポートを提供する。これにより、Zigプロジェクト内でC++ソースコードをコンパイルしたり、C++で書かれた外部ライブラリとリンクしたりすることが可能になる。

**業務上の目的・背景**：多くの既存のライブラリやフレームワークはC++で書かれている。これらとの相互運用を可能にするため、ZigはC++標準ライブラリのサポートを内蔵している。外部のC++ツールチェーンに依存せず、Zigだけで完結したクロスコンパイル環境を提供することで、開発者の環境構築負担を軽減する。

**機能の利用シーン**：
- C++ソースファイル（.cpp）のコンパイル
- C++で書かれた既存ライブラリとのリンク
- C++例外処理を使用するコードのサポート
- RTTIを使用するコードのサポート

**主要な処理内容**：
1. libc++（C++標準ライブラリ本体）の静的ライブラリビルド
2. libc++abi（C++ ABI実装）の静的ライブラリビルド
3. プラットフォーム固有のコンパイルフラグ設定
4. スレッドサポートの条件付きビルド

**関連システム・外部連携**：
- LLVMバックエンド
- libunwind（例外処理）
- libc（C標準ライブラリ）

**権限による制御**：特になし。ビルド設定に基づいて自動的に処理される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 15 | C++コンパイラ画面 | 補助機能 | C++標準ライブラリとの統合処理 |

## 機能種別

ライブラリビルド / コンパイル処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| comp | *Compilation | Yes | コンパイル設定情報 | 有効なコンパイル設定 |
| prog_node | Progress.Node | Yes | 進捗表示ノード | 有効なノード |

### 入力データソース

- `lib/libcxx/` - libc++ソースファイル
- `lib/libcxxabi/` - libc++abiソースファイル
- ターゲット設定情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| libcxx_static_lib | CrtFile | libc++静的ライブラリ |
| libcxxabi_static_lib | CrtFile | libc++abi静的ライブラリ |

### 出力先

- グローバルキャッシュディレクトリ

## 処理フロー

### 処理シーケンス

```
1. libc++ビルド (buildLibCxx)
   ├─ ベースファイルのコンパイル（algorithm.cpp, any.cpp等）
   ├─ スレッドサポートファイルの条件付きコンパイル
   ├─ プラットフォーム固有ファイルの条件付きコンパイル
   └─ 静的ライブラリの生成

2. libc++abiビルド (buildLibCxxAbi)
   ├─ 例外処理関連ファイルのコンパイル
   ├─ RTTIサポートファイルのコンパイル
   └─ 静的ライブラリの生成
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{LLVM利用可能?}
    B -->|No| C[エラー返却]
    B -->|Yes| D[設定解決]
    D --> E[ソースファイル収集]
    E --> F{WASI?}
    F -->|Yes| G[filesystemファイル除外]
    F -->|No| H[全ファイル含む]
    G --> I{Windows?}
    H --> I
    I -->|Yes| J[win32サポートファイル追加]
    I -->|No| K[win32ファイル除外]
    J --> L{マルチスレッド?}
    K --> L
    L -->|Yes| M[スレッドファイル追加]
    L -->|No| N[スレッドファイル除外]
    M --> O[サブコンパイル実行]
    N --> O
    O --> P[静的ライブラリ生成]
    P --> Q[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-63-01 | WASI制限 | WASIターゲットではfilesystem関連ファイルを除外 | target.os.tag == .wasi |
| BR-63-02 | Windows固有 | Windowsターゲットでのみwin32サポートファイルを含む | target.os.tag == .windows |
| BR-63-03 | スレッドサポート | シングルスレッドモードではスレッド関連ファイルを除外 | !comp.config.any_non_single_threaded |
| BR-63-04 | 例外処理 | WASIターゲットでは例外処理を無効化 | target.os.tag == .wasi |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ZigCompilerNotBuiltWithLLVMExtensions | 未サポート | LLVMなしでビルドされたZig | LLVM有効のZigを使用 |
| OutOfMemory | メモリ不足 | ビルド中のメモリ不足 | メモリ増設 |
| AlreadyReported | エラー報告済み | サブコンパイル失敗 | 詳細エラーを確認 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- キャッシュによる再ビルド回避
- 並列コンパイルのサポート
- LTOサポート

## セキュリティ考慮事項

- 関数セクション分離による不要コード除去
- データセクション分離
- シンボル可視性制御（hidden）

## 備考

- C++23標準をターゲットとしたコンパイル
- libc++とlibc++abiの両方が必要
- int128_builtins.cppはcompiler_rtとの競合を避けるため除外

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | libcxx.zig | `src/libs/libcxx.zig` | ソースファイルリストの定義 |

**読解のコツ**:
- `libcxxabi_files`はlibc++abiのソースファイルリスト
- `libcxx_base_files`は基本のlibc++ソースファイル
- `libcxx_thread_files`はスレッドサポート用ファイル

**主要処理フロー**:
- **11-36行目**: libcxxabi_filesリスト
- **38-90行目**: libcxx_base_filesリスト
- **92-103行目**: libcxx_thread_filesリスト

#### Step 2: ビルド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | libcxx.zig | `src/libs/libcxx.zig` | buildLibCxx関数 |
| 2-2 | libcxx.zig | `src/libs/libcxx.zig` | buildLibCxxAbi関数 |

**主要処理フロー**:
- **111-302行目**: buildLibCxx - libc++のビルド処理
- **304-500行目**: buildLibCxxAbi - libc++abiのビルド処理

#### Step 3: コンパイルフラグを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | libcxx.zig | `src/libs/libcxx.zig` | cflags設定部分 |

**主要処理フロー**:
- **205-229行目**: libc++のコンパイルフラグ
- **400-427行目**: libc++abiのコンパイルフラグ

### プログラム呼び出し階層図

```
Compilation
    │
    ├─ buildLibCxx
    │      ├─ Config.resolve (設定解決)
    │      ├─ Module.create (モジュール作成)
    │      ├─ ソースファイル収集
    │      │      ├─ libcxx_base_files
    │      │      └─ libcxx_thread_files (条件付き)
    │      ├─ Compilation.create (サブコンパイル)
    │      └─ updateSubCompilation
    │
    └─ buildLibCxxAbi
           ├─ Config.resolve
           ├─ Module.create
           ├─ ソースファイル収集
           │      └─ libcxxabi_files
           ├─ Compilation.create
           └─ updateSubCompilation
```

### データフロー図

```
[入力]                        [処理]                           [出力]

lib/libcxx/src/*.cpp ────▶ buildLibCxx ────────────────▶ libc++.a
                                │
                                ├── cflags設定
                                ├── プラットフォーム判定
                                └── サブコンパイル

lib/libcxxabi/src/*.cpp ──▶ buildLibCxxAbi ────────────▶ libc++abi.a
                                │
                                ├── cflags設定
                                ├── 例外処理設定
                                └── サブコンパイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| libcxx.zig | `src/libs/libcxx.zig` | ソース | libc++/libc++abiビルドの実装 |
| libunwind.zig | `src/libs/libunwind.zig` | ソース | スタック巻き戻しライブラリ（例外処理で使用） |
| src/*.cpp | `lib/libcxx/src/` | ソース | libc++のC++ソースファイル |
| src/*.cpp | `lib/libcxxabi/src/` | ソース | libc++abiのC++ソースファイル |
| include/ | `lib/libcxx/include/` | ヘッダ | libc++のヘッダファイル |
| include/ | `lib/libcxxabi/include/` | ヘッダ | libc++abiのヘッダファイル |
