# 機能設計書 65-docgen

## 概要

本ドキュメントは、Zigのドキュメント生成ツール（docgen）の設計を記述する。このツールは、Zigの公式ドキュメントをテンプレートファイルから生成するために使用される。

### 本機能の処理概要

docgenは、特殊なテンプレート記法を含むドキュメントファイルを入力として受け取り、HTMLドキュメントを生成するツールである。テンプレート内のタグ（`{#...#}`形式）を解析し、ヘッダー階層、コード例、リンクなどを適切なHTML構造に変換する。

**業務上の目的・背景**：Zigの公式ドキュメント（特に言語リファレンス）は、コード例と説明が密接に関連している。docgenを使用することで、ドキュメントの構造化、自動的な目次生成、コード例の実行可能性の維持を実現し、一貫性のある高品質なドキュメントを効率的に作成・維持できる。

**機能の利用シーン**：
- Zigの公式ドキュメント生成時
- 言語リファレンスのHTML出力
- チュートリアルやガイドの作成

**主要な処理内容**：
1. テンプレートファイルのトークン化（Tokenizer）
2. 目次（Table of Contents）の生成
3. ヘッダー階層の管理と相互参照
4. コード例の処理と表示
5. HTML出力の生成

**関連システム・外部連携**：
- ファイルシステム（入力ファイル、コード例ディレクトリ）
- ブラウザ（出力HTMLの表示）

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | コマンドラインツール（画面なし） |

## 機能種別

ドキュメント生成 / テンプレート処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input | []const u8 | Yes | 入力テンプレートファイルパス | 有効なファイルパス |
| output | []const u8 | Yes | 出力HTMLファイルパス | 有効なファイルパス |
| --code-dir | []const u8 | Yes | コード例の出力ディレクトリ | 有効なディレクトリパス |

### 入力データソース

- テンプレートファイル（docgenタグを含むテキストファイル）
- コード例の出力ディレクトリ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| html_document | []u8 | 生成されたHTMLドキュメント |

### 出力先

- 指定された出力ファイルパス

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ input, output, --code-dirの取得

2. 入力ファイル読み込み
   └─ テンプレートファイルの読み込み（最大10MB）

3. トークン化
   └─ Tokenizerによるタグ・コンテンツの分離

4. 目次生成 (genToc)
   └─ ヘッダー階層のパースとTOC構造の構築

5. HTML生成 (genHtml)
   └─ 各ノードのHTML変換と出力

6. ファイル出力
   └─ 生成されたHTMLの書き込み
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C{必須引数あり?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[入力ファイル読み込み]
    E --> F[Tokenizer初期化]
    F --> G[genToc: 目次生成]
    G --> H{パースエラー?}
    H -->|Yes| I[エラー表示]
    I --> D
    H -->|No| J[genHtml: HTML生成]
    J --> K[出力ファイル書き込み]
    K --> L[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-65-01 | ファイルサイズ制限 | 入力ファイルは最大10MBまで | 常時 |
| BR-65-02 | ヘッダーバランス | header_openとheader_closeは対応が必要 | ヘッダータグ使用時 |
| BR-65-03 | 重複URL禁止 | 同じURLを持つヘッダーは禁止 | ヘッダータグ使用時 |
| BR-65-04 | URL正規化 | ヘッダー名からURLが自動生成される | ヘッダータグ使用時 |

### 計算ロジック

**URL生成（urlize）**：
- ヘッダー名の特殊文字を変換してURL互換の形式に変換

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ParseError | パースエラー | テンプレート構文エラー | テンプレートの修正 |
| FileNotFound | ファイルなし | 入力ファイルが存在しない | パスの確認 |
| - | 引数エラー | 必須引数の欠如 | 正しい引数の指定 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- ファイルサイズ上限: 10MB
- バッファリングによる効率的なI/O

## セキュリティ考慮事項

- 入力ファイルサイズの制限
- パス操作の安全性

## 備考

- テンプレートタグは `{#tag_name|param#}` 形式
- 対応タグ: header_open, header_close, nav, code, link, see_also, builtin, syntax等

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | docgen.zig | `tools/docgen.zig` | Token, Node, Toc構造体の定義 |

**読解のコツ**:
- `Token`はテンプレートの各要素を表す（content, bracket_open, tag_content等）
- `Node`はパース結果の各要素を表す（Content, HeaderOpen, Code等）
- `Toc`は目次情報を保持

**主要処理フロー**:
- **89-103行目**: Token構造体定義
- **316-327行目**: Node共用体定義
- **329-333行目**: Toc構造体定義

#### Step 2: トークナイザーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | docgen.zig | `tools/docgen.zig` | Tokenizer構造体 |

**主要処理フロー**:
- **105-243行目**: Tokenizer構造体とnext関数

#### Step 3: 目次生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | docgen.zig | `tools/docgen.zig` | genToc関数 |

**主要処理フロー**:
- **340-500行目以降**: genToc関数 - 目次の生成処理

#### Step 4: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | docgen.zig | `tools/docgen.zig` | main関数 |

**主要処理フロー**:
- **31-87行目**: main関数 - 引数解析とメイン処理フロー

### プログラム呼び出し階層図

```
main
    │
    ├─ 引数解析
    │
    ├─ 入力ファイル読み込み
    │
    ├─ Tokenizer.init
    │      └─ next (繰り返し)
    │
    ├─ genToc
    │      ├─ eatToken
    │      ├─ assertToken
    │      ├─ urlize
    │      └─ parseError (エラー時)
    │
    └─ genHtml
           ├─ Node処理
           └─ 出力書き込み
```

### データフロー図

```
[入力]                        [処理]                           [出力]

テンプレートファイル ────▶ Tokenizer ─────────────▶ Token列
                                │
                                ▼
                           genToc
                                │
                                ▼
                           ┌─────────────┐
                           │ Toc構造体   │
                           │ - nodes     │
                           │ - toc       │
                           │ - urls      │
                           └─────────────┘
                                │
                                ▼
                           genHtml ─────────────────▶ HTMLファイル
                                │
                           コード例ディレクトリ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| docgen.zig | `tools/docgen.zig` | ソース | docgenツールのメイン実装 |
| langref.html.in | `doc/langref.html.in` | テンプレート | 言語リファレンスのテンプレート |
