# 機能設計書 66-update_cpu_features

## 概要

本ドキュメントは、ZigコンパイラにおけるCPUフィーチャー情報更新ツール（update_cpu_features）の設計を記述する。このツールは、LLVMのTableGen定義からZigのCPUフィーチャー定義を自動生成するために使用される。

### 本機能の処理概要

update_cpu_featuresは、LLVMのTableGen（llvm-tblgen）を使用して各ターゲットアーキテクチャのCPU定義とフィーチャー定義を抽出し、Zig標準ライブラリの`lib/std/Target/*.zig`ファイルを生成するツールである。LLVMの定義とZig独自の拡張・オーバーライドを組み合わせて、クロスコンパイルに必要なCPU/フィーチャー情報を提供する。

**業務上の目的・背景**：Zigはクロスコンパイラとして多数のターゲットアーキテクチャをサポートする。LLVMのCPU/フィーチャー定義を手動で管理するのは非現実的であるため、LLVMのTableGen定義から自動生成することで、LLVMのアップデートに追従しやすくし、一貫性のあるターゲット定義を維持する。

**機能の利用シーン**：
- LLVMバージョンアップ時のCPUフィーチャー定義の更新
- 新しいターゲットアーキテクチャの追加
- CPUフィーチャーのカスタマイズやオーバーライドの適用

**主要な処理内容**：
1. llvm-tblgenを実行してJSON形式でフィーチャー情報を取得
2. JSONをパースしてフィーチャーとCPUの情報を抽出
3. Zig固有のオーバーライド（省略、フラット化、名前変更）を適用
4. `lib/std/Target/{arch}.zig`ファイルを生成

**関連システム・外部連携**：
- LLVM（llvm-tblgen実行ファイル）
- LLVMソースリポジトリ（TableGen定義ファイル）

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | コマンドラインツール（画面なし） |

## 機能種別

コード生成 / ビルドツール

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| llvm-tblgen | []const u8 | Yes | llvm-tblgen実行ファイルパス | 有効なパス |
| llvm-project | []const u8 | Yes | LLVMプロジェクトルートパス | 有効なディレクトリ |
| zig-src | []const u8 | Yes | Zigソースディレクトリパス | 有効なディレクトリ |
| filter | []const u8 | No | 特定アーキテクチャのみ処理 | ターゲット名 |

### 入力データソース

- `llvm/lib/Target/{Target}/{Target}.td` - LLVMのTableGen定義ファイル
- ツール内のtargets配列 - Zig固有のオーバーライド定義

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| {arch}.zig | []u8 | 各アーキテクチャのCPUフィーチャー定義ファイル |

### 出力先

- `lib/std/Target/{arch}.zig`

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   ├─ llvm-tblgenパス取得
   ├─ LLVMソースルート取得
   ├─ Zigソースルート取得
   └─ オプションのフィルタ取得

2. ターゲット処理（並列）
   └─ 各ArchTargetについて:
       ├─ llvm-tblgen実行（LLVMターゲットの場合）
       ├─ JSON出力のパース
       ├─ フィーチャー抽出とオーバーライド適用
       ├─ CPU抽出とオーバーライド適用
       └─ Zigコード生成と書き込み

3. 完了
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C{全引数あり?}
    C -->|No| D[Usage表示]
    D --> E[終了]
    C -->|Yes| F[ターゲット反復開始]
    F --> G{LLVMターゲット?}
    G -->|Yes| H[llvm-tblgen実行]
    H --> I[JSON出力パース]
    I --> J[フィーチャー抽出]
    G -->|No| J
    J --> K[オーバーライド適用]
    K --> L[追加フィーチャー/CPU追加]
    L --> M[ソート]
    M --> N[Zigコード生成]
    N --> O[ファイル書き込み]
    O --> P{次ターゲット?}
    P -->|Yes| F
    P -->|No| Q[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-66-01 | フィーチャー省略 | omit=trueのフィーチャーは出力しない | feature_override指定時 |
| BR-66-02 | フィーチャーフラット化 | flatten=trueのフィーチャーは依存として展開 | feature_override指定時 |
| BR-66-03 | 名前変換 | zig_nameが指定されていればLLVM名を変換 | feature_override指定時 |
| BR-66-04 | CPU省略 | omit_cpusに含まれるCPUは出力しない | omit_cpus指定時 |
| BR-66-05 | 追加フィーチャー | extra_featuresで定義されたフィーチャーを追加 | extra_features指定時 |
| BR-66-06 | 追加CPU | extra_cpusで定義されたCPUを追加 | extra_cpus指定時 |

### 計算ロジック

**LLVM名からZig名への変換（llvmNameToZigName）**：
- ハイフン（-）をアンダースコア（_）に変換
- ドット（.）をアンダースコア（_）に変換

**依存関係のプルーニング（pruneFeatures）**：
- 各フィーチャーの依存関係を再帰的に走査
- 推移的な依存は削除し、直接の依存のみ残す

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | 必須引数の欠如 | 正しい引数の指定 |
| - | llvm-tblgenエラー | llvm-tblgen実行失敗 | LLVMツールの確認 |
| - | JSONパースエラー | JSON解析失敗 | LLVMバージョン確認 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 並列処理によるターゲット処理の高速化
- 最大500MBのllvm-tblgen出力に対応

## セキュリティ考慮事項

- 外部プロセス（llvm-tblgen）の実行
- ファイル書き込み権限の確認

## 備考

- 非LLVMターゲット（alpha, hppa, kvx, propeller等）はextra_featuresとextra_cpusで定義
- branch_quotaはコンパイル時の分岐制限を設定
- 一部のCPUはエイリアスとして処理される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | update_cpu_features.zig | `tools/update_cpu_features.zig` | オーバーライド構造体の定義 |

**読解のコツ**:
- `FeatureOverride`はLLVMフィーチャーに対するZig固有の修正を定義
- `Cpu`はCPU定義（llvm_name, zig_name, features）
- `Feature`はフィーチャー定義（llvm_name, zig_name, desc, deps）
- `ArchTarget`は各ターゲットアーキテクチャの設定

**主要処理フロー**:
- **12-23行目**: FeatureOverride構造体定義
- **25-29行目**: Cpu構造体定義
- **31-37行目**: Feature構造体定義
- **39-50行目**: ArchTarget構造体定義

#### Step 2: ターゲット定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | update_cpu_features.zig | `tools/update_cpu_features.zig` | targets配列 |

**主要処理フロー**:
- **52-1884行目**: targets配列 - 各アーキテクチャの設定
  - aarch64, arm, x86等のLLVMターゲット
  - alpha, hppa等の非LLVMターゲット

#### Step 3: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | update_cpu_features.zig | `tools/update_cpu_features.zig` | main関数 |

**主要処理フロー**:
- **1886-1945行目**: main関数 - 引数解析と並列処理開始

#### Step 4: ターゲット処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | update_cpu_features.zig | `tools/update_cpu_features.zig` | processOneTarget関数 |

**主要処理フロー**:
- **1956-2416行目**: processOneTarget関数
  - llvm-tblgen実行
  - JSONパース
  - フィーチャー/CPU抽出
  - Zigコード生成

### プログラム呼び出し階層図

```
main
    │
    ├─ 引数解析
    │
    ├─ Progress.start (進捗表示)
    │
    └─ group.async (並列処理)
           └─ processOneTarget (各ターゲット)
                  ├─ std.process.run (llvm-tblgen実行)
                  ├─ json.parseFromSlice (JSON解析)
                  ├─ フィーチャー抽出
                  │      ├─ llvmNameToZigName
                  │      └─ llvmFeatureNameToZigNameOmit
                  ├─ CPU抽出
                  ├─ extra_features追加
                  ├─ extra_cpus追加
                  ├─ mem.sort (ソート)
                  ├─ pruneFeatures (依存関係プルーニング)
                  │      └─ walkFeatures
                  └─ ファイル書き込み
```

### データフロー図

```
[入力]                          [処理]                              [出力]

llvm/lib/Target/{T}/{T}.td ──▶ llvm-tblgen ───────────────▶ JSON出力
                                    │
                                    ▼
                            json.parseFromSlice
                                    │
                                    ▼
                            ┌───────────────────┐
                            │ SubtargetFeature │
                            │ Processor        │
                            │ ProcessorAlias   │
                            └───────────────────┘
                                    │
                                    ▼
                            FeatureOverride適用
                                    │
                                    ├── omit: フィーチャー除外
                                    ├── flatten: 依存展開
                                    └── zig_name: 名前変換
                                    │
                                    ▼
                            extra_features/cpus追加
                                    │
                                    ▼
                            pruneFeatures (依存整理)
                                    │
                                    ▼
                            Zigコード生成 ─────────────────▶ lib/std/Target/{arch}.zig
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| update_cpu_features.zig | `tools/update_cpu_features.zig` | ソース | メイン実装 |
| aarch64.zig | `lib/std/Target/aarch64.zig` | 出力 | AArch64ターゲット定義 |
| arm.zig | `lib/std/Target/arm.zig` | 出力 | ARMターゲット定義 |
| x86.zig | `lib/std/Target/x86.zig` | 出力 | x86ターゲット定義 |
| riscv.zig | `lib/std/Target/riscv.zig` | 出力 | RISC-Vターゲット定義 |
