# 機能設計書 67-gen_spirv_spec

## 概要

本ドキュメントは、ZigコンパイラにおけるSPIR-V仕様生成ツール（gen_spirv_spec）の設計を記述する。このツールは、Khronos GroupのSPIR-V仕様定義からZigのSPIR-Vバインディングを自動生成するために使用される。

### 本機能の処理概要

gen_spirv_specは、SPIR-Headersリポジトリに含まれるJSON形式のSPIR-V文法定義ファイルを読み込み、Zigコードとして使用可能なSPIR-V仕様定義（オペコード、オペランド型、列挙型等）を生成するツールである。

**業務上の目的・背景**：ZigはGPUシェーダーをSPIR-Vバイナリとして出力するコード生成機能を持つ。SPIR-V仕様は頻繁に更新されるため、手動でバインディングを維持するのは困難である。このツールにより、Khronos公式の文法定義から自動的にZigバインディングを生成し、仕様との一貫性を保証する。

**機能の利用シーン**：
- SPIR-Vバージョンアップ時の仕様定義更新
- 新しいSPIR-V拡張命令セットの追加
- コード生成器の開発・保守

**主要な処理内容**：
1. SPIR-V文法JSONファイルの読み込み
2. コア仕様と拡張仕様（OpenCL, GLSL）の統合
3. オペコード、オペランド型、列挙型のZigコード生成
4. 重複するエイリアスの処理

**関連システム・外部連携**：
- SPIR-Headersリポジトリ（Khronos Group）
- Zigコンパイラのコード生成器

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | コマンドラインツール（画面なし） |

## 機能種別

コード生成 / ビルドツール

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| spirv-headers | []const u8 | Yes | SPIR-Headersリポジトリパス | 有効なディレクトリ |
| extinst-path | []const u8 | Yes | Zig固有の拡張命令JSONパス | 有効なファイル |

### 入力データソース

- `include/spirv/unified1/spirv.core.grammar.json` - コア文法定義
- `include/spirv/unified1/extinst.*.grammar.json` - 拡張命令セット定義
- `src/codegen/spirv/extinst.zig.grammar.json` - Zig固有の拡張命令

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| spirv_spec | []u8 | 生成されたSPIR-V仕様定義Zigコード |

### 出力先

- 標準出力（パイプでファイルにリダイレクト）

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   ├─ SPIR-Headersパス取得
   └─ 拡張命令パス取得

2. レジストリ読み込み
   ├─ spirv.core.grammar.json読み込み
   └─ extinst.*.grammar.json読み込み（反復）

3. 拡張命令セット読み込み
   ├─ OpenCL.std.100
   ├─ GLSL.std.450
   └─ zig（Zig固有）

4. コード生成
   ├─ 基本型定義（Version, Word, Id等）
   ├─ Class列挙型
   ├─ OperandKind列挙型
   ├─ Opcode列挙型
   ├─ 拡張Opcode列挙型
   └─ InstructionSet列挙型

5. 出力
   ├─ ASTパース（構文チェック）
   ├─ フォーマット
   └─ 標準出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C{引数数=3?}
    C -->|No| D[Usage表示]
    D --> E[終了]
    C -->|Yes| F[コア文法読み込み]
    F --> G[命令ソート]
    G --> H[ディレクトリ反復]
    H --> I{extinst.*?}
    I -->|Yes| J[拡張レジストリ読み込み]
    J --> H
    I -->|No| H
    H --> K[Zig拡張命令読み込み]
    K --> L[render関数]
    L --> M[基本型定義出力]
    M --> N[Class列挙型出力]
    N --> O[OperandKind出力]
    O --> P[Opcode出力]
    P --> Q[拡張Opcode出力]
    Q --> R[InstructionSet出力]
    R --> S[ASTパース]
    S --> T{エラー?}
    T -->|Yes| U[エラー出力]
    T -->|No| V[フォーマット出力]
    V --> W[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-67-01 | 命令セット名マッピング | extinst名からZig用名前への変換 | set_names定義 |
| BR-67-02 | タグ優先度 | 重複値の解決に優先度を使用 | 重複オペコード/列挙型 |
| BR-67-03 | エイリアス生成 | 重複する値はエイリアスとして出力 | 重複検出時 |
| BR-67-04 | 拡張構造体 | パラメータを持つ列挙型は.Extended追加 | extendedStructs判定 |

### 計算ロジック

**タグ優先度スコア（tagPriorityScore）**：
- 空文字列: 1（最優先）
- "EXT": 2
- "KHR": 3
- その他: 4（最低優先）

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | 引数数が3でない | 正しい引数の指定 |
| - | JSONパースエラー | JSON解析失敗 | ファイル確認 |
| - | ASTパースエラー | 生成コードの構文エラー | 生成ロジック確認 |
| - | ZIRエラー | コンパイルエラー | 生成ロジック確認 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- @setEvalBranchQuota(10000)でJSON解析の分岐制限を設定

## セキュリティ考慮事項

- 入力JSONファイルの検証
- 外部リポジトリからのデータ使用

## 備考

- サポートされる命令セット: OpenCL.std, GLSL.std.450, zig
- zig_generator_id: 41（Zigコンパイラの識別子）
- BitEnum型はpacket structとして生成

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | gen_spirv_spec.zig | `tools/gen_spirv_spec.zig` | 型定義とインポート |
| 1-2 | grammar.zig | `tools/spirv/grammar.zig` | SPIR-V文法構造体 |

**読解のコツ**:
- `Extension`は拡張命令セットの情報を保持
- `CoreRegistry`と`ExtensionRegistry`はJSON形式に対応
- `OperandKind`はオペランドの種類を定義

**主要処理フロー**:
- **6-11行目**: grammarモジュールのインポート
- **16-20行目**: Extension構造体定義
- **52-56行目**: set_names - 命令セット名のマッピング

#### Step 2: レジストリ読み込みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | gen_spirv_spec.zig | `tools/gen_spirv_spec.zig` | readRegistry関数 |

**主要処理フロー**:
- **138-152行目**: readRegistry関数 - JSONファイルの読み込みとパース

#### Step 3: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | gen_spirv_spec.zig | `tools/gen_spirv_spec.zig` | main関数 |

**主要処理フロー**:
- **58-112行目**: main関数
  - 引数チェック（61-63行目）
  - コア文法読み込み（70行目）
  - 拡張命令読み込み（75-84行目）
  - render呼び出し（88行目）
  - ASTパースとZIRチェック（92-108行目）

#### Step 4: コード生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | gen_spirv_spec.zig | `tools/gen_spirv_spec.zig` | render関数 |

**主要処理フロー**:
- **191-328行目**: render関数
  - 基本型定義出力（197-286行目）
  - Class列挙型出力（318行目: renderClass）
  - OperandKind出力（319行目: renderOperandKind）
  - Opcode出力（321行目: renderOpcodes）
  - OperandKinds出力（326行目: renderOperandKinds）

### プログラム呼び出し階層図

```
main
    │
    ├─ readRegistry (コア文法)
    │
    ├─ dir.iterate (拡張文法検索)
    │      └─ readExtRegistry
    │             └─ readRegistry
    │
    ├─ readExtRegistry (Zig拡張)
    │
    └─ render
           ├─ extendedStructs
           ├─ renderClass
           ├─ renderOperandKind
           │      └─ renderEnumerant
           ├─ renderOpcodes
           │      └─ renderOperand
           ├─ renderOperandKinds
           │      ├─ renderValueEnum
           │      │      └─ renderOperand
           │      └─ renderBitEnum
           │             └─ renderOperand
           └─ renderInstructionSet
                  └─ renderInstructionsCase
```

### データフロー図

```
[入力]                              [処理]                              [出力]

spirv.core.grammar.json ────────▶ readRegistry ──────────────▶ CoreRegistry
                                        │
extinst.*.grammar.json ─────────▶ readExtRegistry ───────────▶ Extension[]
                                        │
extinst.zig.grammar.json ───────▶ readExtRegistry ───────────▶ Extension[]
                                        │
                                        ▼
                                ┌─────────────────┐
                                │ all_operand_   │
                                │ kinds (merge)  │
                                └─────────────────┘
                                        │
                                        ▼
                                    render
                                        │
                                        ├── Version, Word, Id等
                                        ├── Class enum
                                        ├── OperandKind enum
                                        ├── Opcode enum
                                        ├── 拡張Opcode enums
                                        └── InstructionSet enum
                                        │
                                        ▼
                                    ASTパース
                                        │
                                        ▼
                                    フォーマット ────────────▶ 標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| gen_spirv_spec.zig | `tools/gen_spirv_spec.zig` | ソース | メイン実装 |
| grammar.zig | `tools/spirv/grammar.zig` | ソース | SPIR-V文法構造体定義 |
| spirv.core.grammar.json | (SPIR-Headers) | 入力 | コアSPIR-V文法 |
| extinst.glsl.std.450.grammar.json | (SPIR-Headers) | 入力 | GLSL拡張命令 |
| extinst.opencl.std.100.grammar.json | (SPIR-Headers) | 入力 | OpenCL拡張命令 |
| extinst.zig.grammar.json | `src/codegen/spirv/` | 入力 | Zig固有拡張命令 |
| spec.zig | `lib/std/Target/spirv/` | 出力 | 生成されるSPIR-V仕様 |
