# 機能設計書 68-process_headers

## 概要

本ドキュメントは、Zigコンパイラにおけるヘッダーファイル処理ツール（process_headers）の設計を記述する。このツールは、各種libc実装（glibc, musl, FreeBSD, NetBSD, OpenBSD）のヘッダーファイルを処理し、Zigが配布するクロスコンパイル用ヘッダーを生成するために使用される。

### 本機能の処理概要

process_headersは、複数のターゲットアーキテクチャ向けにビルドされたlibcヘッダーファイルを入力として受け取り、アーキテクチャ間で共通のヘッダーを「generic」として統合し、アーキテクチャ固有のヘッダーを個別ディレクトリに配置する処理を行う。これにより、Zigが単一のインストールで全ターゲットをサポートできるようになる。

**業務上の目的・背景**：glibc, musl等のビルドシステムは単一のターゲットアーキテクチャしかサポートしない。一方、Zigはクロスコンパイラとして全ターゲットを単一インストールでサポートする。このツールにより、各ターゲット向けのヘッダーを収集・統合し、Zigが配布するヘッダーファイルセットを生成する。

**機能の利用シーン**：
- libcバージョンアップ時のヘッダー更新
- 新しいターゲットアーキテクチャの追加
- Zigリリースビルドの準備

**主要な処理内容**：
1. 各ターゲットのヘッダーディレクトリをスキャン
2. ファイル内容をハッシュ化して重複検出
3. 最頻出のファイルを「generic」として抽出
4. アーキテクチャ固有のファイルを個別出力

**関連システム・外部連携**：
- 各種libcビルドシステム（glibc, musl, FreeBSD, NetBSD, OpenBSD）
- Zigのlib/libcディレクトリ

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | コマンドラインツール（画面なし） |

## 機能種別

ビルドツール / ヘッダー処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --search-path | []const u8 | No | ヘッダー検索パス（複数指定可） | 有効なディレクトリ |
| --out | []const u8 | Yes | 出力ディレクトリパス | 有効なパス |
| --abi | []const u8 | Yes | C ABI名（glibc, musl, freebsd等） | LibCVendor |

### 入力データソース

- 各ターゲットのlibcインストールディレクトリ
- サブディレクトリ形式: `{arch}-linux-gnu`, `{arch}-musl`等

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| generic-{abi}/ | ディレクトリ | 共通ヘッダー |
| {arch}-{os}-{abi}/ | ディレクトリ | アーキテクチャ固有ヘッダー |

### 出力先

- 指定された出力ディレクトリ

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   ├─ search-pathの収集
   ├─ 出力ディレクトリ取得
   └─ ABI名取得

2. ターゲット反復
   └─ 各libcターゲットについて:
       ├─ ヘッダーディレクトリ特定
       ├─ ファイル再帰スキャン
       ├─ 内容ハッシュ計算（Blake3）
       └─ パステーブルに登録

3. 重複分析
   └─ 各パスについて:
       ├─ ヒットカウントでソート
       └─ 最頻出をgenericに分類

4. ファイル出力
   ├─ genericディレクトリ出力
   └─ アーキテクチャ固有ディレクトリ出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[引数解析]
    B --> C{--outあり?}
    C -->|No| D[Usage表示]
    D --> E[終了]
    C -->|Yes| F{--abiあり?}
    F -->|No| D
    F -->|Yes| G[ABI解決]
    G --> H[ターゲットリスト取得]
    H --> I[各ターゲット処理]
    I --> J[ヘッダーディレクトリ検索]
    J --> K[ファイルスキャン]
    K --> L[Blake3ハッシュ計算]
    L --> M[パステーブル登録]
    M --> N{次ターゲット?}
    N -->|Yes| I
    N -->|No| O[ヒットカウントソート]
    O --> P[genericファイル特定]
    P --> Q[generic出力]
    Q --> R[アーキ固有出力]
    R --> S[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-68-01 | 重複統合 | 同一内容のファイルはgenericに統合 | hit_count > 1 |
| BR-68-02 | ハッシュ計算 | パス+内容でBlake3ハッシュを計算 | 全ファイル |
| BR-68-03 | 空白トリム | ファイル内容は前後の空白をトリム | 全ファイル |
| BR-68-04 | dest統合 | dest指定ターゲットは統合出力 | LibCTarget.dest指定時 |

### 計算ロジック

**ハッシュ計算**：
1. Blake3ハッシャー初期化
2. 相対パスをハッシュに追加
3. トリム済み内容をハッシュに追加
4. 32バイトハッシュを生成

**ヒットカウントソート**：
- 同一ハッシュのファイル数をカウント
- 降順ソートで最頻出を先頭に

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | 必須引数の欠如 | 正しい引数の指定 |
| - | ABI認識エラー | 不明なABI名 | glibc/musl/freebsd/netbsd/openbsd |
| - | ディレクトリエラー | ターゲットディレクトリ不在 | 警告出力して続行 |
| - | ファイル読み込みエラー | ファイルアクセス失敗 | エラー伝播 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 最大2GBのファイル読み込み対応
- 効率的なハッシュベース重複検出

## セキュリティ考慮事項

- ファイルシステムへの書き込み権限確認
- シンボリックリンクの適切な処理

## 備考

- サポートするABI: glibc, musl, freebsd, netbsd, openbsd
- 「奇妙なファイル」（通常ファイル/シンボリックリンク以外）は警告出力
- glibcでは一部ヘッダーがarm/mips等で統合される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | process_headers.zig | `tools/process_headers.zig` | ターゲット定義と型 |

**読解のコツ**:
- `LibCTarget`は各ターゲット（arch, abi, dest）を定義
- `Contents`はファイル内容とメタデータを保持
- `LibCVendor`はサポートするlibc種別の列挙

**主要処理フロー**:
- **23-27行目**: LibCTarget構造体定義
- **29-62行目**: glibc_targets配列
- **64-81行目**: musl_targets配列
- **83-119行目**: freebsd/netbsd/openbsd_targets配列
- **120-130行目**: Contents構造体定義
- **136-142行目**: LibCVendor列挙型

#### Step 2: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process_headers.zig | `tools/process_headers.zig` | main関数 |

**主要処理フロー**:
- **144-399行目**: main関数
  - 引数解析（156-185行目）
  - ターゲット反復（203-348行目）
  - 重複分析（355-398行目）

#### Step 3: ファイル処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | process_headers.zig | `tools/process_headers.zig` | ファイルスキャンとハッシュ |

**主要処理フロー**:
- **277-316行目**: ファイルスキャンとハッシュ計算
  - Blake3ハッシュ初期化（298行目）
  - パス追加（299行目）
  - 内容追加（300行目）

### プログラム呼び出し階層図

```
main
    │
    ├─ 引数解析
    │      ├─ search_paths収集
    │      ├─ opt_out_dir取得
    │      └─ opt_abi取得
    │
    ├─ LibCVendor解決
    │      └─ stringToEnum
    │
    ├─ ターゲット反復
    │      └─ 各libc_targetについて:
    │             ├─ libc_dir計算
    │             │      ├─ glibcRuntimeTriple
    │             │      └─ muslArchName
    │             ├─ dest_target計算
    │             ├─ search_path反復
    │             │      └─ ディレクトリスキャン
    │             │             ├─ dir.iterate
    │             │             ├─ readFileAlloc
    │             │             ├─ Blake3.init
    │             │             └─ path_table登録
    │             └─ hash_to_contents登録
    │
    ├─ 重複分析
    │      ├─ Contents.hitCountLessThan
    │      └─ mem.sort
    │
    └─ ファイル出力
           ├─ generic出力
           │      └─ writeFile
           └─ アーキ固有出力
                  └─ writeFile
```

### データフロー図

```
[入力]                              [処理]                              [出力]

{search-path}/
  ├─ x86_64-linux-gnu/   ─────▶ ファイルスキャン ──────────────▶ path_table
  ├─ aarch64-linux-gnu/                  │
  ├─ arm-linux-gnu/                      │
  └─ ...                                 ▼
                                ┌────────────────────┐
                                │ Blake3ハッシュ     │
                                │ (path + content)  │
                                └────────────────────┘
                                         │
                                         ▼
                                ┌────────────────────┐
                                │ hash_to_contents  │
                                │ (重複検出)         │
                                └────────────────────┘
                                         │
                                         ▼
                                ヒットカウントソート
                                         │
                         ┌───────────────┴───────────────┐
                         ▼                               ▼
                   hit_count > 1                   hit_count = 1
                         │                               │
                         ▼                               ▼
              {out}/generic-{abi}/           {out}/{arch}-{os}-{abi}/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_headers.zig | `tools/process_headers.zig` | ソース | メイン実装 |
| lib/libc/glibc/ | `lib/libc/glibc/` | 出力 | glibc用ヘッダー |
| lib/libc/musl/ | `lib/libc/musl/` | 出力 | musl用ヘッダー |
| target.zig | `lib/std/zig/target.zig` | 参照 | glibcRuntimeTriple, muslArchName |
