# 機能設計書 7-build

## 概要

本ドキュメントは、Zigコンパイラの`build`コマンドの機能設計について記述する。このコマンドはbuild.zigファイルからプロジェクトをビルドする、Zigネイティブのビルドシステム機能である。

### 本機能の処理概要

`zig build`コマンドは、プロジェクトのルートにある`build.zig`ファイルを読み込み、そこに記述されたビルド手順に従ってプロジェクトをビルドする。Zigの標準ライブラリに含まれる`std.Build`モジュールを使用し、宣言的かつ柔軟なビルド定義を可能にする。依存関係管理、クロスコンパイル、カスタムビルドステップなど、本格的なプロジェクトビルドに必要な機能を提供する。

**業務上の目的・背景**：複数のソースファイルや依存関係を持つプロジェクトでは、単純なコンパイルコマンドだけでは管理が難しくなる。`zig build`は、Zigで記述されたビルドスクリプト（build.zig）を通じて、複雑なビルドプロセスを管理する。MakefileやCMakeに相当する機能をZig言語自体で提供することで、言語の一貫性と型安全性を維持しながらビルドを自動化できる。

**機能の利用シーン**：
- 複数ファイルからなるプロジェクトのビルド
- 外部依存関係を持つプロジェクトのビルド
- テスト、インストール、配布などの複合タスクの実行
- クロスコンパイルを含むマルチターゲットビルド

**主要な処理内容**：
1. build.zigファイルの検索とコンパイル
2. ビルドランナーの実行
3. 依存関係の解決とパッケージフェッチ
4. 定義されたビルドステップの実行
5. 成果物の生成

**関連システム・外部連携**：
- パッケージマネージャ：build.zig.zonベースの依存関係解決
- std.Build：ビルドシステムAPI

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | プロジェクトビルド画面 | 主機能 | build.zigに基づいてプロジェクトをビルドする処理 |

## 機能種別

ビルドシステム / プロジェクト管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --build-file | []const u8 | No | build.zigファイルのパス | 有効なファイルパス |
| --zig-lib-dir | []const u8 | No | Zigライブラリディレクトリ | 有効なディレクトリパス |
| --cache-dir | []const u8 | No | キャッシュディレクトリ | 有効なディレクトリパス |
| --global-cache-dir | []const u8 | No | グローバルキャッシュディレクトリ | 有効なディレクトリパス |
| --fetch | bool | No | 依存関係のフェッチのみ実行 | - |
| --system | []const u8 | No | システムパッケージディレクトリ | 有効なディレクトリパス |
| -j | u32 | No | 並列ジョブ数 | 1以上の整数 |
| [targets...] | []const u8 | No | 実行するビルドターゲット | - |

### 入力データソース

- コマンドライン引数
- build.zig（ビルドスクリプト）
- build.zig.zon（パッケージマニフェスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ビルド成果物 | バイナリ/テキスト | 定義されたターゲットの出力 |
| ビルドログ | テキスト | ビルド進捗と結果のログ |

### 出力先

- zig-out/ディレクトリ（デフォルト）
- zig-cache/ディレクトリ（キャッシュ）

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ cmdBuild関数で処理
2. build.zigの検索
   └─ カレントディレクトリまたは指定パスから検索
3. ビルドランナーのコンパイル
   └─ build.zigをコンパイルして実行可能にする
4. 依存関係解決
   └─ build.zig.zonから依存関係をフェッチ
5. ビルドランナー実行
   └─ 子プロセスとしてビルドランナーを起動
6. ビルドステップ実行
   └─ 要求されたターゲットをビルド
7. 結果出力
   └─ 成果物をzig-out/に配置
```

### フローチャート

```mermaid
flowchart TD
    A[zig build 開始] --> B[コマンドライン引数解析]
    B --> C[build.zig検索]
    C --> D{build.zig存在?}
    D -->|Yes| E[ビルドランナーコンパイル]
    D -->|No| F[エラー: build.zigが見つかりません]
    E --> G{--fetch指定?}
    G -->|Yes| H[依存関係フェッチのみ]
    G -->|No| I[ビルドランナー実行]
    I --> J[ターゲットビルド実行]
    J --> K{ビルド成功?}
    K -->|Yes| L[成果物出力]
    K -->|No| M[エラー出力]
    H --> N[終了]
    L --> N
    M --> N
    F --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | デフォルトビルドファイル | カレントディレクトリのbuild.zigを使用 | --build-file未指定時 |
| BR-02 | デフォルトターゲット | install/defaultターゲットを実行 | ターゲット未指定時 |
| BR-03 | 依存関係自動フェッチ | 初回ビルド時に依存関係を自動フェッチ | 依存関係が未解決の場合 |

### 計算ロジック

特になし

## データベース操作仕様

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | FileNotFound | build.zigが見つからない | build.zigを作成 |
| - | CompileError | build.zigにエラー | ビルドスクリプトを修正 |
| - | FetchError | 依存関係のフェッチ失敗 | ネットワーク接続を確認 |

### リトライ仕様

- 依存関係フェッチはネットワークエラー時にリトライ可能

## トランザクション仕様

該当なし

## パフォーマンス要件

- 並列ビルド対応（-j オプション）
- インクリメンタルビルド対応
- キャッシュによる再コンパイル回避

## セキュリティ考慮事項

- 外部パッケージはハッシュで検証
- build.zigは任意のコードを実行可能なため、信頼できるソースのみ使用

## 備考

- build.zigはZig言語で記述されたビルドスクリプト
- build.zig.zonは依存関係を定義するマニフェストファイル

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | buildコマンドの分岐処理 |

**主要処理フロー**:
1. **286-288行目**: `mem.eql(u8, cmd, "build")`で判定
2. **cmdBuild関数**が呼び出される

#### Step 2: cmdBuild関数の理解

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | cmdBuild関数の実装 |

**主要処理フロー**:
- **4891行目**: `fn cmdBuild`の開始
- **4894-4898行目**: 環境変数からの設定読み込み
- **4919-4935行目**: child_argvの構築
- **4996-5002行目**: --fetchオプションの処理

#### Step 3: ビルドシステムAPIの理解

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Build.zig | `lib/std/Build.zig` | std.Build APIの構造 |

### プログラム呼び出し階層図

```
main (src/main.zig)
    │
    └─ cmdBuild
            │
            ├─ build.zig検索
            │
            ├─ 環境変数・オプション処理
            │      ├─ ZIG_LIB_DIR
            │      ├─ ZIG_GLOBAL_CACHE_DIR
            │      └─ ZIG_LOCAL_CACHE_DIR
            │
            ├─ ビルドランナーコンパイル
            │
            └─ ビルドランナー実行（子プロセス）
                   └─ std.Build APIを使用
```

### データフロー図

```
[入力]                    [処理]                         [出力]

build.zig ─────────────▶ コンパイル ─────▶ ビルドランナー
                                                │
build.zig.zon ──▶ 依存関係解決 ──▶ パッケージ    │
                                     │         │
                                     └─────────▼
                                          ビルド実行 ──▶ zig-out/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンド分岐、cmdBuild |
| Build.zig | `lib/std/Build.zig` | ライブラリ | ビルドシステムAPI |
| Package.zig | `src/Package.zig` | ソース | パッケージ管理 |
