# 機能設計書 71-detect-cpu

## 概要

本ドキュメントは、Zigコンパイラにおけるdetect-cpuコマンドの機能設計を記載する。このコマンドは、ZigのCPU機能検出機能をデバッグするためのツールであり、ホストCPUの名前と機能セットを標準出力に表示する。

### 本機能の処理概要

detect-cpuは、Zigコンパイラのデバッグ拡張コマンドの一つであり、ホストマシンのCPU名と対応する機能セット（フィーチャー）を検出して表示する。この機能により、開発者はZigの内部CPU検出機能とLLVMのCPU検出機能を比較検証できる。

**業務上の目的・背景**：Zigコンパイラは、ターゲットCPUに応じて最適化されたコードを生成する。CPUの機能セット（SIMD命令、暗号化拡張など）を正確に検出することが重要であり、この機能はZigの検出結果とLLVMの検出結果を比較することで、検出精度の検証や問題の診断を可能にする。

**機能の利用シーン**：
- Zigコンパイラの開発時に、新しいCPUアーキテクチャのサポートを追加する際
- ビルド時にCPU機能の検出が期待通りに動作しているか確認したい場合
- LLVMとZigのCPU機能検出の差異を調査する必要がある場合
- クロスコンパイル時のターゲットCPU機能の確認

**主要な処理内容**：
1. コマンドライン引数の解析（--llvmオプションの有無を確認）
2. LLVMモードの場合、LLVM APIを使用してホストCPU名と機能セットを取得
3. 標準モードの場合、Zigの内部ターゲット解決機能を使用してホストCPU情報を取得
4. 取得したCPU情報を標準出力に整形して表示

**関連システム・外部連携**：
- LLVM API（--llvmオプション使用時）：LLVMバインディングを通じてホストCPU情報を取得

**権限による制御**：特に権限による制御はなし。ただし、LLVMオプションを使用するにはLLVM拡張がビルドに含まれている必要がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | CPU検出画面 | 主機能 | ZigのCPU機能検出とLLVMの比較処理 |

## 機能種別

データ取得 / 情報表示 / デバッグ支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --llvm | フラグ | No | LLVMのCPU検出APIを使用する | LLVMビルドが有効である必要あり |
| -h, --help | フラグ | No | ヘルプメッセージを表示 | なし |

### 入力データソース

- コマンドライン引数
- ホストマシンのハードウェア情報（CPU）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CPU名 | 文字列 | 検出されたCPUモデル名（LLVM名） |
| 機能フラグ | +/-プレフィックス付き文字列リスト | 有効/無効な各CPU機能 |

### 出力先

標準出力（stdout）

出力形式例：
```
skylake
+sse
+sse2
+avx
+avx2
-avx512f
...
```

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ --llvmフラグの有無を確認
2. --llvmフラグが指定されている場合
   └─ LLVMバインディングを使用してCPU情報を取得
   └─ detectNativeCpuWithLLVM関数でCPU構造体を構築
3. --llvmフラグが指定されていない場合
   └─ Zigの標準ターゲット解決機能を使用
   └─ std.zig.resolveTargetQueryOrFatalでホストターゲットを取得
4. printCpu関数でCPU情報を標準出力に表示
   └─ CPU名を出力
   └─ 全機能について有効/無効フラグを出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{引数解析}
    B --> C{--llvmフラグ?}
    C -->|Yes| D{LLVM利用可能?}
    D -->|No| E[エラー終了]
    D -->|Yes| F[LLVM APIでCPU検出]
    F --> G[detectNativeCpuWithLLVM]
    C -->|No| H[Zig標準のターゲット解決]
    H --> I[resolveTargetQueryOrFatal]
    G --> J[printCpu]
    I --> J
    J --> K[CPU名を出力]
    K --> L[各機能フラグを出力]
    L --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-71-01 | LLVM依存チェック | --llvmオプション使用時はLLVMビルドが必須 | --llvmオプション指定時 |
| BR-71-02 | 機能フラグ表示 | 有効な機能は+、無効な機能は-でプレフィックス | 常時 |
| BR-71-03 | LLVM名表示 | LLVM名が定義されている機能のみ表示 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

本機能ではデータベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | LLVMビルド未対応 | --llvmオプション指定時にLLVMビルドでない | LLVMを有効にしてZigをビルドし直す |
| N/A | CPU名取得失敗 | LLVMがホストCPU名を特定できない | fatalエラーとして終了 |
| N/A | 機能セット取得失敗 | LLVMがホストCPU機能セットを特定できない | fatalエラーとして終了 |
| N/A | 不正な引数 | 認識できないパラメータ指定 | エラーメッセージを表示して終了 |

### リトライ仕様

リトライは行わない（即時エラー終了）

## トランザクション仕様

該当なし

## パフォーマンス要件

即時レスポンスが期待される。CPU情報の取得と表示は数ミリ秒以内に完了すること。

## セキュリティ考慮事項

特になし（ホストマシン情報を表示するため、共有環境での使用時は出力内容の取り扱いに注意）

## 備考

- このコマンドはデバッグ拡張コマンドであり、`build_options.enable_debug_extensions`が有効な場合にのみ使用可能
- 出力形式はLLVMのCPU機能フラグ形式に準拠している

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

CPUターゲット情報の構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Target.zig | `lib/std/Target.zig` | Cpu構造体、Cpu.Model、Cpu.Feature.Setの定義 |
| 1-2 | builtin.zig | `lib/std/builtin.zig` | @import("builtin").cpuでホストCPU情報にアクセス |

**読解のコツ**: Zigの標準ライブラリではCPU情報は`std.Target.Cpu`構造体で管理される。`model`フィールドでCPUモデル、`features`フィールドで有効な機能セットを保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | mainArgs関数でのコマンドディスパッチ |

**主要処理フロー**:
1. **381-382行目**: `detect-cpu`コマンドの判定と`cmdDetectCpu`の呼び出し
2. **6351-6398行目**: `cmdDetectCpu`関数本体

#### Step 3: CPU検出処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | cmdDetectCpu関数（6351-6398行目） |
| 3-2 | main.zig | `src/main.zig` | detectNativeCpuWithLLVM関数（6401-6462行目） |
| 3-3 | main.zig | `src/main.zig` | printCpu関数（6464-6482行目） |

**主要処理フロー**:
- **6354-6363行目**: ヘルプメッセージの定義
- **6365-6384行目**: 引数解析（--llvmフラグの検出）
- **6386-6398行目**: CPU検出と出力（LLVMモードと標準モードの分岐）
- **6401-6462行目**: LLVM APIを使用したCPU検出ロジック
- **6464-6482行目**: CPU情報のフォーマット出力

#### Step 4: LLVMバインディングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bindings.zig | `src/codegen/llvm/bindings.zig` | GetHostCPUName、GetHostCPUFeatures関数 |

**読解のコツ**: LLVMバインディングは外部LLVM C APIへのZigインターフェースを提供する。

### プログラム呼び出し階層図

```
main.zig::mainArgs()
    │
    └─ main.zig::cmdDetectCpu()
           │
           ├─ [--llvmモード]
           │      ├─ llvm/bindings.zig::GetHostCPUName()
           │      ├─ llvm/bindings.zig::GetHostCPUFeatures()
           │      └─ main.zig::detectNativeCpuWithLLVM()
           │             └─ std.Target.Cpu構造体の構築
           │
           ├─ [標準モード]
           │      └─ std.zig.resolveTargetQueryOrFatal()
           │             └─ ホストターゲットのCPU情報を返却
           │
           └─ main.zig::printCpu()
                  └─ CPU名と機能フラグを標準出力に表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

コマンドライン  ───▶ 引数解析               ───▶ ヘルプ表示
   引数                                          (--help時)
                           │
                           ▼
                     ┌─────┴─────┐
                     │           │
              --llvmあり    --llvmなし
                     │           │
                     ▼           ▼
              LLVM API呼出   Zig標準検出
                     │           │
                     ▼           ▼
              CPU名/機能取得  CPU名/機能取得
                     │           │
                     └─────┬─────┘
                           │
                           ▼
                     printCpu() ───────────▶ 標準出力
                                               (CPU情報)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドエントリーポイントとCPU検出処理 |
| bindings.zig | `src/codegen/llvm/bindings.zig` | ソース | LLVM C APIバインディング |
| Target.zig | `lib/std/Target.zig` | ソース | CPU/ターゲット情報の構造体定義 |
| builtin.zig | `lib/std/builtin.zig` | ソース | コンパイル時ホスト情報 |
| build_options.zig | `src/build_options.zig` | 設定 | ビルドオプション（enable_debug_extensions等） |
