# 機能設計書 72-llvm-ints

## 概要

本ドキュメントは、Zigコンパイラにおけるllvm-intsコマンドの機能設計を記載する。このコマンドは、指定されたターゲットに対する全整数型のLLVM ABIアラインメント情報をダンプするデバッグ用ツールである。

### 本機能の処理概要

llvm-intsは、Zigコンパイラのデバッグ拡張コマンドの一つであり、LLVMのターゲット定義における整数型のABIアラインメント値を表示する。これにより、開発者は異なるターゲットアーキテクチャにおける整数型のメモリアラインメント要件を確認できる。

**業務上の目的・背景**：Zigコンパイラは複数のターゲットアーキテクチャをサポートしており、各ターゲットにおけるデータ型のアラインメントは異なる場合がある。このコマンドは、LLVMが報告する整数型のアラインメント値を確認することで、Zigのコード生成やメモリレイアウトの正確性を検証するために使用される。

**機能の利用シーン**：
- 新しいターゲットアーキテクチャのサポート開発時
- ABIの互換性問題の調査時
- クロスコンパイル時のデータ型アラインメントの確認
- ZigとLLVMのアラインメント設定の整合性検証

**主要な処理内容**：
1. コマンドライン引数からターゲットトリプルを取得
2. LLVMターゲットを初期化（aarch64, x86）
3. 指定されたトリプルからLLVMターゲットを取得
4. ターゲットマシンとデータレイアウトを作成
5. 各整数型（1, 8, 16, 32, 64, 128, 256ビット）のABIアラインメントを取得
6. 結果を標準出力に表示

**関連システム・外部連携**：
- LLVM API：ターゲット情報とABIアラインメント計算に使用

**権限による制御**：特に権限による制御はなし。ただし、LLVM拡張がビルドに含まれている必要がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | LLVM整数ダンプ画面 | 主機能 | 全整数型のLLVMABIAlignmentOfTypeのダンプ処理 |

## 機能種別

データ取得 / 情報表示 / デバッグ支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| target-triple | 文字列 | Yes | ターゲットトリプル（例：x86_64-linux-gnu） | 有効なLLVMターゲットトリプルであること |

### 入力データソース

- コマンドライン引数（ターゲットトリプル）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 整数型ビット幅 | 整数 | 整数型のビット幅（1, 8, 16, 32, 64, 128, 256） |
| ABIアラインメント | 整数 | 該当整数型のABIアラインメント値（バイト単位） |

### 出力先

標準出力（stdout）

出力形式例：
```
LLVMABIAlignmentOfType(i1) == 1
LLVMABIAlignmentOfType(i8) == 1
LLVMABIAlignmentOfType(i16) == 2
LLVMABIAlignmentOfType(i32) == 4
LLVMABIAlignmentOfType(i64) == 8
LLVMABIAlignmentOfType(i128) == 16
LLVMABIAlignmentOfType(i256) == 32
```

## 処理フロー

### 処理シーケンス

```
1. デバッグモードチェック
   └─ dev.check(.llvm_ints_command)
2. LLVMビルドチェック
   └─ build_options.have_llvmがfalseの場合はfatalエラー
3. ターゲットトリプル取得
   └─ args[0]からターゲットトリプルを取得しNULL終端化
4. LLVMターゲット初期化
   └─ aarch64とx86アーキテクチャを初期化
5. ターゲット取得
   └─ LLVMのgetFromTripleでターゲットを取得
6. ターゲットマシン作成
   └─ createTargetMachineでターゲットマシンインスタンスを生成
7. データレイアウト作成
   └─ createTargetDataLayoutでデータレイアウトを取得
8. アラインメント出力
   └─ 各整数型（1, 8, 16, 32, 64, 128, 256ビット）について
      └─ intTypeで整数型を作成
      └─ abiAlignmentOfTypeでアラインメントを取得
      └─ 結果を標準出力に表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{LLVM利用可能?}
    B -->|No| C[fatalエラー終了]
    B -->|Yes| D[ターゲットトリプル取得]
    D --> E[LLVMターゲット初期化]
    E --> F[ターゲット取得]
    F --> G{取得成功?}
    G -->|No| H[パニック]
    G -->|Yes| I[ターゲットマシン作成]
    I --> J[データレイアウト作成]
    J --> K[LLVMコンテキスト作成]
    K --> L[整数型ループ開始]
    L --> M[整数型作成]
    M --> N[ABIアラインメント取得]
    N --> O[結果出力]
    O --> P{全型処理完了?}
    P -->|No| L
    P -->|Yes| Q[flush]
    Q --> R[正常終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-72-01 | LLVM必須 | 本コマンドはLLVMビルドでのみ利用可能 | 常時 |
| BR-72-02 | デバッグ拡張 | enable_debug_extensionsが有効である必要がある | 常時 |
| BR-72-03 | 整数型範囲 | 1, 8, 16, 32, 64, 128, 256ビットの整数型を対象 | 常時 |

### 計算ロジック

ABIアラインメントはLLVMの`LLVMABIAlignmentOfType` APIを使用して取得する。アラインメント値はターゲットアーキテクチャのABI仕様に基づいて決定される。

## データベース操作仕様

本機能ではデータベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | LLVMビルド未対応 | LLVMビルドでない場合 | LLVMを有効にしてZigをビルドし直す |
| N/A | ターゲット取得失敗 | 無効なターゲットトリプル指定時 | パニックで終了（@panic("bad")） |

### リトライ仕様

リトライは行わない

## トランザクション仕様

該当なし

## パフォーマンス要件

即時レスポンスが期待される。LLVM API呼び出しと表示は数十ミリ秒以内に完了すること。

## セキュリティ考慮事項

特になし

## 備考

- このコマンドはデバッグ拡張コマンドであり、`build_options.enable_debug_extensions`が有効な場合にのみ使用可能
- 現在の実装ではaarch64とx86のみ初期化されるため、他のアーキテクチャでは期待通りに動作しない可能性がある
- 出力形式は`LLVMABIAlignmentOfType(iN) == M`の形式

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

LLVMのターゲットとデータレイアウトの概念を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bindings.zig | `src/codegen/llvm/bindings.zig` | Target、TargetMachine、DataLayout、Contextの構造体 |

**読解のコツ**: LLVMバインディングはLLVM C APIへのZigインターフェース。Target→TargetMachine→DataLayout→Contextの階層構造を理解することが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | mainArgs関数でのコマンドディスパッチ |

**主要処理フロー**:
1. **387-388行目**: `llvm-ints`コマンドの判定と`cmdDumpLlvmInts`の呼び出し

#### Step 3: コマンド実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | cmdDumpLlvmInts関数（6484-6525行目） |

**主要処理フロー**:
- **6490行目**: dev.check(.llvm_ints_command)でデバッグモード確認
- **6494-6495行目**: LLVMビルドチェック
- **6497行目**: ターゲットトリプルをNULL終端文字列として取得
- **6499行目**: LLVMバインディングのインポート
- **6501-6503行目**: aarch64とx86ターゲットの初期化
- **6505-6510行目**: ターゲットトリプルからLLVMターゲットを取得
- **6511行目**: ターゲットマシンの作成
- **6512行目**: データレイアウトの作成
- **6513行目**: LLVMコンテキストの作成
- **6517-6521行目**: 各整数型のアラインメントを取得して出力

#### Step 4: LLVMバインディングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bindings.zig | `src/codegen/llvm/bindings.zig` | Target.getFromTriple、TargetMachine.create等 |
| 4-2 | llvm.zig | `src/codegen/llvm.zig` | initializeLLVMTarget関数 |

**読解のコツ**: bindings.zigはLLVM C APIを1対1でラップしている。関数名がLLVM C APIと対応しているため、LLVMのドキュメントを参照すると理解が深まる。

### プログラム呼び出し階層図

```
main.zig::mainArgs()
    │
    └─ main.zig::cmdDumpLlvmInts()
           │
           ├─ dev.check(.llvm_ints_command)
           │
           ├─ llvm.zig::initializeLLVMTarget(.aarch64)
           ├─ llvm.zig::initializeLLVMTarget(.x86)
           │
           ├─ bindings.Target.getFromTriple()
           │
           ├─ bindings.TargetMachine.create()
           │      └─ createTargetDataLayout()
           │
           ├─ bindings.Context.create()
           │
           └─ [ループ: 1, 8, 16, 32, 64, 128, 256]
                  ├─ context.intType(bits)
                  └─ dataLayout.abiAlignmentOfType()
                         └─ 標準出力に結果表示
```

### データフロー図

```
[入力]                  [処理]                      [出力]

ターゲットトリプル ───▶ LLVM初期化
   (args[0])                 │
                             ▼
                      ターゲット取得
                             │
                             ▼
                      TargetMachine作成
                             │
                             ▼
                      DataLayout取得
                             │
                             ▼
                      Context作成
                             │
                             ▼
                      整数型ループ ─────────────▶ 標準出力
                      (1,8,16,32,64,128,256)     (アラインメント情報)
                             │
                             ▼
                      abiAlignmentOfType
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドエントリーポイントと主処理 |
| bindings.zig | `src/codegen/llvm/bindings.zig` | ソース | LLVM C APIバインディング |
| llvm.zig | `src/codegen/llvm.zig` | ソース | LLVMターゲット初期化関数 |
| build_options.zig | `src/build_options.zig` | 設定 | have_llvm、enable_debug_extensions |
| dev.zig | `src/dev.zig` | ソース | デバッグ機能チェック |
