# 機能設計書 73-Tracy統合

## 概要

本ドキュメントは、Zigコンパイラにおけるtracy.zigモジュールの機能設計を記載する。このモジュールは、高性能なフレームプロファイラーであるTracyとの統合を提供し、コンパイラのパフォーマンス分析とデバッグを可能にする。

### 本機能の処理概要

Tracy統合は、Zigコンパイラの性能プロファイリング機能を提供するモジュールである。Tracyプロファイラーと連携し、ゾーントレーシング、メモリアロケーション追跡、フレームマーキングなどの機能を提供する。これにより開発者はコンパイラの実行パフォーマンスを視覚的に分析できる。

**業務上の目的・背景**：Zigコンパイラは大規模なコードベースをコンパイルする際に性能が重要となる。Tracy統合により、コンパイラ開発者はボトルネックの特定、メモリ使用量の分析、実行時間の計測を行い、コンパイラの最適化に役立てることができる。

**機能の利用シーン**：
- コンパイラのパフォーマンスボトルネックの調査
- コンパイル時間の長い処理の特定
- メモリアロケーションパターンの分析
- コンパイラ開発時のリグレッションテスト
- テスト実行時のプロファイリング

**主要な処理内容**：
1. ゾーントレーシング（trace/traceNamed）による処理区間の計測
2. メモリアロケーション追跡（TracyAllocator）
3. フレームマーキング（frameMark/frameMarkNamed）
4. メッセージ出力（message/messageColor）
5. カスタムゾーン属性（テキスト、名前、色、値）の設定

**関連システム・外部連携**：
- Tracy Profiler：外部のプロファイリングツール（クライアント/サーバーモデル）
- ビルドオプション：enable_tracy、enable_tracy_allocation、enable_tracy_callstackで制御

**権限による制御**：特に権限による制御はなし。ただし、Tracy機能を使用するにはビルド時にTracyオプションを有効にする必要がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | テスト実行画面 | 補助機能 | テスト実行時のプロファイリング・トレーシング処理 |

## 機能種別

パフォーマンス計測 / デバッグ支援 / プロファイリング

## 入力仕様

### 入力パラメータ

Tracy統合はビルドオプションとAPIによって制御される。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| enable_tracy | bool | No | Tracy統合の有効化 | ビルドオプション |
| enable_tracy_allocation | bool | No | アロケーション追跡の有効化 | ビルドオプション |
| enable_tracy_callstack | bool | No | コールスタック収集の有効化 | ビルドオプション |
| tracy_callstack_depth | int | No | コールスタックの深さ（デフォルト10） | 正の整数 |

### 入力データソース

- ビルドオプション（build_options）
- ソースコードからのAPI呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ゾーン情報 | Ctx構造体 | トレーシングゾーンの開始/終了情報 |
| メモリイベント | アロケーション/フリー | メモリ確保・解放イベント |
| フレームマーク | タイムスタンプ | フレーム区切りのマーキング |
| メッセージ | 文字列 | カスタムログメッセージ |

### 出力先

Tracy Profilerサーバー（ネットワーク経由またはファイル出力）

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ ビルドオプションでTracy有効化を確認
   └─ enable=true/falseに基づいてCtx型を選択
2. ゾーントレーシング
   └─ trace(@src())でゾーン開始
   └─ 処理実行
   └─ ctx.end()でゾーン終了
3. メモリ追跡（オプション）
   └─ TracyAllocatorでアロケータをラップ
   └─ alloc/resize/remap/free時にイベント送信
4. フレームマーク
   └─ frameMark()でフレーム区切り記録
5. 終了
   └─ 自動的にTracyサーバーへデータ送信
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{Tracy有効?}
    B -->|No| C[空の実装を使用]
    B -->|Yes| D[Tracyバインディング使用]
    D --> E[ゾーン開始]
    E --> F[処理実行]
    F --> G{カスタム属性?}
    G -->|Yes| H[テキスト/名前/色/値設定]
    G -->|No| I[ゾーン終了]
    H --> I
    I --> J{メモリ追跡有効?}
    J -->|Yes| K[アロケーションイベント送信]
    J -->|No| L[終了]
    K --> L
    C --> M[何もしない]
    M --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-73-01 | 条件付き有効化 | build_options.enable_tracyに基づいて機能を有効化 | ビルド時 |
| BR-73-02 | ゼロオーバーヘッド | Tracy無効時は空の実装が使用され、オーバーヘッドなし | enable=false時 |
| BR-73-03 | コールスタック深度 | デフォルトのコールスタック深度は10 | enable_callstack有効時 |
| BR-73-04 | テスト時無効 | テストビルド時はTracyを無効化 | builtin.is_test=true時 |

### 計算ロジック

特になし（計測データはTracyプロファイラーで可視化）

## データベース操作仕様

本機能ではデータベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | アロケーション失敗 | メモリ確保失敗時 | "allocation failed"メッセージを赤色で出力 |
| N/A | リアロケーション失敗 | メモリ再確保失敗時 | "reallocation failed"メッセージを赤色で出力 |

### リトライ仕様

リトライは行わない

## トランザクション仕様

該当なし

## パフォーマンス要件

Tracy自体は極めて低オーバーヘッドであることが期待される。無効時はゼロオーバーヘッドとなる（コンパイル時に空の実装に置き換わる）。

## セキュリティ考慮事項

- プロファイリングデータには実行パスやメモリアドレス情報が含まれる可能性がある
- 本番環境での使用は推奨されない

## 備考

- TracyはC++で実装された外部ツールであり、ZigからはexternでC APIを呼び出している
- ビルド時にTracy統合を有効にするには、`-Denable-tracy`オプションを使用する
- Tracy GUIを別途起動してプロファイリングデータを確認する必要がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Tracy統合の中核となるCtx構造体を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tracy.zig | `src/tracy.zig` | Ctx構造体（条件付き型選択）、enable定数 |

**読解のコツ**:
- **5-8行目**: `enable`、`enable_allocation`、`enable_callstack`の定義。ビルドオプションに基づく条件付き有効化。
- **10-33行目**: `___tracy_c_zone_context`（Tracy有効時のCtx）の定義。
- **35-59行目**: Tracy無効時のダミーCtx。メソッドは何もしない。

#### Step 2: ゾーントレーシングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tracy.zig | `src/tracy.zig` | trace関数、traceNamed関数 |

**主要処理フロー**:
- **61-79行目**: `trace`関数。@src()でソース位置情報を取得し、ゾーンを開始。
- **81-99行目**: `traceNamed`関数。名前付きゾーンの開始。
- **74-78行目**: enable_callstackに応じてコールスタック付きでゾーン開始。

#### Step 3: TracyAllocatorを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tracy.zig | `src/tracy.zig` | TracyAllocator構造体 |

**主要処理フロー**:
- **101-103行目**: `tracyAllocator`関数。アロケータをラップ。
- **105-196行目**: `TracyAllocator`型の定義。alloc/resize/remap/freeをフック。
- **129-144行目**: allocFn。アロケーション時にTracyにイベント送信。
- **182-194行目**: freeFn。解放時にTracyにイベント送信。

#### Step 4: メッセージングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | tracy.zig | `src/tracy.zig` | message関数群 |

**主要処理フロー**:
- **199-202行目**: `message`関数（コンパイル時既知文字列）。
- **205-208行目**: `messageColor`関数（色付きメッセージ）。
- **210-218行目**: `messageCopy`/`messageColorCopy`（ランタイム文字列）。

#### Step 5: フレームマーキングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | tracy.zig | `src/tracy.zig` | フレームマーク関数群 |

**主要処理フロー**:
- **220-228行目**: `frameMark`/`frameMarkNamed`。フレーム区切りの記録。
- **230-241行目**: `namedFrame`/`Frame`。RAIIスタイルのフレームマーキング。
- **243-251行目**: 内部関数`frameMarkStart`/`frameMarkEnd`。

#### Step 6: externバインディングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | tracy.zig | `src/tracy.zig` | extern関数宣言 |

**主要処理フロー**:
- **253-322行目**: Tracy C APIへのextern宣言。
- **324-330行目**: `___tracy_source_location_data`構造体。ソース位置情報。

### プログラム呼び出し階層図

```
[Zigコンパイラコード]
    │
    ├─ tracy.trace(@src())
    │      └─ ___tracy_emit_zone_begin / _callstack
    │
    ├─ ctx.addText() / setName() / setColor() / setValue()
    │      └─ ___tracy_emit_zone_text / name / color / value
    │
    ├─ ctx.end()
    │      └─ ___tracy_emit_zone_end
    │
    ├─ tracy.tracyAllocator(gpa)
    │      └─ TracyAllocator
    │             ├─ allocFn → ___tracy_emit_memory_alloc(_callstack)(_named)
    │             ├─ resizeFn → free + alloc
    │             ├─ remapFn → free + alloc
    │             └─ freeFn → ___tracy_emit_memory_free(_callstack)(_named)
    │
    ├─ tracy.message() / messageColor()
    │      └─ ___tracy_emit_messageL / messageLC
    │
    └─ tracy.frameMark() / frameMarkNamed()
           └─ ___tracy_emit_frame_mark
```

### データフロー図

```
[入力]                 [処理]                      [出力]

@src()情報 ────────▶ trace()
                         │
                         ▼
                    ゾーン開始 ────────────────▶ Tracy Server
                         │                        (ゾーン情報)
                         ▼
                    [処理実行]
                         │
                         ▼
アロケータ ────────▶ TracyAllocator
                         │
                         ▼
                    alloc/free ────────────────▶ Tracy Server
                         │                        (メモリイベント)
                         ▼
                    ゾーン終了 ────────────────▶ Tracy Server
                                                  (ゾーン終了)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tracy.zig | `src/tracy.zig` | ソース | Tracy統合の主要モジュール |
| build_options.zig | `src/build_options.zig` | 設定 | enable_tracy等のビルドオプション |
| main.zig | `src/main.zig` | ソース | tracyAllocatorの使用例（207-209行目） |
| Compilation.zig | `src/Compilation.zig` | ソース | traceの使用例 |
| aro/tracy.zig | `lib/compiler/aro/aro/tracy.zig` | ソース | Aroコンパイラ用の別Tracy統合 |
