# 機能設計書 8-init

## 概要

本ドキュメントは、Zigコンパイラの`init`コマンドの機能設計について記述する。このコマンドは現在のディレクトリにZigパッケージを初期化し、build.zigおよび基本構造を生成する機能である。

### 本機能の処理概要

`zig init`コマンドは、カレントディレクトリにZigプロジェクトのテンプレートファイルを生成する。`build.zig`（ビルドスクリプト）、`build.zig.zon`（パッケージマニフェスト）、およびソースファイル（`src/main.zig`、`src/root.zig`）を作成し、新しいZigプロジェクトの雛形を構築する。

**業務上の目的・背景**：新しいZigプロジェクトを開始する際、ビルドシステムやパッケージ管理のための設定ファイルを一から作成するのは手間がかかる。`zig init`は、標準的なプロジェクト構造とテンプレートファイルを自動生成し、プロジェクト開始を迅速化する。これにより、開発者は設定作業ではなくコーディングに集中できる。

**機能の利用シーン**：
- 新しいZigプロジェクトの開始
- 既存のコードベースにビルドシステムを追加
- Zigパッケージの作成開始

**主要な処理内容**：
1. コマンドライン引数の解析
2. テンプレートタイプの決定（example/minimal）
3. ディレクトリ名からプロジェクト名を推定
4. テンプレートファイルの生成
5. ファイルシステムへの書き込み

**関連システム・外部連携**：
- std.Build：生成されるbuild.zigで使用

**権限による制御**：特になし。ファイルシステムへの書き込み権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | プロジェクト初期化画面 | 主機能 | 現在のディレクトリにZigパッケージを初期化する処理 |

## 機能種別

プロジェクト初期化 / ファイル生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -m, --minimal | bool | No | 最小テンプレートを使用 | - |
| -h, --help | bool | No | ヘルプを表示 | - |

### 入力データソース

- コマンドライン引数
- カレントディレクトリ名（プロジェクト名の推定に使用）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| build.zig | テキスト | ビルドスクリプト |
| build.zig.zon | テキスト | パッケージマニフェスト |
| src/main.zig | テキスト | メインソースファイル（exampleモード） |
| src/root.zig | テキスト | ライブラリルートファイル（exampleモード） |

### 出力先

- カレントディレクトリ

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ cmdInit関数で処理
2. テンプレートタイプ決定
   └─ --minimalでminimal、それ以外でexample
3. プロジェクト名推定
   └─ カレントディレクトリ名をサニタイズして使用
4. フィンガープリント生成
   └─ ランダムなフィンガープリントを生成
5. テンプレートファイル生成
   └─ build.zig, build.zig.zon, src/*.zigを生成
6. ファイル書き込み
   └─ 既存ファイルは上書きしない
```

### フローチャート

```mermaid
flowchart TD
    A[zig init 開始] --> B[コマンドライン引数解析]
    B --> C{--minimal?}
    C -->|Yes| D[minimalテンプレート]
    C -->|No| E[exampleテンプレート]
    D --> F[プロジェクト名推定]
    E --> F
    F --> G[フィンガープリント生成]
    G --> H{exampleモード?}
    H -->|Yes| I[4ファイル生成]
    H -->|No| J[2ファイル生成]
    I --> K[ファイル書き込み]
    J --> K
    K --> L{既存ファイルあり?}
    L -->|Yes| M[スキップして通知]
    L -->|No| N[ファイル作成]
    M --> O[完了メッセージ]
    N --> O
    O --> P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | デフォルトテンプレート | --minimal未指定時はexampleテンプレートを使用 | オプション未指定時 |
| BR-02 | 既存ファイル保護 | 既存ファイルは上書きしない | ファイルが既に存在する場合 |
| BR-03 | プロジェクト名サニタイズ | ディレクトリ名から不正な文字を除去 | 常時 |
| BR-04 | フィンガープリント | build.zig.zonにユニークなフィンガープリントを生成 | 常時 |

### 計算ロジック

**プロジェクト名サニタイズ**：
- 英数字、アンダースコアのみを許可
- 数字で始まる場合は先頭にアンダースコアを追加
- ハイフン、ドット、スペースはアンダースコアに変換

## データベース操作仕様

データベースは使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | PermissionDenied | ファイル書き込み権限なし | 権限を確認 |
| - | PathAlreadyExists | ファイルが既に存在（minimalモードで致命的） | 既存ファイルを削除または移動 |

### リトライ仕様

自動リトライなし

## トランザクション仕様

該当なし

## パフォーマンス要件

特になし（単発のファイル生成処理）

## セキュリティ考慮事項

- フィンガープリントはランダム生成されユニーク性を確保

## 備考

- exampleテンプレートは実行可能なサンプルコードを含む
- minimalテンプレートは最小限の設定ファイルのみ生成

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | initコマンドの分岐処理 |

**主要処理フロー**:
1. **342-343行目**: `mem.eql(u8, cmd, "init")`で判定
2. **cmdInit関数**が呼び出される

#### Step 2: cmdInit関数の理解

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | cmdInit関数の実装 |

**主要処理フロー**:
- **4755行目**: `fn cmdInit`の開始
- **4758行目**: テンプレートタイプの定義（example/minimal）
- **4764-4766行目**: --minimalオプションの処理
- **4778-4780行目**: プロジェクト名の推定
- **4782-4783行目**: フィンガープリント生成
- **4785-4854行目**: テンプレート別のファイル生成

#### Step 3: サニタイズ処理の理解

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | sanitizeExampleName関数 |

**主要処理フロー**:
- **4856-4872行目**: プロジェクト名のサニタイズロジック

### プログラム呼び出し階層図

```
main (src/main.zig)
    │
    └─ cmdInit
            │
            ├─ テンプレートタイプ判定
            │
            ├─ introspect.getResolvedCwd
            │      └─ カレントディレクトリ取得
            │
            ├─ sanitizeExampleName
            │      └─ プロジェクト名サニタイズ
            │
            ├─ Package.Fingerprint.generate
            │      └─ フィンガープリント生成
            │
            └─ ファイル書き込み
                   ├─ build.zig
                   ├─ build.zig.zon
                   ├─ src/main.zig (exampleのみ)
                   └─ src/root.zig (exampleのみ)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ──▶ オプション解析 ──┐
                                        │
カレントディレクトリ ──▶ 名前サニタイズ ─┼──▶ テンプレート生成 ──▶ ファイル群
                                        │
ランダムソース ───────▶ FP生成 ─────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | cmdInit関数 |
| Package.zig | `src/Package.zig` | ソース | Fingerprint生成 |
| introspect.zig | `src/introspect.zig` | ソース | CWD取得 |
