---
generated_at: 2026-02-01 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-ast-check.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 379-380行目 - ast-checkコマンド判定
- E-02: `src/main.zig` 6184-6340行目 - cmdAstCheck関数
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 行11 - ast-check定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング
- E-05: `lib/std/zig/Ast.zig` - AST解析存在
- E-06: `lib/std/zig/AstGen.zig` - AstGen存在

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ast-checkは構文エラーを検査する | E-01, E-03 | ○ |
| C-02 | cmdAstCheck関数で処理 | E-02 | ○ |
| C-03 | 関連画面No.9が対応 | E-04 | ○ |
| C-04 | -tオプションでZIRテキスト出力 | E-02 | ○ |
| C-05 | --zonオプションでZONモード強制 | E-02 | ○ |
| C-06 | --colorオプションでカラー制御 | E-02 | ○ |
| C-07 | 標準入力からの読み込み対応 | E-02 | ○ |
| C-08 | .zonファイルは自動的にZONモード | E-02 | ○ |
| C-09 | Ast.parseでAST構築 | E-02, E-05 | ○ |
| C-10 | AstGen.generateでZIR生成 | E-02, E-06 | ○ |
| C-11 | ZonGen.generateでZOIR生成 | E-02 | ○ |
| C-12 | hasCompileErrors()でエラー判定 | E-02 | ○ |
| C-13 | ErrorBundle.Wipでエラー構築 | E-02 | ○ |
| C-14 | エラー時は終了コード1 | E-02 | ○ |
| C-15 | 成功時は終了コード0 | E-02 | ○ |
| C-16 | ソースファイルを読み込み | E-02 | ○ |
| C-17 | ZIRの統計情報を出力（-t時） | E-02 | ○ |
| C-18 | print_zir.zigでZIRをテキスト化 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目

## 6) レビュアーチェックリスト（最小）
- [ ] cmdAstCheck関数の実装がドキュメントと一致するか確認
- [ ] Ast.parseとAstGen.generateの呼び出しを確認
- [ ] ZONモードの判定ロジックを確認
