---
generated_at: 2026-02-01 17:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：11-fmt.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**: 具体的な数値目標がソースコードから読み取れない
  2. **セキュリティ考慮事項**: 明示的なセキュリティ処理のコードが限定的

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/fmt.zig` - fmtコマンドのメイン実装ファイル
- E-02: `src/main.zig` - CLIエントリーポイント（318-320行目）
- E-03: `lib/std/zig/Ast.zig` - AST解析・レンダリング
- E-04: `lib/std/zig/AstGen.zig` - ZIR生成
- E-05: `lib/std/zig/ZonGen.zig` - ZOIR生成
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | fmtはZigソースコードを正規フォーマットに整形する | E-01 (10-28行目usage_fmt) | ○ |
| C-02 | .zigと.zonファイルを処理対象とする | E-01 (239行目, 291-295行目) | ○ |
| C-03 | --stdinオプションで標準入力から読み込み | E-01 (73-74行目, 97-158行目) | ○ |
| C-04 | --checkオプションでフォーマット違反を報告 | E-01 (75-76行目, 152-155行目, 354-356行目) | ○ |
| C-05 | --ast-checkオプションでAST検査を実行 | E-01 (77-78行目, 115-144行目, 306-342行目) | ○ |
| C-06 | --colorオプションでカラー出力を制御 | E-01 (64-72行目) | ○ |
| C-07 | --excludeオプションでファイル除外 | E-01 (79-85行目, 184-196行目) | ○ |
| C-08 | --zonオプションで全ファイルをZONとして処理 | E-01 (86-87行目, 291-295行目) | ○ |
| C-09 | std.zig.Ast.parseでAST解析を行う | E-01 (110行目, 297行目) | ○ |
| C-10 | tree.render/renderAllocでフォーマット生成 | E-01 (149行目, 348行目) | ○ |
| C-11 | seenマップで重複処理を防止 | E-01 (42行目, 231行目, 289行目) | ○ |
| C-12 | ディレクトリの再帰処理を行う | E-01 (218-254行目fmtPathDir関数) | ○ |
| C-13 | ドットで始まるファイルをスキップ | E-01 (237行目) | ○ |
| C-14 | アトミックファイル書き込みで上書き | E-01 (358-362行目createFileAtomic) | ○ |
| C-15 | main.zigからfmt.zigのrunを呼び出し | E-02 (318-320行目) | ○ |
| C-16 | 画面No.10がフォーマット画面として関連 | E-07 (24行目) | ○ |
| C-17 | ZIR生成による意味解析を行う | E-01 (117行目, 312行目), E-04 | ○ |
| C-18 | ZOIR生成によるZON意味解析を行う | E-01 (131行目, 327行目), E-05 | ○ |
| C-19 | 入力ファイルがない場合はfatal終了 | E-01 (160-162行目) | ○ |
| C-20 | --stdinとファイル引数は排他 | E-01 (98-100行目) | ○ |
| C-21 | エラー時はany_errorフラグを設定 | E-01 (212行目, 248行目, 302-303行目, 323行目) | ○ |
| C-22 | any_errorがtrueならexit(1) | E-01 (202-204行目) | ○ |
| C-23 | 元ファイルのパーミッションを保持 | E-01 (358行目permissions: stat.permissions) | ○ |
| C-24 | 出力バッファは入力と同等容量を事前確保 | E-01 (345-346行目) | ○ |
| C-25 | 差分はmem.eqlでバイト比較 | E-01 (351行目) | ○ |
| C-26 | フォーマット後ファイルパスを標準出力 | E-01 (355行目, 363行目) | ○ |
| C-27 | パフォーマンス要件の具体的数値 | **根拠なし** | △ |
| C-28 | セキュリティ対策の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件**: ソースコードから具体的な性能目標（レスポンス時間、スループット等）を示すコメントや定数は見つからなかった
  - 候補：Zigプロジェクトのベンチマーク資料 / 性能テストコード / 開発者ドキュメント
- **セキュリティ考慮事項**: 明示的なセキュリティ処理（入力サニタイズ、パストラバーサル対策等）のコードは限定的
  - 候補：セキュリティガイドライン / 脆弱性対応の履歴 / コードレビューコメント

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 主要機能の説明（フォーマット処理、オプション動作）
- **0 (低リスク)**: 処理フロー・データフローの説明
- **1 (中リスク)**: パフォーマンス要件 - 具体的根拠なし、実装から推測した記述
- **1 (中リスク)**: セキュリティ考慮事項 - 一般的な記述、具体的な実装根拠が限定的

## 6) レビュアーチェックリスト（最小）
- [ ] C-27: パフォーマンス要件の記述が実際の運用要件と整合しているか確認
- [ ] C-28: セキュリティ考慮事項に追加すべき項目がないか確認
- [ ] フローチャートが実際のコードの分岐と一致しているか確認
- [ ] 入力パラメータの説明が最新のヘルプメッセージと一致しているか確認
