---
generated_at: 2026-02-01 17:35:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：12-reduce.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**: 具体的な処理速度目標がソースコードから読み取れない
  2. **未実装機能の詳細**: ロードマップコメントの解釈に依存

## 2) 参照した情報（Evidence一覧）

- E-01: `lib/compiler/reduce.zig` - reduceコマンドのメイン実装
- E-02: `lib/compiler/reduce/Walk.zig` - AST走査と変換候補収集
- E-03: `src/main.zig` - CLIエントリーポイント（368-372行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | reduceはバグレポートを最小化するツール | E-01 (11-35行目usage), E-04 | ○ |
| C-02 | チェッカーのexit(0)はinteresting | E-01 (37行目, 284-286行目) | ○ |
| C-03 | チェッカーのexit(1)はunknown | E-01 (286行目) | ○ |
| C-04 | --seedで乱数シードを指定 | E-01 (81-87行目) | ○ |
| C-05 | --skip-smoke-testでスモークテストをスキップ | E-01 (73-74行目, 123行目) | ○ |
| C-06 | --main-mod-pathは未実装 | E-01 (75-76行目) | ○ |
| C-07 | --modは未実装 | E-01 (77-78行目) | ○ |
| C-08 | --depsは未実装 | E-01 (79-80行目) | ○ |
| C-09 | Transformationは8種類の変換を定義 | E-02 (15-49行目) | ○ |
| C-10 | gut_functionは関数本体を@trap()に置換 | E-02 (17-18行目) | ○ |
| C-11 | delete_nodeはグローバル宣言を削除 | E-02 (20行目) | ○ |
| C-12 | サブセットサイズを3/4に縮小 | E-01 (170行目) | ○ |
| C-13 | シャッフルにstd.Random.DefaultPrngを使用 | E-01 (139行目, 276-281行目) | ○ |
| C-14 | findTransformationsでAST走査 | E-02 (54-83行目) | ○ |
| C-15 | walkMembersでメンバー宣言を走査 | E-02 (85-94行目) | ○ |
| C-16 | tree.renderでソースコード生成 | E-01 (183行目) | ○ |
| C-17 | AstGenで未使用変数を検出 | E-01 (196-224行目) | ○ |
| C-18 | runCheckでチェッカーを実行 | E-01 (301-306行目) | ○ |
| C-19 | interestingで変換候補を再収集 | E-01 (235-244行目) | ○ |
| C-20 | boring/unknownで次のサブセットを試行 | E-01 (246-258行目) | ○ |
| C-21 | 全変換試行後にソースを復元 | E-01 (265-268行目) | ○ |
| C-22 | jitCmdでreduce.zigを呼び出し | E-03 (368-372行目) | ○ |
| C-23 | チェッカーのstderrはそのまま表示 | E-01 (303-304行目) | ○ |
| C-24 | パフォーマンス要件の具体的数値 | **根拠なし** | △ |
| C-25 | ロードマップ機能の完全な仕様 | **根拠なし（コメントのみ）** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件**: 具体的な処理速度や効率に関する要件はソースコードから読み取れなかった
  - 候補：ベンチマーク資料 / 性能テスト / 開発者ドキュメント
- **ロードマップ機能**: E-01の39-48行目にコメントとして記載があるが、詳細仕様は不明
  - 候補：Zig開発者向けドキュメント / GitHubイシュー / RFCドキュメント

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 主要機能の説明（変換処理、チェッカー仕様）
- **0 (低リスク)**: 処理フロー・データフローの説明
- **1 (中リスク)**: 未実装機能の記述 - コメントからの推測に依存
- **1 (中リスク)**: パフォーマンス要件 - 具体的根拠なし

## 6) レビュアーチェックリスト（最小）
- [ ] C-24: パフォーマンス要件の記述が実際の運用要件と整合しているか確認
- [ ] C-25: 未実装機能（--main-mod-path, --mod, --deps）の将来的な仕様を確認
- [ ] 8種類のTransformationの説明が実装と一致しているか確認
- [ ] チェッカーの終了コード仕様がドキュメントと一致しているか確認
