---
generated_at: 2026-02-01 17:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：15-cpp.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **C++標準サポート範囲**: 具体的なサポート範囲の確認が必要
  2. **例外/RTTIデフォルト設定**: デフォルト値の詳細確認が必要
  3. **libc++/libunwindバージョン**: バンドルされたバージョンの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` - CLIエントリーポイント（303-305行目）
- E-02: `src/Compilation.zig` - コンパイレーション管理
- E-03: `src/dev.zig` - 機能フラグ管理（cc_command）
- E-04: `lib/libcxx/` - バンドルされたlibc++
- E-05: `lib/libunwind/` - バンドルされたlibunwind
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | zig c++はドロップインC++コンパイラ | E-01 (100行目), E-06 | ○ |
| C-02 | buildOutputTypeに.cppとして渡される | E-01 (303-305行目) | ○ |
| C-03 | dev.check(.cc_command)で機能チェック（ccと共通） | E-01 (304行目), E-03 | ○ |
| C-04 | libc++がバンドルされている | E-04, E-06 (63行目) | ○ |
| C-05 | libunwindがバンドルされている | E-05, E-06 (64行目) | ○ |
| C-06 | 画面No.15がC++コンパイラ画面として関連 | E-07 (30行目) | ○ |
| C-07 | libcxxが補助機能として関連 | E-07 (31行目) | ○ |
| C-08 | Clangバックエンドを使用 | E-02, E-01 (289-293行目) | ○ |
| C-09 | -targetでクロスコンパイル指定 | E-01 (usage_build_generic) | ○ |
| C-10 | LLDリンカを使用 | E-01 (577行目-flld) | ○ |
| C-11 | .cpp, .cxx, .cc, .C, .c++拡張子サポート | E-01 (420行目) | ○ |
| C-12 | -stdでC++標準バージョン指定 | 一般的なClang互換性から推測 | ○ |
| C-13 | -fexceptionsで例外サポート | 一般的なClang互換性から推測 | ○ |
| C-14 | -frttiでRTTIサポート | 一般的なClang互換性から推測 | ○ |
| C-15 | -stdlibでC++標準ライブラリ選択 | 一般的なClang互換性から推測 | ○ |
| C-16 | C++11/14/17/20/23の全サポート詳細 | **根拠不足** | △ |
| C-17 | 例外/RTTIのデフォルト設定詳細 | **根拠不足** | △ |
| C-18 | libc++/libunwindのバージョン | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **C++標準サポート範囲**: Clang互換として一般的な標準をリストしたが、完全なサポート範囲は未確認
  - 候補：Clangドキュメント / テストケース
- **例外/RTTIデフォルト設定**: 一般的なデフォルト値を記載したが、詳細設定は未確認
  - 候補：Compilation.zig内の設定 / ビルドオプション
- **ライブラリバージョン**: バンドルされたlibc++/libunwindのバージョンは未確認
  - 候補：lib/libcxx/内のバージョンファイル / ビルドスクリプト

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 基本的な処理フローの説明
- **0 (低リスク)**: エントリーポイントとバンドルライブラリの関係
- **1 (中リスク)**: C++標準サポート範囲 - Clang依存
- **1 (中リスク)**: デフォルト設定 - 一般的な推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] C-16: C++標準（C++11/14/17/20/23）の完全なサポート状況を確認
- [ ] C-17: 例外/RTTIのデフォルト設定を確認
- [ ] C-18: libc++/libunwindのバンドルバージョンを確認
- [ ] ABI互換性（libstdc++との互換）を確認
