---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：2-build-lib.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **SONAME自動設定の詳細**：実装の詳細根拠が不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 264-266行目 - build-libコマンド判定
- E-02: `src/main.zig` 395-599行目 - usage_build_generic
- E-03: `src/Compilation.zig` 1927-1930行目 - is_dyn_lib判定
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 行3 - build-lib定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング
- E-06: `src/link/Elf.zig` - ELFリンカ存在
- E-07: `src/link/MachO.zig` - MachOリンカ存在
- E-08: `src/link/Coff.zig` - COFFリンカ存在

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | build-libはライブラリを生成する | E-01, E-04 | ○ |
| C-02 | 静的/動的両方に対応 | E-02, E-03 | ○ |
| C-03 | -dynamicで動的ライブラリ指定 | E-02 | ○ |
| C-04 | ArgMode.build(.Lib)で処理 | E-01 | ○ |
| C-05 | is_dyn_libで静的/動的判定 | E-03 | ○ |
| C-06 | 関連画面No.4が対応 | E-05 | ○ |
| C-07 | ELFリンカが存在 | E-06 | ○ |
| C-08 | MachOリンカが存在 | E-07 | ○ |
| C-09 | COFFリンカが存在 | E-08 | ○ |
| C-10 | デフォルトは静的ライブラリ | E-03 | ○ |
| C-11 | 動的ライブラリはPIC必須 | E-02 | ○ |
| C-12 | Windows DLLはインポートライブラリ生成 | E-02 | ○ |
| C-13 | -fPICオプション存在 | E-02 | ○ |
| C-14 | --versionオプション存在 | E-02 | ○ |
| C-15 | -fsonameオプション存在 | E-02 | ○ |
| C-16 | -femit-implibオプション存在 | E-02 | ○ |
| C-17 | Cヘッダ生成オプション存在 | E-02 | ○ |
| C-18 | SONAME自動設定の詳細動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-18 SONAME自動設定**：バージョン指定時のSONAME自動設定の具体的な実装根拠が不足
  - 候補：`src/link/Elf.zig` のsoname関連コード調査

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要、入出力仕様
- 0: 低リスク - 処理フロー

## 6) レビュアーチェックリスト（最小）
- [ ] is_dyn_libの判定ロジックがドキュメントと一致するか確認
- [ ] -dynamicオプションの処理が正しく記載されているか確認
- [ ] SONAME自動設定の実装詳細を追加調査
