---
generated_at: 2026-02-01 18:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：20-objcopy.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**: 具体的な数値目標がソースコードから読み取れない
  2. **ELF to ELF変換の完全な制限事項**: 一部のみ記載

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` - CLIエントリーポイント（321-325行目）
- E-02: `lib/compiler/objcopy.zig` - objcopy実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | zig objcopyはドロップインobjcopy | E-01 (104行目), E-03 | ○ |
| C-02 | jitCmdでobjcopy.zigを呼び出し | E-01 (321-325行目) | ○ |
| C-03 | 画面No.19がObjcopyツール画面として関連 | E-04 (35行目) | ○ |
| C-04 | EmitRawElfOptions構造体の定義 | E-02 (268-275行目) | ○ |
| C-05 | BinaryElfSection構造体の定義 | E-02 (357-363行目) | ○ |
| C-06 | BinaryElfSegment構造体の定義 | E-02 (365-372行目) | ○ |
| C-07 | SectionFlags構造体の定義 | E-02 (715-730行目) | ○ |
| C-08 | cmdObjCopy関数がメイン処理 | E-02 (26-244行目) | ○ |
| C-09 | -O/--output-targetで出力フォーマット指定 | E-02 (55-72行目) | ○ |
| C-10 | --only-sectionで特定セクション抽出 | E-02 (73-80行目) | ○ |
| C-11 | --pad-toでパディング指定 | E-02 (81-86行目) | ○ |
| C-12 | -g/--strip-debugでデバッグ削除 | E-02 (87-88行目) | ○ |
| C-13 | -S/--strip-allで全削除 | E-02 (89-90行目) | ○ |
| C-14 | --only-keep-debugでデバッグのみ保持 | E-02 (91-92行目) | ○ |
| C-15 | 出力フォーマット推論（拡張子から） | E-02 (159-169行目) | ○ |
| C-16 | emitElf関数で変換処理 | E-02 (292-355行目) | ○ |
| C-17 | BinaryElfOutput.parseでELF解析 | E-02 (374-522行目) | ○ |
| C-18 | HexWriter構造体でIntel HEX出力 | E-02 (529-657行目) | ○ |
| C-19 | ELF to ELFはネイティブエンディアンのみ | E-02 (198-199行目) | ○ |
| C-20 | ELF to ELFはプログラムヘッダー必須 | E-02 (200-201行目) | ○ |
| C-21 | パフォーマンス要件の具体的数値 | **根拠なし** | △ |
| C-22 | ELF to ELF変換の完全な制限事項 | **一部のみ確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件**: 具体的な処理速度に関する要件はソースコードから読み取れなかった
  - 候補：ベンチマーク資料 / 開発者ドキュメント
- **ELF to ELF変換の制限**: E-02の197-209行目に複数の制限があるが、完全なリストは要確認
  - 候補：コードの詳細レビュー / テストケース

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 基本的な処理フローの説明
- **0 (低リスク)**: データ構造と関数の説明
- **1 (中リスク)**: ELF to ELF変換の制限事項 - 一部のみ記載

## 6) レビュアーチェックリスト（最小）
- [ ] C-21: パフォーマンス要件の追加情報を確認
- [ ] C-22: ELF to ELF変換の制限事項を197-209行目から完全に確認
- [ ] Intel HEX出力のテストケースを確認
- [ ] セクションフラグの全リストを確認
