---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：21-rc

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし
  2. **一部未サポート機能の詳細**：完全なリストの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main.zig` 309-317行目（rcコマンドディスパッチ）
- E-02: `lib/compiler/resinator/main.zig` 全体（resinatarメイン処理）
- E-03: `lib/compiler/resinator/cli.zig` 14-300行目（CLIオプション定義）
- E-04: `lib/compiler/resinator/cli.zig` 12行目（max_string_literal_length_100_percent = 8192）
- E-05: `lib/compiler/resinator/lex.zig`（default_max_string_literal_codepoints定義）
- E-06: `lib/compiler/resinator/compile.zig`（リソースコンパイル処理）
- E-07: `lib/compiler/resinator/cvtres.zig`（COFF変換処理）
- E-08: `lib/compiler/resinator/preprocess.zig`（Aro連携処理）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 36行目
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` 22行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ZigをMicrosoft rc.exeのドロップイン代替として使用可能 | E-03（usage_string: Drop-in compatible with Microsoft Resource Compiler） | ○ |
| C-02 | .rcファイルを.resまたはCOFFに変換可能 | E-03（OutputFormat enum: res, coff, rcpp） | ○ |
| C-03 | rcコマンドはjitCmdで起動される | E-01（main.zig 309-317行目） | ○ |
| C-04 | Aroプリプロセッサを使用 | E-02、E-08（aro.Compilationの使用） | ○ |
| C-05 | /fo, /d, /u, /i, /l等のオプションをサポート | E-03（usage_string_after_command_name） | ○ |
| C-06 | /:target, /:input-format等のカスタムオプションをサポート | E-03（usage_string 54-79行目） | ○ |
| C-07 | max_string_literal_length_100_percent = 8192 | E-04（cli.zig 12行目） | ○ |
| C-08 | エラー発生時に出力ファイルを削除 | E-02（cleanupAfterError関数の呼び出し） | ○ |
| C-09 | 依存関係ファイルをJSON形式で出力可能 | E-02（depfile_fmt: json） | ○ |
| C-10 | COFF出力時の重複リソースチェック | E-07（DuplicateResourceエラー処理） | ○ |
| C-11 | 画面No.20 RCツール画面と関連 | E-09（画面機能マッピング） | ○ |
| C-12 | resinatarという内部名称 | E-01（cmd_name = "resinator"） | ○ |
| C-13 | X64、ARM64等のターゲットサポート | E-03（/:target説明） | ○ |
| C-14 | 入力形式の自動推論 | E-03（InputFormat enum説明） | ○ |
| C-15 | auto-includesでMSVC/MinGW自動検出 | E-02（getIncludePaths関数） | ○ |
| C-16 | --zig-integrationオプションの存在 | E-02（main.zig 51-54行目） | ○ |
| C-17 | 字句解析・構文解析・コンパイルの3段階処理 | E-02、E-06（処理フロー） | ○ |
| C-18 | コメント除去処理の実行 | E-02（removeComments呼び出し 271行目） | ○ |
| C-19 | #lineコマンドの解析 | E-02（parseAndRemoveLineCommands呼び出し 248行目） | ○ |
| C-20 | MUI、LCX/LCE関連は未サポート | E-03（Unsupported Win32 RC Options） | ○ |
| C-21 | 入力ファイル存在しない場合.rc拡張子を補完 | E-03（maybeAppendRC関数 257-274行目） | ○ |
| C-22 | ResourceDataTooLongエラー | E-07（cvtres.zig） | ○ |
| C-23 | Windows-1252エンコーディングがデフォルト | E-02（default_code_page: .windows1252 268行目） | ○ |
| C-24 | 典型的な.rcファイルのコンパイルは1秒以内 | **根拠なし** | △ |
| C-25 | シンボリックリンク攻撃への対策 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-24**: パフォーマンス要件の数値は推定値であり、ベンチマークテスト結果等の具体的な根拠なし
  - 候補：ベンチマークテスト / パフォーマンステスト結果 / 実測データ
- **C-25**: セキュリティ対策に関する明示的なコード確認が不足
  - 候補：セキュリティレビュードキュメント / コードコメント / テストケース

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 機能の基本的な説明（E-01〜E-10で十分に裏付け）
- **1（中リスク）**: パフォーマンス要件（推定値のため実測での確認推奨）
- **1（中リスク）**: セキュリティ考慮事項（一般的なセキュリティプラクティスに基づく記述）

## 6) レビュアーチェックリスト（最小）
- [ ] rc.exe互換性の範囲が正確に記述されているか確認
- [ ] サポート/未サポートオプションの一覧が最新か確認
- [ ] エラーメッセージ形式がコードと一致しているか確認
- [ ] パフォーマンス要件が実際の使用状況に適合しているか確認
- [ ] 関連ファイル一覧に漏れがないか確認
