---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-help

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 77-119行目（normal_usage定数）
- E-02: `src/main.zig` 121-130行目（debug_usage定数）
- E-03: `src/main.zig` 132行目（usage定数の条件分岐）
- E-04: `src/main.zig` 376-378行目（helpコマンドディスパッチ）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 2行目
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` 24行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | help/-h/--helpの3形式をサポート | E-04（376行目: or条件） | ○ |
| C-02 | normal_usageにコマンド一覧を含む | E-01（77-119行目） | ○ |
| C-03 | debug_usageにデバッグコマンドを含む | E-02（121-130行目: changelist, dump-zir等） | ○ |
| C-04 | enable_debug_extensionsで切り替え | E-03（132行目: if (build_options.enable_debug_extensions)） | ○ |
| C-05 | Io.File.stdout().writeStreamingAllで出力 | E-04（378行目） | ○ |
| C-06 | dev.check(.help_command)を呼び出し | E-04（377行目） | ○ |
| C-07 | buildコマンドの説明を含む | E-01（82行目: Build project from build.zig） | ○ |
| C-08 | ccコマンドの説明を含む | E-01（99行目: Use Zig as a drop-in C compiler） | ○ |
| C-09 | rcコマンドの説明を含む | E-01（105行目: Use Zig as a drop-in rc.exe） | ○ |
| C-10 | zenコマンドの説明を含む | E-01（113行目: Print Zen of Zig and exit） | ○ |
| C-11 | 画面No.1 ヘルプ画面と関連 | E-05 | ○ |
| C-12 | 機能説明はhelp関連 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 非常に単純な文字列出力機能であり、コードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 出力例のコマンド一覧が実際のusage文字列と一致しているか確認
- [ ] デバッグコマンドの一覧が最新か確認
