---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-std

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 334-341行目（stdコマンドディスパッチ）
- E-02: `lib/compiler/std-docs.zig` 10-22行目（usage関数）
- E-03: `lib/compiler/std-docs.zig` 24-89行目（main関数）
- E-04: `lib/compiler/std-docs.zig` 58行目（ブラウザ起動判定）
- E-05: `lib/compiler/std-docs.zig` 60-64行目（HTTPサーバー起動）
- E-06: `lib/compiler/std-docs.zig` 134-160行目（serveRequest関数）
- E-07: `lib/compiler/std-docs.zig` 162-166行目（cache_control_header）
- E-08: `lib/compiler/std-docs.zig` 246-279行目（serveWasm関数）
- E-09: `lib/compiler/std-docs.zig` 285-425行目（buildWasmBinary関数）
- E-10: `lib/compiler/std-docs.zig` 438-458行目（openBrowserTabTask関数）
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 38行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | jitCmdでstd-docs.zigを実行 | E-01（root_src_path: "std-docs.zig"） | ○ |
| C-02 | デフォルトポートは0（エフェメラル） | E-03（39行目: listen_port: u16 = 0） | ○ |
| C-03 | -p/--portでポート指定可能 | E-03（44-48行目） | ○ |
| C-04 | --open-browserでブラウザ起動強制 | E-03（49-50行目） | ○ |
| C-05 | --no-open-browserでブラウザ非起動 | E-03（51-52行目） | ○ |
| C-06 | ポート未指定時はブラウザ自動起動 | E-04（should_open_browser = ... (listen_port == 0)） | ○ |
| C-07 | 127.0.0.1でのみリッスン | E-05（IpAddress.parse("127.0.0.1"...）） | ○ |
| C-08 | "/"でindex.htmlを配信 | E-06（139行目） | ○ |
| C-09 | "/main.js"でmain.jsを配信 | E-06（140-143行目） | ○ |
| C-10 | "/main.wasm"でReleaseFast WASMを配信 | E-06（144-145行目: .ReleaseFast） | ○ |
| C-11 | "/debug/main.wasm"でDebug WASMを配信 | E-06（146-147行目: .Debug） | ○ |
| C-12 | "/sources.tar"でソースtarを配信 | E-06（148-151行目） | ○ |
| C-13 | キャッシュ制御ヘッダを設定 | E-07（max-age=0, must-revalidate） | ○ |
| C-14 | リクエストごとにWASMを再ビルド | E-08（buildWasmBinary呼び出し） | ○ |
| C-15 | zig build-exeでWASMをビルド | E-09（296行目: "build-exe"） | ○ |
| C-16 | Windows: explorerでブラウザ起動 | E-10（447行目: .windows => "explorer"） | ○ |
| C-17 | macOS: openでブラウザ起動 | E-10（448行目: .macos => "open"） | ○ |
| C-18 | その他: xdg-openでブラウザ起動 | E-10（449行目: else => "xdg-open"） | ○ |
| C-19 | wasm32-freestandingターゲット | E-09（300行目: autodoc_arch_os_abi） | ○ |
| C-20 | 画面No.22と関連 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: HTTPサーバーとWASMビルドの動作がコードで明確に確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] HTTPルーティングのパスが最新か確認
- [ ] WASMビルドオプションが正確か確認
- [ ] ブラウザ起動コマンドがプラットフォームごとに正しいか確認
