---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-targets

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 344-349行目（targetsコマンドディスパッチ）
- E-02: `src/print_targets.zig` 15-137行目（cmdTargets関数）
- E-03: `src/print_targets.zig` 23-26行目（Zigライブラリディレクトリ検出）
- E-04: `src/print_targets.zig` 28-40行目（glibc abilists読み込み）
- E-05: `src/print_targets.zig` 42行目（ZONシリアライザ初期化）
- E-06: `src/print_targets.zig` 47-49行目（arch/os/abi出力）
- E-07: `src/print_targets.zig` 51-59行目（libc一覧出力）
- E-08: `src/print_targets.zig` 61-69行目（glibcバージョン出力）
- E-09: `src/print_targets.zig` 71-88行目（CPUモデル出力）
- E-10: `src/print_targets.zig` 90-100行目（CPUフィーチャー出力）
- E-11: `src/print_targets.zig` 102-131行目（ネイティブ情報出力）
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 40行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cmdTargets関数でターゲット一覧を出力 | E-01、E-02 | ○ |
| C-02 | introspect.findZigLibDirでライブラリディレクトリ検出 | E-03 | ○ |
| C-03 | glibc abilistsファイルを読み込み | E-04（glibc.abilists_path） | ○ |
| C-04 | glibc.loadMetaDataでメタデータをパース | E-04（39行目） | ○ |
| C-05 | std.zon.Serializerで出力 | E-05 | ○ |
| C-06 | meta.fieldNamesでarch/os/abiを列挙 | E-06 | ○ |
| C-07 | available_libcsでlibc一覧を出力 | E-07（53行目） | ○ |
| C-08 | all_versionsでglibcバージョンを出力 | E-08（63行目） | ○ |
| C-09 | allCpuModels()でCPUモデルを列挙 | E-09（75行目） | ○ |
| C-10 | allFeaturesList()でCPUフィーチャーを列挙 | E-09（77行目）、E-10（94行目） | ○ |
| C-11 | native_targetでネイティブ情報を出力 | E-11 | ○ |
| C-12 | zigTriple()でトリプル文字列を生成 | E-11（105行目） | ○ |
| C-13 | native.cpuにアーキテクチャと名前を含む | E-11（110-113行目） | ○ |
| C-14 | native.cpuにフィーチャー一覧を含む | E-11（115-124行目） | ○ |
| C-15 | native.osにOS情報を含む | E-11（128行目） | ○ |
| C-16 | native.abiにABI情報を含む | E-11（129行目） | ○ |
| C-17 | 最後に改行を出力 | E-02（136行目: writeByte('\n')） | ○ |
| C-18 | 画面No.24と関連 | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: ターゲット情報の列挙機能でコードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 出力ZON形式の例が実際の出力と一致しているか確認
- [ ] サポートされるターゲット一覧が最新か確認
- [ ] ネイティブ情報の形式が正確か確認
