---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-zen

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 373-375行目（zenコマンドディスパッチ）
- E-02: `src/main.zig` 5752-5769行目（info_zen定数）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 42行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | zenコマンドでZenを表示 | E-01（373行目: mem.eql(u8, cmd, "zen")） | ○ |
| C-02 | dev.check(.zen_command)を呼び出し | E-01（374行目） | ○ |
| C-03 | info_zenを出力 | E-01（375行目） | ○ |
| C-04 | writeStreamingAllで出力 | E-01（375行目） | ○ |
| C-05 | "Communicate intent precisely"を含む | E-02（5754行目） | ○ |
| C-06 | "Edge cases matter"を含む | E-02（5755行目） | ○ |
| C-07 | "Together we serve the users"を含む | E-02（5766行目） | ○ |
| C-08 | 13項目のZen原則を含む | E-02（5754-5766行目: 13行） | ○ |
| C-09 | 箇条書き形式（* で始まる） | E-02（各行が " * "で始まる） | ○ |
| C-10 | 画面No.26と関連 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 非常に単純な文字列出力機能

## 6) レビュアーチェックリスト（最小）
- [ ] Zen原則の内容が最新か確認
- [ ] 各原則の日本語解説が適切か確認
