---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：29-LLVMバックエンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **最適化パイプラインの詳細**：実装詳細の確認が必要
  2. **デバッグ情報生成の詳細**：DWARF生成部分の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/codegen/llvm.zig` 1-41行目（インポートと定数定義）
- E-02: `src/codegen/llvm.zig` 43-48行目（legalizeFeatures関数）
- E-03: `src/codegen/llvm.zig` 58-324行目（targetTriple関数）
- E-04: `src/codegen/llvm.zig` 326-334行目（supportsTailCall関数）
- E-05: `src/codegen/llvm.zig` 336-493行目（dataLayout関数）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 7-16行目
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` 30行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LLVMを使用してネイティブコードを生成 | E-07 | ○ |
| C-02 | std.zig.llvm.Builderを使用 | E-01（10行目: Builder = std.zig.llvm.Builder） | ○ |
| C-03 | build_options.have_llvmで利用可否を判定 | E-01（13-16行目） | ○ |
| C-04 | targetTriple関数でLLVMトリプルを生成 | E-03 | ○ |
| C-05 | x86_64はx86_64として変換 | E-03（97行目） | ○ |
| C-06 | aarch64はilp32の場合aarch64_32に変換 | E-03（65行目） | ○ |
| C-07 | dataLayout関数でデータレイアウトを取得 | E-05 | ○ |
| C-08 | x86_64のデータレイアウトがClangと一致 | E-05（449-457行目）、コメント337行目 | ○ |
| C-09 | supportsTailCallでテールコールサポートを判定 | E-04 | ○ |
| C-10 | MIPS/PowerPCはテールコール非サポート | E-04（330-331行目） | ○ |
| C-11 | WASMはtail_callフィーチャーで判定 | E-04（328行目） | ○ |
| C-12 | legalizeFeatures関数を提供 | E-02 | ○ |
| C-13 | Error型はOutOfMemoryとCodegenFail | E-01（41行目） | ○ |
| C-14 | 実行ファイルビルド画面と関連 | E-06（7行目） | ○ |
| C-15 | ライブラリビルド画面と関連 | E-06（13行目） | ○ |
| C-16 | 一部アーキテクチャはLLVM非サポート | E-03（112-126行目、477-491行目のunreachable） | ○ |
| C-17 | ABI変換にmuslの特殊処理あり | E-05（287-292行目: WASI/Emscriptenはunknown） | ○ |
| C-18 | バージョン情報をトリプルに含める | E-03（255-269行目、307-321行目） | ○ |
| C-19 | 最適化パイプラインの詳細 | **根拠なし（読み込み範囲外）** | △ |
| C-20 | デバッグ情報（DWARF）生成 | **根拠なし（読み込み範囲外）** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-19**: 最適化パイプラインの詳細実装は読み込み範囲外のため確認できず
  - 候補：llvm.zigの後半部分 / LLVMパスマネージャ関連コード
- **C-20**: DWARF生成の詳細は読み込み範囲外のため確認できず
  - 候補：デバッグ情報生成関連コード / DW定数の使用箇所

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: ターゲットトリプル生成、データレイアウト、テールコールサポート判定
- **1（中リスク）**: 最適化パイプラインとデバッグ情報生成の詳細（読み込み範囲外）

## 6) レビュアーチェックリスト（最小）
- [ ] サポートアーキテクチャ一覧が最新か確認
- [ ] データレイアウト文字列がClangと一致しているか確認
- [ ] テールコール非サポートアーキテクチャが正確か確認
- [ ] 最適化パイプラインの記述が実装と一致するか確認（llvm.zig後半）
