---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-build-obj.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 267-269行目 - build-objコマンド判定
- E-02: `src/main.zig` 395-599行目 - usage_build_generic（-ofmtオプション含む）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 行4 - build-obj定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング
- E-05: `src/codegen/c.zig` - Cバックエンド存在
- E-06: `src/link/SpirV.zig` - SPIR-V生成存在

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | build-objはオブジェクトファイルを生成する | E-01, E-03 | ○ |
| C-02 | ELF、Mach-O、COFF、WASM形式に対応 | E-02, E-03 | ○ |
| C-03 | ArgMode.build(.Obj)で処理 | E-01 | ○ |
| C-04 | -ofmtオプションで出力形式指定可能 | E-02 | ○ |
| C-05 | elf/coff/macho/wasm/c/spirv/plan9形式対応 | E-02 | ○ |
| C-06 | 関連画面No.5が対応 | E-04 | ○ |
| C-07 | Cバックエンド存在 | E-05 | ○ |
| C-08 | SPIR-Vバックエンド存在 | E-06 | ○ |
| C-09 | リンク処理は行わない | E-01 | ○ |
| C-10 | -fPICオプション存在 | E-02 | ○ |
| C-11 | -mcpuオプション存在 | E-02 | ○ |
| C-12 | -Oオプションで最適化モード指定 | E-02 | ○ |
| C-13 | --nameオプションで出力名指定 | E-02 | ○ |
| C-14 | -targetオプションでターゲット指定 | E-02 | ○ |
| C-15 | Cソースファイルもサポート | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目

## 6) レビュアーチェックリスト（最小）
- [ ] -ofmtオプションのサポート形式がusage_build_genericと一致するか確認
- [ ] output_mode = .Objの処理がドキュメントと一致するか確認
