---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：30-x86_64バックエンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **インクリメンタルコンパイルの詳細**：実装詳細の確認が必要
  2. **リロケーション生成の詳細**：Emit.zig等の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/codegen/x86_64/CodeGen.zig` 1-35行目（インポート）
- E-02: `src/codegen/x86_64/CodeGen.zig` 36-77行目（legalizeFeatures関数）
- E-03: `src/codegen/x86_64/CodeGen.zig` 79-82行目（hack_around_sema_opv_bugs、err_ret_trace_index）
- E-04: `src/codegen/x86_64/CodeGen.zig` 84-165行目（構造体フィールド定義）
- E-05: `src/codegen/x86_64/CodeGen.zig` 173-467行目（MCValue union）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 53行目
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` 31行目
- E-08: Globでのファイル一覧（x86_64ディレクトリ構成）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | x86_64アーキテクチャ向けコード生成 | E-07 | ○ |
| C-02 | AIRからMIRへの変換を行う | E-01（Air、Mir import） | ○ |
| C-03 | legalizeFeatures関数を提供 | E-02 | ○ |
| C-04 | scalarize_mul_satを含む | E-02（38行目） | ○ |
| C-05 | scalarize_div_floorを含む | E-02（39行目） | ○ |
| C-06 | expand_intcast_safeを含む | E-02（65行目） | ○ |
| C-07 | expand_packed_loadを含む | E-02（72行目） | ○ |
| C-08 | expand_packed_storeを含む | E-02（73行目） | ○ |
| C-09 | MCValue unionで値位置を表現 | E-05 | ○ |
| C-10 | MCValue.noneが存在 | E-05（177行目） | ○ |
| C-11 | MCValue.unreachが存在 | E-05（179行目） | ○ |
| C-12 | MCValue.immediateが存在 | E-05（187行目） | ○ |
| C-13 | MCValue.registerが存在 | E-05（191行目） | ○ |
| C-14 | MCValue.register_pairが存在 | E-05（193行目） | ○ |
| C-15 | MCValue.memoryが存在 | E-05（206行目） | ○ |
| C-16 | MCValue.load_frameが存在 | E-05（212行目） | ○ |
| C-17 | RegisterManagerを使用 | E-04（138行目: register_manager） | ○ |
| C-18 | InnerErrorにOutOfRegistersを含む | E-01（34行目） | ○ |
| C-19 | 実行ファイルビルド画面と関連 | E-06 | ○ |
| C-20 | x86_64ディレクトリに複数ファイルが存在 | E-08（CodeGen、Mir、Emit、Lower等） | ○ |
| C-21 | インクリメンタルコンパイルの詳細 | **根拠なし（読み込み範囲外）** | △ |
| C-22 | リロケーション生成の詳細 | **根拠なし（読み込み範囲外）** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-21**: インクリメンタルコンパイルの実装詳細は読み込み範囲外
  - 候補：Compilation.zig / link関連ファイル
- **C-22**: リロケーション生成の詳細はEmit.zig等の確認が必要
  - 候補：Emit.zig / link/Elf.zig等

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: legalizeFeatures、MCValue定義
- **1（中リスク）**: インクリメンタルコンパイルとリロケーション生成（読み込み範囲外）

## 6) レビュアーチェックリスト（最小）
- [ ] MCValueの全種類が網羅されているか確認
- [ ] legalizeFeatures の全項目が最新か確認
- [ ] RegisterManagerの動作が正確に記述されているか確認
- [ ] Emit.zigのリロケーション生成を確認（読み込み範囲外）
